/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout;

import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.utils.TestDirectory;

@Neo4jLayoutExtension
class DatabaseLayoutTest {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private Neo4jLayout neo4jLayout;
    @Inject
    private DatabaseLayout databaseLayout;

    DatabaseLayoutTest() {
    }

    @Test
    void databaseLayoutForAbsoluteFile() {
        Path databaseDir = this.testDirectory.directory("neo4j");
        DatabaseLayout databaseLayout = DatabaseLayout.ofFlat((Path)databaseDir);
        Assertions.assertEquals((Object)databaseLayout.databaseDirectory(), (Object)databaseDir);
    }

    @Test
    void databaseLayoutResolvesLinks() throws IOException {
        Path symbolicLink;
        Path databaseDir;
        block2: {
            Path basePath = this.testDirectory.homePath();
            databaseDir = this.databaseLayout.databaseDirectory();
            Path linkPath = basePath.resolve("link");
            symbolicLink = null;
            try {
                symbolicLink = Files.createSymbolicLink(linkPath, databaseDir, new FileAttribute[0]);
            }
            catch (FileSystemException e) {
                if (!e.getMessage().contains("privilege")) break block2;
                Assumptions.assumeTrue((boolean)false, (String)("Permission issues creating symbolic links in this environment: " + e));
            }
        }
        DatabaseLayout databaseLayout = DatabaseLayout.ofFlat((Path)symbolicLink);
        Assertions.assertEquals((Object)databaseLayout.databaseDirectory(), (Object)databaseDir);
    }

    @Test
    void databaseLayoutUseCanonicalRepresentation() {
        Path dbDir = this.testDirectory.directory("notCanonical");
        Path notCanonicalPath = dbDir.resolve("../anotherdatabase");
        DatabaseLayout databaseLayout = DatabaseLayout.ofFlat((Path)notCanonicalPath);
        Assertions.assertEquals((Object)this.testDirectory.directory("anotherdatabase"), (Object)databaseLayout.databaseDirectory());
    }

    @Test
    void databaseLayoutForName() {
        String databaseName = "testdatabase";
        Neo4jLayout storeLayout = this.neo4jLayout;
        DatabaseLayout testDatabase = storeLayout.databaseLayout(databaseName);
        Assertions.assertEquals((Object)storeLayout.databasesDirectory().resolve(databaseName), (Object)testDatabase.databaseDirectory());
    }

    @Test
    void databaseLayoutForFolderAndName() {
        String database = "database";
        DatabaseLayout databaseLayout = this.neo4jLayout.databaseLayout(database);
        Assertions.assertEquals((Object)database, (Object)databaseLayout.databaseDirectory().getFileName().toString());
    }

    @Test
    void databaseLayoutProvideCorrectDatabaseName() {
        Assertions.assertEquals((Object)"neo4j", (Object)this.databaseLayout.getDatabaseName());
        Assertions.assertEquals((Object)"testdb", (Object)this.neo4jLayout.databaseLayout("testdb").getDatabaseName());
    }

    @Test
    void storeFilesThrowsForPlainLayout() {
        String database = "database";
        DatabaseLayout databaseLayout = this.neo4jLayout.databaseLayout(database);
        Assertions.assertThrows(IllegalStateException.class, () -> ((DatabaseLayout)databaseLayout).storeFiles());
    }

    @Test
    void mandatoryStoreFilesThrowsForPlainLayout() {
        String database = "database";
        DatabaseLayout databaseLayout = this.neo4jLayout.databaseLayout(database);
        Assertions.assertThrows(IllegalStateException.class, () -> ((DatabaseLayout)databaseLayout).mandatoryStoreFiles());
    }
}

