/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.tracing.DummyPageSwapper;
import org.neo4j.util.concurrent.Futures;
import org.opentest4j.AssertionFailedError;

class SwapperSetTest {
    private SwapperSet set;

    SwapperSetTest() {
    }

    @BeforeEach
    void setUp() {
        this.set = new SwapperSet();
    }

    @Test
    void mustReturnAllocationWithSwapper() {
        DummyPageSwapper a = new DummyPageSwapper("a", 42);
        DummyPageSwapper b = new DummyPageSwapper("b", 43);
        int idA = this.set.allocate((PageSwapper)a);
        int idB = this.set.allocate((PageSwapper)b);
        SwapperSet.SwapperMapping allocA = this.set.getAllocation(idA);
        SwapperSet.SwapperMapping allocB = this.set.getAllocation(idB);
        Assertions.assertThat((Object)allocA.swapper).isEqualTo((Object)a);
        Assertions.assertThat((Object)allocB.swapper).isEqualTo((Object)b);
    }

    @Test
    void accessingFreedAllocationMustReturnNull() {
        int id = this.set.allocate((PageSwapper)new DummyPageSwapper("a", 42));
        this.set.free(id);
        org.junit.jupiter.api.Assertions.assertNull((Object)this.set.getAllocation(id));
    }

    @Test
    void doubleFreeMustThrow() {
        int id = this.set.allocate((PageSwapper)new DummyPageSwapper("a", 42));
        this.set.free(id);
        IllegalStateException exception = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.set.free(id));
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"double free"});
    }

    @Test
    void freedCandidateIdsMustNotBeReusedBeforeVacuum() {
        DummyPageSwapper swapper = new DummyPageSwapper("a", 42);
        IntHashSet ids = new IntHashSet(10000);
        for (int i = 0; i < 10000; ++i) {
            this.allocateFreeAndAssertNotReused(swapper, (MutableIntSet)ids, i);
        }
    }

    @Test
    void freeCandidatesAllocationsMustBecomeAvailableAfterSweep() {
        IntHashSet allocated = new IntHashSet();
        IntHashSet freedCandidates = new IntHashSet();
        IntHashSet reused = new IntHashSet();
        DummyPageSwapper swapper = new DummyPageSwapper("a", 42);
        this.allocateAndAddTwentyThousand((MutableIntSet)allocated, swapper);
        allocated.forEach(arg_0 -> this.lambda$freeCandidatesAllocationsMustBecomeAvailableAfterSweep$c5b3d615$1((MutableIntSet)freedCandidates, arg_0));
        this.set.sweep(any -> {});
        this.allocateAndAddTwentyThousand((MutableIntSet)reused, swapper);
        Assertions.assertThat((Object)allocated).isEqualTo((Object)freedCandidates);
        Assertions.assertThat((Object)allocated).isEqualTo((Object)reused);
    }

    @Test
    void sweepMustNotDustOffAnyIdsWhenNoneHaveBeenFreed() {
        DummyPageSwapper swapper = new DummyPageSwapper("a", 42);
        for (int i = 0; i < 100; ++i) {
            this.set.allocate((PageSwapper)swapper);
        }
        IntHashSet sweedIds = new IntHashSet();
        this.set.sweep(arg_0 -> ((MutableIntSet)sweedIds).addAll(arg_0));
        if (!sweedIds.isEmpty()) {
            throw new AssertionError((Object)("Vacuum found id " + (MutableIntSet)sweedIds + " when it should have found nothing"));
        }
    }

    @Test
    void mustNotUseZeroAsSwapperId() {
        DummyPageSwapper swapper = new DummyPageSwapper("a", 42);
        for (int i = 0; i < 10000; ++i) {
            Assertions.assertThat((int)this.set.allocate((PageSwapper)swapper)).isNotZero();
        }
    }

    @Test
    void gettingAllocationZeroMustThrow() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.set.getAllocation(0));
    }

    @Test
    void freeOfIdZeroMustThrow() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.set.free(0));
    }

    @Test
    void eventuallyBeEligableForIdSweep() {
        int id = 1;
        while (this.set.skipSweep()) {
            this.set.postponedFree(id++);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.set.allocate((PageSwapper)new DummyPageSwapper("any", 8)));
    }

    @Test
    void allocateDeallocateReuseSameIds() {
        MutableIntList allocationIds = IntLists.mutable.withInitialCapacity(1000);
        for (int j = 0; j < 10; ++j) {
            for (int i = 0; i < 100; ++i) {
                allocationIds.add(this.set.allocate((PageSwapper)new DummyPageSwapper("b", 43)));
            }
            allocationIds.forEach((IntProcedure & Serializable)id -> this.set.free(id));
            allocationIds.clear();
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.set.allocate((PageSwapper)new DummyPageSwapper("c", 43)));
    }

    @Test
    void sweepReuseDelayedIds() {
        DummyPageSwapper swapper = new DummyPageSwapper("b", 43);
        while (this.set.skipSweep()) {
            this.set.postponedFree(this.set.allocate((PageSwapper)swapper));
        }
        MutableIntSet observedIds = IntSets.mutable.empty();
        this.set.sweep(arg_0 -> ((MutableIntSet)observedIds).addAll(arg_0));
        for (int i = 1; i <= observedIds.size(); ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)observedIds.contains(i), (String)"Should contain whole range of ids");
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.set.allocate((PageSwapper)swapper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedTest(value=10)
    void concurrentSweepAttemptsShouldNotFreeIdsMultipleTimes() throws ExecutionException {
        int numberOfExecutors = 20;
        ExecutorService executors = Executors.newFixedThreadPool(numberOfExecutors);
        try {
            DummyPageSwapper swapper = new DummyPageSwapper("b", 43);
            while (this.set.skipSweep()) {
                this.set.postponedFree(this.set.allocate((PageSwapper)swapper));
            }
            CountDownLatch latch = new CountDownLatch(1);
            ArrayList<Future<MutableIntSet>> results = new ArrayList<Future<MutableIntSet>>();
            for (int i = 0; i < numberOfExecutors; ++i) {
                results.add(executors.submit(() -> {
                    latch.await();
                    MutableIntSet observedIds = IntSets.mutable.empty();
                    this.set.sweep(arg_0 -> ((MutableIntSet)observedIds).addAll(arg_0));
                    return observedIds;
                }));
                latch.countDown();
            }
            Futures.getAll(results);
            Assertions.assertThat(results).satisfies(new ThrowingConsumer[]{futures -> {
                MutableIntSet nonEmptyResult = null;
                for (Future future : futures) {
                    try {
                        MutableIntSet ids = (MutableIntSet)future.get();
                        if (ids.isEmpty()) continue;
                        if (nonEmptyResult == null) {
                            nonEmptyResult = ids;
                            continue;
                        }
                        throw new AssertionFailedError("Expected to see only single non empty result set but got at least 2: " + nonEmptyResult + ", and " + ids);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                org.junit.jupiter.api.Assertions.assertNotNull(nonEmptyResult);
            }});
        }
        finally {
            executors.shutdown();
        }
    }

    private void allocateAndAddTwentyThousand(MutableIntSet allocated, PageSwapper swapper) {
        for (int i = 0; i < 20000; ++i) {
            this.allocateAndAdd(allocated, swapper);
        }
    }

    private void allocateAndAdd(MutableIntSet allocated, PageSwapper swapper) {
        int id = this.set.allocate(swapper);
        allocated.add(id);
    }

    private void allocateFreeAndAssertNotReused(PageSwapper swapper, MutableIntSet ids, int i) {
        int id = this.set.allocate(swapper);
        this.set.postponedFree(id);
        if (!ids.add(id)) {
            org.junit.jupiter.api.Assertions.fail((String)("Expected ids.add( id ) to return true for id " + id + " in iteration " + i + " but it instead returned false"));
        }
    }

    private /* synthetic */ void lambda$freeCandidatesAllocationsMustBecomeAvailableAfterSweep$c5b3d615$1(MutableIntSet freedCandidates, int id) {
        this.set.postponedFree(id);
        freedCandidates.add(id);
    }
}

