/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.community.edition;

import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
public class CommunityDependenciesIT {
    @Inject
    private TestDirectory testDirectory;
    private DatabaseManagementService dbms;

    @BeforeEach
    void setUp() {
        this.dbms = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).build();
    }

    @AfterEach
    void tearDown() {
        this.dbms.shutdown();
    }

    @Test
    void ensureHasTheCorrectDependencies() {
        DependencyResolver dependencyResolver = ((GraphDatabaseAPI)this.dbms.database("neo4j")).getDependencyResolver();
        AssertionsForClassTypes.assertThat((Object)((TopologyGraphDbmsModel.HostedOnMode)dependencyResolver.resolveDependency(TopologyGraphDbmsModel.HostedOnMode.class))).isEqualTo((Object)TopologyGraphDbmsModel.HostedOnMode.SINGLE);
    }
}

