/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout;

import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class Neo4jLayoutTest {
    @Inject
    private TestDirectory testDirectory;

    Neo4jLayoutTest() {
    }

    @Test
    void storeLayoutForAbsoluteFile() {
        Path storeDir = this.testDirectory.directory("store");
        Neo4jLayout storeLayout = Neo4jLayout.of((Configuration)Config.defaults((Setting)GraphDatabaseInternalSettings.databases_root_path, (Object)storeDir));
        Assertions.assertEquals((Object)storeDir, (Object)storeLayout.databasesDirectory());
    }

    @Test
    void storeLayoutResolvesLinks() throws IOException {
        Path symbolicLink;
        Path storeDir;
        block2: {
            Path basePath = this.testDirectory.homePath();
            storeDir = this.testDirectory.homePath("notAbsolute");
            Path linkPath = basePath.resolve("link");
            symbolicLink = null;
            try {
                symbolicLink = Files.createSymbolicLink(linkPath, storeDir, new FileAttribute[0]);
            }
            catch (FileSystemException e) {
                if (!e.getMessage().contains("privilege")) break block2;
                Assumptions.assumeTrue((boolean)false, (String)("Permission issues creating symbolic links in this environment: " + e));
            }
        }
        Neo4jLayout storeLayout = Neo4jLayout.of((Configuration)Config.defaults((Setting)GraphDatabaseInternalSettings.databases_root_path, (Object)symbolicLink));
        Assertions.assertEquals((Object)storeDir, (Object)storeLayout.databasesDirectory());
    }

    @Test
    void storeLayoutUseCanonicalRepresentation() {
        Path basePath = this.testDirectory.homePath("notCanonical");
        Path notCanonicalPath = basePath.resolve("../anotherLocation");
        Neo4jLayout storeLayout = Neo4jLayout.of((Path)notCanonicalPath);
        Assertions.assertEquals((Object)this.testDirectory.directory("anotherLocation"), (Object)storeLayout.homeDirectory());
    }

    @Test
    void storeLockFileLocation() {
        Neo4jLayout layout = Neo4jLayout.of((Path)this.testDirectory.homePath());
        Path storeLockFile = layout.storeLockFile();
        Assertions.assertEquals((Object)"store_lock", (Object)storeLockFile.getFileName().toString());
        Assertions.assertEquals((Object)layout.databasesDirectory(), (Object)storeLockFile.getParent());
    }

    @Test
    void serverIdFileLocation() {
        Neo4jLayout layout = Neo4jLayout.of((Path)this.testDirectory.homePath());
        Path serverIdFile = layout.serverIdFile();
        Assertions.assertEquals((Object)"server_id", (Object)serverIdFile.getFileName().toString());
        Assertions.assertEquals((Object)this.testDirectory.directory("data"), (Object)serverIdFile.getParent());
    }

    @Test
    void emptyStoreLayoutDatabasesCollection() {
        Neo4jLayout storeLayout = Neo4jLayout.of((Path)this.testDirectory.homePath());
        Assertions.assertTrue((boolean)storeLayout.databaseLayouts().isEmpty());
    }

    @Test
    void storeLayoutDatabasesOnlyBasedOnSubfolders() throws IOException {
        Path homeDirectory = this.testDirectory.homePath();
        Neo4jLayout layout = Neo4jLayout.of((Path)homeDirectory);
        Path databases = homeDirectory.resolve("data").resolve("databases");
        Files.createDirectories(databases.resolve("abc"), new FileAttribute[0]);
        Files.createDirectories(databases.resolve("bcd"), new FileAttribute[0]);
        Files.createFile(databases.resolve("cde"), new FileAttribute[0]);
        Collection layouts = layout.databaseLayouts();
        Assertions.assertEquals((int)2, (int)layouts.size());
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new String[]{"abc", "bcd"}), layouts.stream().map(DatabaseLayout::getDatabaseName).collect(Collectors.toSet()));
    }
}

