/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.io.pagecache.impl.muninn.AbstractPageListTest;
import org.neo4j.io.pagecache.impl.muninn.PageList;
import org.neo4j.util.concurrent.Futures;

class MultiversionedPageListTest
extends AbstractPageListTest {
    MultiversionedPageListTest() {
    }

    @BeforeEach
    void setUp() {
        this.multiVersioned = true;
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    void onlySingleWriteLockIsSupportedForMultiVersionedPage(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        Assertions.assertFalse((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    void writeLocksMustBlockPreventWriteLocksInOtherThreads(int pageId) {
        this.init(pageId);
        Assertions.assertTimeoutPreemptively((Duration)TIMEOUT, () -> {
            PageList.unlockExclusive((long)this.pageRef);
            Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
            int threads = 10;
            CountDownLatch end = new CountDownLatch(threads);
            Runnable runnable = () -> {
                Assertions.assertFalse((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
                end.countDown();
            };
            ArrayList futures = new ArrayList();
            for (int i = 0; i < threads; ++i) {
                futures.add(this.executor.submit(runnable));
            }
            end.await();
            Futures.getAll(futures);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    void concurrentWriteFailedLocksDoNotFailExclusiveLocks(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        Assertions.assertFalse((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        PageList.unlockWrite((long)this.pageRef);
        Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    void unlockExclusiveAndTakeWriteLockMustNotAllowConcurrentWriteLocks(int pageId) {
        this.init(pageId);
        Assertions.assertTimeoutPreemptively((Duration)TIMEOUT, () -> {
            PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
            Assertions.assertFalse((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    void impossibleToTakeAnotherWriteLockWhenTransitionedFromExclusiveToWriteLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        Assertions.assertFalse((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    void concurrentWriteShouldBeBlocked(int pageId) throws InterruptedException, ExecutionException {
        this.init(pageId);
        PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned);
        int threads = 10;
        AtomicLong locksSneaked = new AtomicLong();
        AtomicBoolean execute = new AtomicBoolean(true);
        Runnable runnable = () -> {
            while (execute.get() && !PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned)) {
            }
            locksSneaked.getAndIncrement();
        };
        ArrayList futures = new ArrayList();
        for (int i = 0; i < threads; ++i) {
            futures.add(this.executor.submit(runnable));
        }
        TimeUnit.SECONDS.sleep(ThreadLocalRandom.current().nextInt(5));
        Assertions.assertEquals((long)0L, (long)locksSneaked.get());
        execute.set(false);
        Futures.getAll(futures);
    }
}

