/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.EphemeralPageCacheExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;

class MunninPageCacheCloseIT {
    MunninPageCacheCloseIT() {
    }

    @PageCacheExtension
    @Nested
    class MunninPageCacheCloseWithRealFileSystemIT
    extends TestBase {
        MunninPageCacheCloseWithRealFileSystemIT() {
        }
    }

    @EphemeralPageCacheExtension
    @Nested
    class MunninPageCacheCloseWithEphemeralFileSystemIT
    extends TestBase {
        MunninPageCacheCloseWithEphemeralFileSystemIT() {
        }
    }

    private static abstract class TestBase {
        @Inject
        private PageCache pageCache;
        @Inject
        private FileSystemAbstraction fs;
        @Inject
        private TestDirectory directory;

        private TestBase() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        void shouldBeAbleToShutDownWhenInterrupted() throws Exception {
            Path file = this.directory.file("file");
            try (StoreChannel channel = this.fs.write(file);){
                channel.writeAll(ByteBuffer.wrap(new byte[100]));
            }
            AtomicBoolean success = new AtomicBoolean(false);
            Thread thread = new Thread(() -> {
                try (PagedFile pagedFile = this.pageCache.map(file, 10, "neo4j");){
                    try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                        if (cursor.next()) {
                            cursor.putByte((byte)6);
                        }
                    }
                    Thread.currentThread().interrupt();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                success.set(true);
            }, "MunninPageCacheCloseIT writeInterruptionThread");
            try {
                thread.start();
                thread.join(TimeUnit.MINUTES.toMillis(1L));
                Assertions.assertTrue((boolean)success.get());
            }
            finally {
                if (thread.isAlive()) {
                    thread.join(TimeUnit.MINUTES.toMillis(1L));
                }
            }
        }
    }
}

