/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing.recording;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Predicate;
import org.neo4j.io.pagecache.tracing.recording.Event;

public class RecordingTracer {
    private final Set<Class<? extends Event>> eventTypesToTrace = new HashSet<Class<? extends Event>>();
    private final BlockingQueue<Event> record = new LinkedBlockingQueue<Event>();
    private CountDownLatch trapLatch;
    private Predicate<Event> trap;

    @SafeVarargs
    public RecordingTracer(Class<? extends Event> ... eventTypesToTrace) {
        Collections.addAll(this.eventTypesToTrace, eventTypesToTrace);
    }

    public <T extends Event> T observe(Class<T> type) throws InterruptedException {
        return (T)((Event)type.cast(this.record.take()));
    }

    protected void record(Event event) {
        if (this.eventTypesToTrace.contains(event.getClass())) {
            this.record.add(event);
            this.trip(event);
        }
    }

    public synchronized CountDownLatch trap(Predicate<Event> trap) {
        assert (trap != null);
        this.trapLatch = new CountDownLatch(1);
        this.trap = trap;
        return this.trapLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trip(Event event) {
        CountDownLatch theTrapLatch;
        Predicate<Event> theTrap;
        RecordingTracer recordingTracer = this;
        synchronized (recordingTracer) {
            theTrap = this.trap;
            theTrapLatch = this.trapLatch;
        }
        if (theTrap != null && theTrap.test(event)) {
            try {
                theTrapLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Unexpected interrupt in RecordingMonitor", e);
            }
        }
    }
}

