/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.fabric.bolt.QueryRouterBookmark;
import org.neo4j.fabric.bookmark.BookmarkFormat;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.WebContainerTestUtils;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.server.http.cypher.integration.TransactionConditions;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.server.HTTP;

public class TransactionIT
extends AbstractRestFunctionalTestBase {
    private ExecutorService executors;
    private TransactionManager transactionManager;

    @BeforeEach
    public void setUp() {
        this.executors = Executors.newFixedThreadPool(Math.max(3, Runtime.getRuntime().availableProcessors()));
        this.transactionManager = this.resolveDependency(TransactionManager.class);
    }

    @AfterEach
    public void afterEach() {
        Assertions.assertThat((int)this.transactionManager.getTransactionCount()).isEqualTo(0);
        this.executors.shutdown();
    }

    @Test
    public void begin__execute__commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        HTTP.Response begin = this.POST("db/neo4j/tx");
        Assertions.assertThat((int)begin.status()).isEqualTo(201);
        TransactionIT.assertHasTxLocation(begin, "db/neo4j/tx");
        String commitResource = begin.stringFromContent("commit");
        Assertions.assertThat((String)commitResource).matches((CharSequence)String.format("http://localhost:\\d+/%s/\\d+/commit", "db/neo4j/tx"));
        Assertions.assertThat((String)begin.get("transaction").get("expires").asText()).satisfies(TransactionConditions.validRFCTimestamp());
        HTTP.Response execute = this.POST(begin.location(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        Assertions.assertThat((int)execute.status()).isEqualTo(200);
        Assertions.assertThat((String)execute.get("transaction").get("expires").asText()).satisfies(TransactionConditions.validRFCTimestamp());
        HTTP.Response commit = this.POST(commitResource);
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.countNodes(new String[0])).isEqualTo(nodesInDatabaseBeforeTransaction + 1L);
    }

    @Test
    public void begin__execute__rollback() {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        HTTP.Response begin = this.POST("db/neo4j/tx");
        Assertions.assertThat((int)begin.status()).isEqualTo(201);
        TransactionIT.assertHasTxLocation(begin, "db/neo4j/tx");
        this.POST(begin.location(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        HTTP.Response commit = this.DELETE(begin.location());
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.countNodes(new String[0])).isEqualTo(nodesInDatabaseBeforeTransaction);
    }

    @Test
    public void begin__execute_and_commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        HTTP.Response begin = this.POST("db/neo4j/tx");
        Assertions.assertThat((int)begin.status()).isEqualTo(201);
        TransactionIT.assertHasTxLocation(begin, "db/neo4j/tx");
        String commitResource = begin.stringFromContent("commit");
        Assertions.assertThat((String)commitResource).isEqualTo(begin.location() + "/commit");
        HTTP.Response commit = this.POST(commitResource, HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        Assertions.assertThat((Object)commit).satisfies(new Consumer[]{TransactionConditions.containsNoErrors()});
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.countNodes(new String[0])).isEqualTo(nodesInDatabaseBeforeTransaction + 1L);
    }

    @Test
    public void begin_and_execute__commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        HTTP.Response begin = this.POST("db/neo4j/tx", HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        String commitResource = begin.stringFromContent("commit");
        HTTP.Response commit = this.POST(commitResource);
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.countNodes(new String[0])).isEqualTo(nodesInDatabaseBeforeTransaction + 1L);
    }

    @Test
    public void begin_and_execute__commit_with_badly_escaped_statement() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        String json = "{ \"statements\": [ { \"statement\": \"LOAD CSV WITH HEADERS FROM \\\"xx file://C:/countries.csvxxx\\\\\" as csvLine MERGE (c:Country { Code: csvLine.Code })\" } ] }";
        HTTP.Response begin = this.POST("db/neo4j/tx", HTTP.RawPayload.quotedJson((String)json));
        String commitResource = begin.stringFromContent("commit");
        HTTP.Response commit = this.POST(commitResource);
        Assertions.assertThat((int)begin.status()).isEqualTo(201);
        Assertions.assertThat((Object)begin).satisfies(new Consumer[]{TransactionConditions.hasErrors((Status[])new Status[]{Status.Request.InvalidFormat})});
        Assertions.assertThat((int)commit.status()).isEqualTo(404);
        Assertions.assertThat((Object)commit).satisfies(new Consumer[]{TransactionConditions.hasErrors((Status[])new Status[]{Status.Transaction.TransactionNotFound})});
        Assertions.assertThat((long)this.countNodes(new String[0])).isEqualTo(nodesInDatabaseBeforeTransaction);
    }

    @Test
    public void begin__execute__commit__execute() throws Exception {
        HTTP.Response begin = this.POST("db/neo4j/tx");
        String commitResource = begin.stringFromContent("commit");
        this.POST(begin.location(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        this.POST(commitResource);
        HTTP.Response execute2 = this.POST(begin.location(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        Assertions.assertThat((int)execute2.status()).isEqualTo(404);
        Assertions.assertThat((Object)execute2).satisfies(new Consumer[]{TransactionConditions.hasErrors((Status[])new Status[]{Status.Transaction.TransactionNotFound})});
    }

    @Test
    public void begin_and_execute_and_commit() {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        HTTP.Response begin = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        Assertions.assertThat((int)begin.status()).isEqualTo(200);
        Assertions.assertThat((Object)begin).satisfies(new Consumer[]{TransactionConditions.containsNoErrors()});
        Assertions.assertThat((long)this.countNodes(new String[0])).isEqualTo(nodesInDatabaseBeforeTransaction + 1L);
    }

    @Test
    public void begin_and_execute_and_commit_with_badly_escaped_statement() {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        String json = "{ \"statements\": [ { \"statement\": \"LOAD CSV WITH HEADERS FROM \\\"xx file://C:/countries.csvxxx\\\\\" as csvLine MERGE (c:Country { Code: csvLine.Code })\" } ] }";
        HTTP.Response begin = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)json));
        Assertions.assertThat((int)begin.status()).isEqualTo(200);
        Assertions.assertThat((Object)begin).satisfies(new Consumer[]{TransactionConditions.hasErrors((Status[])new Status[]{Status.Request.InvalidFormat})});
        Assertions.assertThat((long)this.countNodes(new String[0])).isEqualTo(nodesInDatabaseBeforeTransaction);
    }

    @Test
    public void begin__execute_multiple__commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        HTTP.Response begin = this.POST("db/neo4j/tx");
        String commitResource = begin.stringFromContent("commit");
        this.POST(begin.location(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' }, { 'statement': 'CREATE (n)' } ] }"));
        HTTP.Response commit = this.POST(commitResource);
        Assertions.assertThat((Object)commit).satisfies(new Consumer[]{TransactionConditions.containsNoErrors()});
        Assertions.assertThat((long)this.countNodes(new String[0])).isEqualTo(nodesInDatabaseBeforeTransaction + 2L);
    }

    @Test
    public void begin__execute__execute__commit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        HTTP.Response begin = this.POST("db/neo4j/tx");
        String commitResource = begin.stringFromContent("commit");
        this.POST(begin.location(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        this.POST(begin.location(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        this.POST(commitResource);
        Assertions.assertThat((long)this.countNodes(new String[0])).isEqualTo(nodesInDatabaseBeforeTransaction + 2L);
    }

    @Test
    public void begin_create_two_nodes_delete_one() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        HTTP.Response response1 = this.POST(this.transactionCommitUri(), HTTP.RawPayload.rawPayload((String)"{ \"statements\" : [{\"statement\" : \"CREATE (n0:DecibelEntity :AlbumGroup{DecibelID : '34a2201b-f4a9-420f-87ae-00a9c691cc5c', Title : 'Dance With Me', ArtistString : 'Ra Ra Riot', MainArtistAlias : 'Ra Ra Riot', OriginalReleaseDate : '2013-01-08', IsCanon : 'False'}) return id(n0)\"}, {\"statement\" : \"CREATE (n1:DecibelEntity :AlbumRelease{DecibelID : '9ed529fa-7c19-11e2-be78-bcaec5bea3c3', Title : 'Dance With Me', ArtistString : 'Ra Ra Riot', MainArtistAlias : 'Ra Ra Riot', LabelName : 'Barsuk Records', FormatNames : 'File', TrackCount : '3', MediaCount : '1', Duration : '460.000000', ReleaseDate : '2013-01-08', ReleaseYear : '2013', ReleaseRegion : 'USA', Cline : 'Barsuk Records', Pline : 'Barsuk Records', CYear : '2013', PYear : '2013', ParentalAdvisory : 'False', IsLimitedEdition : 'False'}) return id(n1)\"}]}"));
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)response1.status());
        JsonNode everything = JsonHelper.jsonNode((String)response1.rawContent());
        JsonNode result = everything.get("results").get(0);
        long id = result.get("data").get(0).get("row").get(0).asLong();
        HTTP.Response response2 = this.POST(this.transactionCommitUri(), HTTP.RawPayload.rawPayload((String)("{ \"statements\" : [{\"statement\":\"match (n) where id(n) = " + id + " delete n return n\"}]}")));
        org.junit.jupiter.api.Assertions.assertEquals((int)200, (int)response2.status());
        Assertions.assertThat((long)this.countNodes(new String[0])).isEqualTo(nodesInDatabaseBeforeTransaction + 1L);
    }

    @Test
    public void begin__rollback__commit() throws Exception {
        HTTP.Response begin = this.POST("db/neo4j/tx");
        Assertions.assertThat((int)begin.status()).isEqualTo(201);
        TransactionIT.assertHasTxLocation(begin, "db/neo4j/tx");
        String commitResource = begin.stringFromContent("commit");
        HTTP.Response interrupt = this.DELETE(begin.location());
        Assertions.assertThat((int)interrupt.status()).isEqualTo(200);
        HTTP.Response commit = this.POST(commitResource);
        Assertions.assertThat((int)commit.status()).isEqualTo(404);
    }

    @Test
    public void begin__rollback__execute() {
        HTTP.Response begin = this.POST("db/neo4j/tx");
        Assertions.assertThat((int)begin.status()).isEqualTo(201);
        TransactionIT.assertHasTxLocation(begin, "db/neo4j/tx");
        HTTP.Response interrupt = this.DELETE(begin.location());
        Assertions.assertThat((int)interrupt.status()).isEqualTo(200);
        HTTP.Response execute = this.POST(begin.location(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        Assertions.assertThat((int)execute.status()).isEqualTo(404);
    }

    @Test
    @Timeout(value=30L)
    public void begin__execute__rollback_concurrently() throws Exception {
        HTTP.Response begin = this.POST("db/neo4j/tx");
        Assertions.assertThat((int)begin.status()).isEqualTo(201);
        TransactionIT.assertHasTxLocation(begin, "db/neo4j/tx");
        Label sharedLockLabel = Label.label((String)"sharedLock");
        this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)("{ 'statements': [ { 'statement': 'CREATE (n:" + sharedLockLabel + ")' } ] }")));
        CountDownLatch nodeLockLatch = new CountDownLatch(1);
        CountDownLatch nodeReleaseLatch = new CountDownLatch(1);
        Future<?> lockerFuture = this.executors.submit(() -> this.lockNodeWithLabel(sharedLockLabel, nodeLockLatch, nodeReleaseLatch));
        nodeLockLatch.await();
        String executeResource = begin.location();
        String statement = "MATCH (n:" + sharedLockLabel + ") DELETE n RETURN count(n)";
        Future<HTTP.Response> executeFuture = this.executors.submit(() -> {
            HTTP.Builder requestBuilder = HTTP.withBaseUri((URI)TransactionIT.container().getBaseUri());
            HTTP.Response response = requestBuilder.POST(executeResource, HTTP.RawPayload.quotedJson((String)("{ 'statements': [ { 'statement': '" + statement + "' } ] }")));
            Assertions.assertThat((int)response.status()).isEqualTo(200);
            return response;
        });
        Future<HTTP.Response> interruptFuture = this.executors.submit(() -> {
            TransactionIT.waitForStatementExecution(statement);
            HTTP.Response response = this.DELETE(executeResource);
            ((AbstractIntegerAssert)Assertions.assertThat((int)response.status()).as(response.toString(), new Object[0])).isEqualTo(200);
            nodeReleaseLatch.countDown();
            return response;
        });
        interruptFuture.get();
        lockerFuture.get();
        HTTP.Response execute = executeFuture.get();
        Assertions.assertThat((Object)execute).satisfies(new Consumer[]{TransactionConditions.hasOneErrorOf((Status[])new Status[]{Status.Transaction.Terminated, Status.Transaction.LockClientStopped})});
        HTTP.Response execute2 = this.POST(executeResource, HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        Assertions.assertThat((int)execute2.status()).isEqualTo(404);
        Assertions.assertThat((Object)execute2).satisfies(new Consumer[]{TransactionConditions.hasErrors((Status[])new Status[]{Status.Transaction.TransactionNotFound})});
    }

    @Test
    public void status_codes_should_appear_in_response() {
        HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'RETURN $n' } ] }"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((Object)response).satisfies(new Consumer[]{TransactionConditions.hasErrors((Status[])new Status[]{Status.Statement.ParameterMissing})});
    }

    @Test
    public void should_return_location_correctly_in_response() throws JsonParseException {
        HTTP.Response begin = this.POST("db/neo4j/tx");
        Assertions.assertThat((int)begin.status()).isEqualTo(201);
        TransactionIT.assertHasTxLocation(begin, "db/neo4j/tx");
        long txId = TransactionIT.extractTxId(begin);
        HTTP.Response response = this.POST(String.format("%s/%s", "db/neo4j/tx", txId), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'RETURN 1' } ] }"));
        System.out.println(response);
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((String)response.get("commit").toString()).contains(new CharSequence[]{"db/neo4j/tx"});
        HTTP.Response commit = this.POST(String.format("%s/%s/commit", "db/neo4j/tx", txId));
        System.out.println(commit);
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((String)commit.get("commit").toString()).contains(new CharSequence[]{"db/neo4j/tx"});
    }

    @Test
    @Timeout(value=30L)
    public void executing_single_statement_in_new_transaction_and_failing_to_read_the_output_should_interrupt() throws Exception {
        long initialNodes = this.countNodes(new String[0]);
        DatabaseTransactionStats txMonitor = (DatabaseTransactionStats)((GraphDatabaseAPI)this.graphdb()).getDependencyResolver().resolveDependency(DatabaseTransactionStats.class);
        long initialRollBacks = txMonitor.getNumberOfRolledBackTransactions();
        Socket socket = new Socket("localhost", TransactionIT.getLocalHttpPort());
        PrintStream out = new PrintStream(socket.getOutputStream());
        String output = HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'UNWIND range(0, 9999) AS i CREATE (n {i: i}) RETURN n' } ] }").get();
        out.printf("POST /%s/commit HTTP/1.1\r\n", "db/neo4j/tx");
        out.print("Host: localhost:7474\r\n");
        out.print("Content-type: application/json; charset=utf-8\r\n");
        out.print("Content-length: " + output.getBytes().length + "\r\n");
        out.print("\r\n");
        out.print(output);
        out.print("\r\n");
        InputStream inputStream = socket.getInputStream();
        InputStreamReader reader = new InputStreamReader(inputStream);
        for (int numRead = 0; numRead < 300; numRead += reader.read(new char[300])) {
        }
        socket.close();
        org.junit.jupiter.api.Assertions.assertEquals((long)initialNodes, (long)this.countNodes(new String[0]));
        while (this.transactionManager.getTransactionCount() > 0) {
            Thread.sleep(100L);
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)(txMonitor.getNumberOfRolledBackTransactions() - initialRollBacks));
    }

    @Test
    public void should_include_graph_format_when_requested() throws Exception {
        long initialData = this.countNodes("Foo");
        this.POST(this.transactionCommitUri(), TransactionIT.singleStatement("CREATE (n:Foo:Bar)"));
        HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'MATCH (n:Foo) RETURN n', 'resultDataContents':['row','graph'] } ] }"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        JsonNode data = response.get("results").get(0).get("data");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)data.isArray(), (String)"data is a list");
        org.junit.jupiter.api.Assertions.assertEquals((long)(initialData + 1L), (long)data.size(), (String)"one entry");
        JsonNode entry = data.get(0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)entry.has("row"), (String)"entry has row");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)entry.has("graph"), (String)"entry has graph");
        JsonNode nodes = entry.get("graph").get("nodes");
        JsonNode rels = entry.get("graph").get("relationships");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)nodes.isArray(), (String)"nodes is a list");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)rels.isArray(), (String)"relationships is a list");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)nodes.size(), (String)"one node");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)rels.size(), (String)"no relationships");
        HashSet<String> labels = new HashSet<String>();
        for (JsonNode node : nodes.get(0).get("labels")) {
            labels.add(node.asText());
        }
        org.junit.jupiter.api.Assertions.assertTrue((labels.size() > 0 ? 1 : 0) != 0, (String)"some labels");
    }

    @Test
    public void should_serialize_collect_correctly() throws Exception {
        this.POST(this.transactionCommitUri(), TransactionIT.singleStatement("CREATE (n:Foo)"));
        HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'MATCH (n:Foo) RETURN COLLECT(n)' } ] }"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        JsonNode data = response.get("results").get(0);
        Assertions.assertThat((String)data.get("columns").get(0).asText()).isEqualTo("COLLECT(n)");
        Assertions.assertThat((int)data.get("data").get(0).get("row").size()).isEqualTo(1);
        Assertions.assertThat((int)data.get("data").get(0).get("row").get(0).get(0).size()).isEqualTo(0);
        Assertions.assertThat((int)response.get("errors").size()).isEqualTo(0);
    }

    @Test
    public void shouldSerializeMapsCorrectlyInRowsFormat() throws Exception {
        HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'RETURN {one:{two:[true, {three: 42}]}}' } ] }"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        JsonNode data = response.get("results").get(0);
        JsonNode row = data.get("data").get(0).get("row");
        Assertions.assertThat((int)row.size()).isEqualTo(1);
        JsonNode firstCell = row.get(0);
        Assertions.assertThat((int)firstCell.get("one").get("two").size()).isEqualTo(2);
        Assertions.assertThat((boolean)firstCell.get("one").get("two").get(0).asBoolean()).isEqualTo(true);
        Assertions.assertThat((int)firstCell.get("one").get("two").get(1).get("three").asInt()).isEqualTo(42);
        Assertions.assertThat((int)response.get("errors").size()).isEqualTo(0);
    }

    @Test
    public void begin_and_execute_call_in_tx_and_commit() throws Exception {
        int nodes = 11;
        int batch = 2;
        WebContainerTestUtils.withCSVFile((int)nodes, url -> {
            long txIdBefore;
            long nodesInDatabaseBeforeTransaction;
            String query;
            HTTP.Response response;
            int times = 0;
            do {
                nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
                txIdBefore = this.resolveDependency(TransactionIdStore.class).getLastClosedTransactionId();
                query = String.format("{\n  \"statements\": [\n    {\n      \"statement\": \"LOAD CSV FROM \\\"%s\\\" AS line CALL { WITH line CREATE() } IN TRANSACTIONS OF %s ROWS\"\n    }\n  ]\n}\n", url, batch);
            } while ((response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)query))).get("errors").iterator().hasNext() && ++times < 5);
            long txIdAfter = this.resolveDependency(TransactionIdStore.class).getLastClosedTransactionId();
            ((ObjectAssert)Assertions.assertThat((Object)response).as("Last response is: " + response, new Object[0])).satisfies(new Consumer[]{TransactionConditions.containsNoErrors()});
            Assertions.assertThat((int)response.status()).isEqualTo(200);
            Assertions.assertThat((long)this.countNodes(new String[0])).isEqualTo(nodesInDatabaseBeforeTransaction + (long)nodes);
            Assertions.assertThat((long)txIdAfter).isEqualTo(txIdBefore + (long)(nodes / batch + 1));
        });
    }

    @Test
    public void begin_and_execute_call_in_tx_that_returns_data_and_commit() throws Exception {
        int nodes = 11;
        int batchSize = 2;
        String query = "{\n  \"statements\": [\n    {\n      \"statement\": \"LOAD CSV FROM \\\"%s\\\" AS line CALL { WITH line CREATE (n {id1: 23}) RETURN n } IN TRANSACTIONS OF %s ROWS RETURN n\"\n    }\n  ]\n}\n";
        WebContainerTestUtils.withCSVFile((int)nodes, url -> this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)String.format(query, url, batchSize))));
        WebContainerTestUtils.withCSVFile((int)nodes, url -> {
            long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
            long txIdBefore = this.resolveDependency(TransactionIdStore.class).getLastClosedTransactionId();
            HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)String.format(query, url, batchSize)));
            long txIdAfter = this.resolveDependency(TransactionIdStore.class).getLastClosedTransactionId();
            Assertions.assertThat((int)response.status()).isEqualTo(200);
            Assertions.assertThat((Object)response).satisfies(new Consumer[]{TransactionConditions.containsNoErrors()});
            JsonNode columns = response.get("results").get(0).get("columns");
            Assertions.assertThat((String)columns.toString()).isEqualTo("[\"n\"]");
            Assertions.assertThat((long)this.countNodes(new String[0])).isEqualTo(nodesInDatabaseBeforeTransaction + (long)nodes);
            long expectedTxCount = nodes / batchSize + 1;
            Assertions.assertThat((long)(txIdAfter - txIdBefore)).isEqualTo(expectedTxCount);
        });
    }

    @Test
    public void begin_and_execute_multiple_call_in_tx_last_and_commit() throws Exception {
        String query = "{\n  \"statements\": [\n    {\n      \"statement\": \"CREATE ()\"\n    },\n    {\n      \"statement\": \"LOAD CSV FROM \\\"%s\\\" AS line CALL { WITH line CREATE (n {id1: 23}) RETURN n } IN TRANSACTIONS RETURN n\"\n    }\n  ]\n}\n";
        WebContainerTestUtils.withCSVFile((int)1, url -> {
            HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)String.format(query, url)));
            Assertions.assertThat((String)response.get("errors").get(0).get("message").asText()).startsWith((CharSequence)"Expected transaction state to be empty when calling transactional subquery");
        });
    }

    @Test
    public void begin_and_execute_call_in_tx_followed_by_another_statement_and_commit() throws Exception {
        String query = "{\n  \"statements\": [\n    {\n      \"statement\": \"LOAD CSV FROM \\\"%s\\\" AS line CALL { WITH line CREATE (n {id1: 23}) RETURN n } IN TRANSACTIONS RETURN n\"\n    },\n    {\n      \"statement\": \"RETURN 1\"\n    }\n  ]\n}\n";
        WebContainerTestUtils.withCSVFile((int)1, url -> {
            HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)String.format(query, url)));
            Assertions.assertThat((int)response.status()).isEqualTo(200);
        });
    }

    @Test
    public void begin_and_execute_invalid_query_and_commit() {
        HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'MATCH n RETURN m' } ] }"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((Object)response).satisfies(new Consumer[]{TransactionConditions.hasErrors((Status[])new Status[]{Status.Statement.SyntaxError})});
    }

    @Test
    public void shouldSerializeMapsCorrectlyInRestFormat() throws Exception {
        HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'RETURN {one:{two:[true, {three: 42}]}}', 'resultDataContents':['rest'] } ] }"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        JsonNode data = response.get("results").get(0);
        JsonNode rest = data.get("data").get(0).get("rest");
        Assertions.assertThat((int)rest.size()).isEqualTo(1);
        JsonNode firstCell = rest.get(0);
        Assertions.assertThat((int)firstCell.get("one").get("two").size()).isEqualTo(2);
        Assertions.assertThat((boolean)firstCell.get("one").get("two").get(0).asBoolean()).isEqualTo(true);
        Assertions.assertThat((int)firstCell.get("one").get("two").get(1).get("three").asInt()).isEqualTo(42);
        Assertions.assertThat((int)response.get("errors").size()).isEqualTo(0);
    }

    @Test
    public void shouldHandleMapParametersCorrectly() throws Exception {
        HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'WITH $map AS map RETURN map[0]', 'parameters':{'map':[{'index':0,'name':'a'},{'index':1,'name':'b'}]} } ] }"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        JsonNode data = response.get("results").get(0);
        JsonNode row = data.get("data").get(0).get("row");
        Assertions.assertThat((int)row.size()).isEqualTo(1);
        Assertions.assertThat((int)row.get(0).get("index").asInt()).isEqualTo(0);
        Assertions.assertThat((String)row.get(0).get("name").asText()).isEqualTo("a");
        Assertions.assertThat((int)response.get("errors").size()).isEqualTo(0);
    }

    @Test
    public void restFormatNodesShouldHaveSensibleUris() throws Exception {
        String hostname = "localhost";
        HTTP.Response rs = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n:Foo:Bar) RETURN n', 'resultDataContents':['rest'] } ] }"));
        JsonNode restNode = rs.get("results").get(0).get("data").get(0).get("rest").get(0);
        this.assertPath(restNode.get("labels"), "/node/\\d+/labels", "localhost");
        this.assertPath(restNode.get("outgoing_relationships"), "/node/\\d+/relationships/out", "localhost");
        this.assertPath(restNode.get("traverse"), "/node/\\d+/traverse/\\{returnType\\}", "localhost");
        this.assertPath(restNode.get("all_typed_relationships"), "/node/\\d+/relationships/all/\\{-list\\|&\\|types\\}", "localhost");
        this.assertPath(restNode.get("self"), "/node/\\d+", "localhost");
        this.assertPath(restNode.get("property"), "/node/\\d+/properties/\\{key\\}", "localhost");
        this.assertPath(restNode.get("properties"), "/node/\\d+/properties", "localhost");
        this.assertPath(restNode.get("outgoing_typed_relationships"), "/node/\\d+/relationships/out/\\{-list\\|&\\|types\\}", "localhost");
        this.assertPath(restNode.get("incoming_relationships"), "/node/\\d+/relationships/in", "localhost");
        this.assertPath(restNode.get("create_relationship"), "/node/\\d+/relationships", "localhost");
        this.assertPath(restNode.get("paged_traverse"), "/node/\\d+/paged/traverse/\\{returnType\\}\\{\\?pageSize,leaseTime\\}", "localhost");
        this.assertPath(restNode.get("all_relationships"), "/node/\\d+/relationships/all", "localhost");
        this.assertPath(restNode.get("incoming_typed_relationships"), "/node/\\d+/relationships/in/\\{-list\\|&\\|types\\}", "localhost");
    }

    @Test
    public void restFormattedNodesShouldHaveSensibleUrisWhenUsingXForwardHeader() throws Exception {
        String hostname = "dummy.example.org";
        HTTP.Response rs = this.http.withHeaders(new String[]{"X-Forwarded-Host", "dummy.example.org"}).POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n:Foo:Bar) RETURN n', 'resultDataContents':['rest'] } ] }"));
        JsonNode restNode = rs.get("results").get(0).get("data").get(0).get("rest").get(0);
        this.assertPath(restNode.get("labels"), "/node/\\d+/labels", "dummy.example.org");
        this.assertPath(restNode.get("outgoing_relationships"), "/node/\\d+/relationships/out", "dummy.example.org");
        this.assertPath(restNode.get("traverse"), "/node/\\d+/traverse/\\{returnType\\}", "dummy.example.org");
        this.assertPath(restNode.get("all_typed_relationships"), "/node/\\d+/relationships/all/\\{-list\\|&\\|types\\}", "dummy.example.org");
        this.assertPath(restNode.get("self"), "/node/\\d+", "dummy.example.org");
        this.assertPath(restNode.get("property"), "/node/\\d+/properties/\\{key\\}", "dummy.example.org");
        this.assertPath(restNode.get("properties"), "/node/\\d+/properties", "dummy.example.org");
        this.assertPath(restNode.get("outgoing_typed_relationships"), "/node/\\d+/relationships/out/\\{-list\\|&\\|types\\}", "dummy.example.org");
        this.assertPath(restNode.get("incoming_relationships"), "/node/\\d+/relationships/in", "dummy.example.org");
        this.assertPath(restNode.get("create_relationship"), "/node/\\d+/relationships", "dummy.example.org");
        this.assertPath(restNode.get("paged_traverse"), "/node/\\d+/paged/traverse/\\{returnType\\}\\{\\?pageSize,leaseTime\\}", "dummy.example.org");
        this.assertPath(restNode.get("all_relationships"), "/node/\\d+/relationships/all", "dummy.example.org");
        this.assertPath(restNode.get("incoming_typed_relationships"), "/node/\\d+/relationships/in/\\{-list\\|&\\|types\\}", "dummy.example.org");
    }

    @Test
    public void correctStatusCodeWhenUsingHintWithoutAnyIndex() {
        HTTP.Response begin = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'MATCH (n:Test) USING INDEX n:Test(foo) WHERE n.foo = 42 RETURN n.foo' } ] }"));
        Assertions.assertThat((Object)begin).satisfies(new Consumer[]{TransactionConditions.hasErrors((Status[])new Status[]{Status.Schema.IndexNotFound})});
    }

    @Test
    public void transaction_not_in_response_on_failure() throws Exception {
        HTTP.Response begin = this.POST("db/neo4j/tx");
        String commitResource = begin.stringFromContent("commit");
        HTTP.Response valid = this.POST(begin.location(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'RETURN 42' } ] }"));
        Assertions.assertThat((int)valid.status()).isEqualTo(200);
        Assertions.assertThat((Iterable)valid.get("transaction")).isNotNull();
        HTTP.Response invalid = this.POST(begin.location(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'RETRUN 42' } ] }"));
        Assertions.assertThat((int)invalid.status()).isEqualTo(200);
        Assertions.assertThat((Iterable)invalid.get("transaction")).isNull();
        HTTP.Response commit = this.POST(commitResource);
        Assertions.assertThat((int)commit.status()).isEqualTo(404);
    }

    @Test
    public void shouldWorkWhenHittingTheASTCacheInCypher() throws JsonParseException {
        HTTP.Response response = this.POST(this.transactionCommitUri(), TransactionIT.singleStatement("MATCH (group:Group {name: \\\"AAA\\\"}) RETURN *"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((int)response.get("errors").size()).isEqualTo(0);
        response = this.POST(this.transactionCommitUri(), TransactionIT.singleStatement("MATCH (group:Group {name: \\\"BBB\\\"}) RETURN *"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((int)response.get("errors").size()).isEqualTo(0);
    }

    @Test
    public void writeSettingsBeginAndCommit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        HTTP.Response begin = this.POST("db/neo4j/tx", HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"), Map.of("access-mode", "WRITE"));
        String commitResource = begin.stringFromContent("commit");
        HTTP.Response commit = this.POST(commitResource);
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.countNodes(new String[0])).isEqualTo(nodesInDatabaseBeforeTransaction + 1L);
    }

    @Test
    public void shouldErrorWhenWriteAttemptedWithReadSetting() throws Exception {
        HTTP.Response begin = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"), Map.of("access-mode", "READ"));
        Assertions.assertThat((int)begin.status()).isEqualTo(200);
        Assertions.assertThat((Object)begin).satisfies(new Consumer[]{TransactionConditions.hasErrors((Status[])new Status[]{Status.Statement.AccessMode})});
    }

    @Test
    public void readSettingsBeginAndCommit() throws Exception {
        HTTP.Response begin = this.POST("db/neo4j/tx", HTTP.RawPayload.quotedJson((String)"{'statements': [ { 'statement': 'MATCH (n) RETURN n' } ] }"), Map.of("access-mode", "READ"));
        String commitResource = begin.stringFromContent("commit");
        HTTP.Response commit = this.POST(commitResource);
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
    }

    @Test
    public void beginWithSettingsOnlyAndThenExecuteCommit() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes(new String[0]);
        HTTP.Response begin = this.POST("db/neo4j/tx", HTTP.RawPayload.quotedJson((String)""), Map.of("access-mode", "WRITE"));
        Assertions.assertThat((int)begin.status()).isEqualTo(201);
        TransactionIT.assertHasTxLocation(begin, "db/neo4j/tx");
        String commitResource = begin.stringFromContent("commit");
        Assertions.assertThat((String)commitResource).matches((CharSequence)String.format("http://localhost:\\d+/%s/\\d+/commit", "db/neo4j/tx"));
        Assertions.assertThat((String)begin.get("transaction").get("expires").asText()).satisfies(TransactionConditions.validRFCTimestamp());
        HTTP.Response execute = this.POST(begin.location(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        Assertions.assertThat((int)execute.status()).isEqualTo(200);
        Assertions.assertThat((String)execute.get("transaction").get("expires").asText()).satisfies(TransactionConditions.validRFCTimestamp());
        HTTP.Response commit = this.POST(commitResource);
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((long)this.countNodes(new String[0])).isEqualTo(nodesInDatabaseBeforeTransaction + 1L);
    }

    @Test
    public void shouldIgnoreAccessModeHeaderOnSecondRequest() throws Exception {
        HTTP.Response begin = this.POST("db/neo4j/tx", HTTP.RawPayload.quotedJson((String)""), Map.of("access-mode", "READ"));
        Assertions.assertThat((int)begin.status()).isEqualTo(201);
        TransactionIT.assertHasTxLocation(begin, "db/neo4j/tx");
        String commitResource = begin.stringFromContent("commit");
        Assertions.assertThat((String)commitResource).matches((CharSequence)String.format("http://localhost:\\d+/%s/\\d+/commit", "db/neo4j/tx"));
        Assertions.assertThat((String)begin.get("transaction").get("expires").asText()).satisfies(TransactionConditions.validRFCTimestamp());
        HTTP.Response execute = this.POST(begin.location(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"), Map.of("access-mode", "WRITE"));
        Assertions.assertThat((int)execute.status()).isEqualTo(200);
        Assertions.assertThat((Object)execute).satisfies(new Consumer[]{TransactionConditions.hasErrors((Status[])new Status[]{Status.Statement.AccessMode})});
    }

    @Test
    public void shouldErrorWithInvalidAccessModeHeader() {
        HTTP.Response begin = this.POST("db/neo4j/tx", HTTP.RawPayload.quotedJson((String)""), Map.of("access-mode", "INVALID!"));
        Assertions.assertThat((int)begin.status()).isEqualTo(200);
        Assertions.assertThat((Object)begin).satisfies(new Consumer[]{TransactionConditions.hasErrors((Status[])new Status[]{Status.Request.InvalidFormat})});
    }

    @ParameterizedTest
    @ValueSource(strings={"boooookyMark", "64, 12", "FB:boom!"})
    public void shouldRejectInvalidBookmarks(String bookmarkInput) throws JsonParseException {
        HTTP.Response begin = this.POST("db/neo4j/tx", HTTP.RawPayload.quotedJson((String)""), Map.of("bookmarks", bookmarkInput));
        Assertions.assertThat((int)begin.status()).isEqualTo(200);
        Assertions.assertThat((Object)begin).satisfies(new Consumer[]{TransactionConditions.hasErrors((Status[])new Status[]{Status.Request.InvalidFormat})});
        Assertions.assertThat((String)begin.get("errors").get(0).get("message").asText()).startsWith((CharSequence)"Invalid bookmarks header. `bookmarks` must be an array of non-empty string values.");
    }

    @Test
    public void shouldReturnUpdatedBookmarkAfterSingleRequestTransaction() throws JsonParseException {
        String initialBookmark = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }")).get("lastBookmarks").get(0).asText();
        HTTP.Response beginWithBookmark = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"), TransactionIT.bookmarkHeader(initialBookmark));
        Assertions.assertThat((int)beginWithBookmark.status()).isEqualTo(200);
        Assertions.assertThat((Object)beginWithBookmark).satisfies(new Consumer[]{TransactionConditions.containsNoErrors()});
        Assertions.assertThat((String)beginWithBookmark.get("lastBookmarks").asText()).isNotEqualTo((Object)initialBookmark);
    }

    @Test
    public void shouldAcceptMultipleBookmarks() throws JsonParseException {
        String initialBookmarkA = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }")).get("lastBookmarks").get(0).asText();
        String initialBookmarkB = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }")).get("lastBookmarks").get(0).asText();
        HTTP.Response beginWithBookmark = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"), TransactionIT.bookmarkHeader(initialBookmarkA, initialBookmarkB));
        Assertions.assertThat((int)beginWithBookmark.status()).isEqualTo(200);
        Assertions.assertThat((Object)beginWithBookmark).satisfies(new Consumer[]{TransactionConditions.containsNoErrors()});
        Assertions.assertThat((String)beginWithBookmark.get("lastBookmarks").get(0).asText()).isNotEqualTo((Object)initialBookmarkA);
        Assertions.assertThat((String)beginWithBookmark.get("lastBookmarks").get(0).asText()).isNotEqualTo((Object)initialBookmarkB);
    }

    @Test
    public void shouldReturnUpdatedBookmarkAfterExplicitTransaction() throws JsonParseException {
        String initialBookmark = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }")).get("lastBookmarks").get(0).asText();
        HTTP.Response begin = this.POST("db/neo4j/tx", HTTP.RawPayload.quotedJson((String)""), TransactionIT.bookmarkHeader(initialBookmark));
        Assertions.assertThat((int)begin.status()).isEqualTo(201);
        TransactionIT.assertHasTxLocation(begin, "db/neo4j/tx");
        String commitResource = begin.stringFromContent("commit");
        Assertions.assertThat((String)commitResource).isEqualTo(begin.location() + "/commit");
        HTTP.Response commit = this.POST(commitResource, HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        Assertions.assertThat((Object)commit).satisfies(new Consumer[]{TransactionConditions.containsNoErrors()});
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((String)commit.get("lastBookmarks").get(0).asText()).isNotEqualTo((Object)initialBookmark);
    }

    @Test
    void shouldFailForUnreachableBookmark() {
        long lastClosedTransactionId = this.getLastClosedTransactionId();
        String expectedBookmark = BookmarkFormat.serialize((QueryRouterBookmark)new QueryRouterBookmark(List.of(new QueryRouterBookmark.InternalGraphState(this.resolveDependency(Database.class).getNamedDatabaseId().databaseId().uuid(), lastClosedTransactionId + 1L)), List.of()));
        HTTP.Response begin = this.POST("db/neo4j/tx", HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"), TransactionIT.bookmarkHeader(expectedBookmark));
        Assertions.assertThat((int)begin.status()).isEqualTo(201);
        Assertions.assertThat((Object)begin).satisfies(new Consumer[]{TransactionConditions.hasErrors((Status[])new Status[]{Status.Transaction.BookmarkTimeout})});
    }

    @Test
    void bookmarksAreIgnoredOnMidTransactionRequests() throws JsonParseException {
        String bookmark = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }")).get("lastBookmarks").get(0).asText();
        HTTP.Response begin = this.POST("db/neo4j/tx");
        Assertions.assertThat((int)begin.status()).isEqualTo(201);
        TransactionIT.assertHasTxLocation(begin, "db/neo4j/tx");
        String commitResource = begin.stringFromContent("commit");
        HTTP.Response execute = this.POST(begin.location(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"), TransactionIT.bookmarkHeader(bookmark));
        Assertions.assertThat((int)execute.status()).isEqualTo(200);
        Assertions.assertThat((String)execute.get("transaction").get("expires").asText()).satisfies(TransactionConditions.validRFCTimestamp());
        HTTP.Response commit = this.POST(commitResource);
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
        Assertions.assertThat((String)commit.get("lastBookmarks").get(0).asText()).isNotBlank();
    }

    @Test
    public void shouldWaitForUpdatedBookmark() {
        long lastClosedTransactionId = this.getLastClosedTransactionId();
        String expectedBookmark = BookmarkFormat.serialize((QueryRouterBookmark)new QueryRouterBookmark(List.of(new QueryRouterBookmark.InternalGraphState(this.resolveDependency(Database.class).getNamedDatabaseId().databaseId().uuid(), lastClosedTransactionId + 1L)), List.of()));
        HTTP.Response begin = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"), TransactionIT.bookmarkHeader(expectedBookmark));
        Assertions.assertThat((int)begin.status()).isEqualTo(200);
        Assertions.assertThat((Object)begin).satisfies(new Consumer[]{TransactionConditions.hasErrors((Status[])new Status[]{Status.Transaction.BookmarkTimeout})});
        this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        HTTP.Response begin2 = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"), TransactionIT.bookmarkHeader(expectedBookmark));
        Assertions.assertThat((int)begin2.status()).isEqualTo(200);
        Assertions.assertThat((Object)begin2).satisfies(new Consumer[]{TransactionConditions.containsNoErrors()});
    }

    @Test
    public void begin_and_execute_multiple_statements_with_partial_rollback() throws Exception {
        long nodesAtStart = this.countNodes(new String[0]);
        String query = "{\n  \"statements\": [\n    {\n      \"statement\": \"UNWIND [4, 2, 1, 0] AS i CALL { WITH i CREATE ()} IN TRANSACTIONS OF 2 ROWS RETURN i\"\n    },\n    {\n      \"statement\": \"CREATE ()\"\n    },\n    {\n      \"statement\": \"CREATE ()\"\n    },\n    {\n      \"statement\": \"BROKEN\"\n    }\n  ]\n}\n";
        HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)query));
        Assertions.assertThat((Object)response).satisfies(new Consumer[]{TransactionConditions.hasErrors((Status[])new Status[]{Status.Statement.SyntaxError})});
        Assertions.assertThat((long)this.countNodes(new String[0])).isEqualTo(nodesAtStart + 4L);
    }

    @Test
    public void begin_and_execute_multiple_statements_successfully() throws Exception {
        long nodesAtStart = this.countNodes(new String[0]);
        String query = "{\n  \"statements\": [\n    {\n      \"statement\": \"UNWIND [4, 2, 1, 0] AS i CALL { WITH i CREATE ()} IN TRANSACTIONS OF 2 ROWS RETURN i\"\n    },\n    {\n      \"statement\": \"CREATE ()\"\n    },\n    {\n      \"statement\": \"CREATE ()\"\n    }\n  ]\n}\n";
        HTTP.Response response = this.POST(this.transactionCommitUri(), HTTP.RawPayload.quotedJson((String)query.replace("\n", "")));
        Assertions.assertThat((Object)response).satisfies(new Consumer[]{TransactionConditions.containsNoErrors()});
        Assertions.assertThat((long)this.countNodes(new String[0])).isEqualTo(nodesAtStart + 6L);
    }

    private String transactionCommitUri() {
        return String.format("%s/commit", "db/neo4j/tx");
    }

    private String databaseName() {
        return "db/neo4j/tx".split("/")[1];
    }

    private void assertPath(JsonNode jsonURIString, String path, String hostname) {
        String databaseName = this.databaseName();
        String expected = String.format("http://%s:\\d+/db/%s%s", hostname, databaseName, path);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)jsonURIString.asText().matches(expected), (String)String.format("Expected a uri matching '%s', but got '%s'.", expected, jsonURIString.asText()));
    }

    private static HTTP.RawPayload singleStatement(String statement) {
        return HTTP.RawPayload.rawPayload((String)("{\"statements\":[{\"statement\":\"" + statement + "\"}]}"));
    }

    private long countNodes(String ... labels) {
        HashSet<Label> givenLabels = new HashSet<Label>(labels.length);
        for (String label : labels) {
            givenLabels.add(Label.label((String)label));
        }
        GraphDatabaseService graphdb = this.graphdb();
        try (Transaction transaction = graphdb.beginTx();){
            long count = 0L;
            try (ResourceIterable allNodes = transaction.getAllNodes();){
                for (Node node : allNodes) {
                    Set nodeLabels = Iterables.asSet((Iterable)node.getLabels());
                    if (!nodeLabels.containsAll(givenLabels)) continue;
                    ++count;
                }
            }
            transaction.commit();
            long l = count;
            return l;
        }
    }

    private void lockNodeWithLabel(Label sharedLockLabel, CountDownLatch nodeLockLatch, CountDownLatch nodeReleaseLatch) {
        GraphDatabaseService db = this.graphdb();
        try (Transaction tx = db.beginTx();
             ResourceIterator nodes = tx.findNodes(sharedLockLabel);){
            Node node = (Node)nodes.next();
            node.setProperty("a", (Object)"b");
            nodeLockLatch.countDown();
            nodeReleaseLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static void waitForStatementExecution(String statement) {
        TestWebContainer server = TransactionIT.container();
        GraphDatabaseFacade databaseService = server.getDefaultDatabase();
        KernelTransactions kernelTransactions = (KernelTransactions)databaseService.getDependencyResolver().resolveDependency(KernelTransactions.class);
        while (!TransactionIT.isStatementExecuting(kernelTransactions, statement)) {
            Thread.yield();
        }
    }

    private static boolean isStatementExecuting(KernelTransactions kernelTransactions, String statement) {
        return kernelTransactions.activeTransactions().stream().flatMap(k -> k.executingQuery().stream()).anyMatch(executingQuery -> statement.equals(executingQuery.rawQueryText()));
    }

    private static Map<String, String> bookmarkHeader(String ... bookmark) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Iterator iter = Arrays.stream(bookmark).iterator();
        while (iter.hasNext()) {
            sb.append("\"");
            sb.append((String)iter.next());
            sb.append("\"");
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return Map.of("bookmarks", sb.toString());
    }

    public long getLastClosedTransactionId() {
        TransactionIdStore txIdStore = this.resolveDependency(TransactionIdStore.class);
        return txIdStore.getLastClosedTransactionId();
    }
}

