/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.security;

import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.server.rest.security.CommunityWebContainerTestBase;
import org.neo4j.server.web.HttpMethod;
import org.neo4j.test.server.HTTP;

class AuthorizationCorsIT
extends CommunityWebContainerTestBase {
    AuthorizationCorsIT() {
    }

    @Test
    void shouldAddCorsHeaderWhenAuthDisabled() throws Exception {
        this.startServer(false);
        HTTP.Response response = this.runQuery("authDisabled", "authDisabled");
        org.junit.jupiter.api.Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.status());
        AuthorizationCorsIT.assertCorsHeaderPresent(response);
        Assertions.assertThat((String)response.content().toString()).contains(new CharSequence[]{"42"});
    }

    @Test
    void shouldAddCorsHeaderWhenAuthEnabledAndPasswordChangeRequired() throws Exception {
        this.startServer(true);
        HTTP.Response response = this.runQuery("neo4j", "neo4j");
        org.junit.jupiter.api.Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.status());
        AuthorizationCorsIT.assertCorsHeaderPresent(response);
        AuthorizationCorsIT.assertPermissionErrorAtDataAccess(response);
    }

    @Test
    void shouldAddCorsHeaderWhenAuthEnabledAndPasswordChangeNotRequired() throws Exception {
        this.startServer(true);
        HTTP.Response passwordChangeResponse = this.changePassword("neo4j", "neo4j", "newPassword");
        org.junit.jupiter.api.Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)passwordChangeResponse.status());
        AuthorizationCorsIT.assertCorsHeaderPresent(passwordChangeResponse);
        HTTP.Response queryResponse = this.runQuery("neo4j", "newPassword");
        org.junit.jupiter.api.Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)queryResponse.status());
        AuthorizationCorsIT.assertCorsHeaderPresent(queryResponse);
        Assertions.assertThat((String)queryResponse.content().toString()).contains(new CharSequence[]{"42"});
    }

    @Test
    void shouldAddCorsHeaderWhenAuthEnabledAndIncorrectPassword() throws Exception {
        this.startServer(true);
        HTTP.Response response = this.runQuery("neo4j", "wrongPassword");
        org.junit.jupiter.api.Assertions.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)response.status());
        AuthorizationCorsIT.assertCorsHeaderPresent(response);
        Assertions.assertThat((String)response.content().toString()).contains(new CharSequence[]{"Neo.ClientError.Security.Unauthorized"});
    }

    @Test
    void shouldAddCorsMethodsHeader() throws Exception {
        this.startServer(false);
        this.testCorsAllowMethods(HttpMethod.POST);
        this.testCorsAllowMethods(HttpMethod.GET);
        this.testCorsAllowMethods(HttpMethod.PATCH);
        this.testCorsAllowMethods(HttpMethod.DELETE);
    }

    @Test
    void shouldAddCorsHeaderWhenConfigured() throws Exception {
        String origin = "https://example.com:7687";
        this.startServer(false, origin);
        this.testCorsAllowMethods(HttpMethod.POST, origin);
        this.testCorsAllowMethods(HttpMethod.GET, origin);
        this.testCorsAllowMethods(HttpMethod.PATCH, origin);
        this.testCorsAllowMethods(HttpMethod.DELETE, origin);
    }

    @Test
    void shouldAddCorsRequestHeaders() throws Exception {
        this.startServer(false);
        HTTP.Builder requestBuilder = HTTP.withBasicAuth((String)"authDisabled", (String)"authDisabled").withHeaders(new String[]{"Access-Control-Request-Headers", "Accept, X-Not-Accept"});
        HTTP.Response response = this.runQuery(requestBuilder);
        org.junit.jupiter.api.Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.status());
        AuthorizationCorsIT.assertCorsHeaderPresent(response);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Accept, X-Not-Accept", (Object)response.header("Access-Control-Allow-Headers"));
    }

    private void testCorsAllowMethods(HttpMethod method) {
        this.testCorsAllowMethods(method, "*");
    }

    private void testCorsAllowMethods(HttpMethod method, String origin) {
        HTTP.Builder requestBuilder = HTTP.withBasicAuth((String)"authDisabled", (String)"authDisabled").withHeaders(new String[]{"Access-Control-Request-Method", method.toString()});
        HTTP.Response response = this.runQuery(requestBuilder);
        org.junit.jupiter.api.Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.status());
        AuthorizationCorsIT.assertCorsHeaderEquals(response, origin);
        org.junit.jupiter.api.Assertions.assertEquals((Object)method, (Object)HttpMethod.valueOf((String)response.header("Access-Control-Allow-Methods")));
    }

    private HTTP.Response changePassword(String username, String oldPassword, String newPassword) {
        HTTP.RawPayload passwordChange = AuthorizationCorsIT.query(String.format("ALTER CURRENT USER SET PASSWORD FROM '%s' TO '%s'", oldPassword, newPassword));
        return HTTP.withBasicAuth((String)username, (String)oldPassword).POST(this.txCommitURL("system"), passwordChange);
    }

    private HTTP.Response runQuery(String username, String password) {
        return this.runQuery(HTTP.withBasicAuth((String)username, (String)password));
    }

    private HTTP.Response runQuery(HTTP.Builder requestBuilder) {
        HTTP.RawPayload statements = HTTP.RawPayload.quotedJson((String)"{'statements': [{'statement': 'RETURN 42'}]}");
        return requestBuilder.POST(this.txCommitURL(), statements);
    }

    private static void assertCorsHeaderPresent(HTTP.Response response) {
        AuthorizationCorsIT.assertCorsHeaderEquals(response, "*");
    }

    private static void assertCorsHeaderEquals(HTTP.Response response, String origin) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)origin, (Object)response.header("Access-Control-Allow-Origin"));
    }
}

