/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.db;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.event.DatabaseEventContext;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.event.DatabaseEventListenerAdapter;
import org.neo4j.graphdb.facade.DatabaseManagementServiceFactory;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.DelegatingPageCache;
import org.neo4j.io.pagecache.DelegatingPagedFile;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.muninn.EvictionBouncer;
import org.neo4j.io.pagecache.impl.muninn.VersionStorage;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryPools;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.EphemeralNeo4jLayoutExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.time.SystemNanoClock;

@EphemeralNeo4jLayoutExtension
class DatabaseShutdownTest {
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;

    DatabaseShutdownTest() {
    }

    @Test
    void shouldShutdownCorrectlyWhenCheckPointingOnShutdownFails() {
        TestDatabaseManagementServiceBuilderWithFailingPageCacheFlush factory = new TestDatabaseManagementServiceBuilderWithFailingPageCacheFlush(this.databaseLayout.databaseDirectory(), this.fs);
        DatabaseManagementService managementService = factory.build();
        GraphDatabaseAPI databaseService = (GraphDatabaseAPI)managementService.database("neo4j");
        DatabaseStateService dbStateService = (DatabaseStateService)databaseService.getDependencyResolver().resolveDependency(DatabaseStateService.class);
        factory.setFailFlush(true);
        Assertions.assertThrows(RuntimeException.class, () -> ((DatabaseManagementService)managementService).shutdown());
        Assertions.assertTrue((boolean)dbStateService.causeOfFailure(databaseService.databaseId()).isPresent());
        Assertions.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)factory.getDatabaseStatus());
    }

    @Test
    void invokeDatabaseShutdownListenersOnShutdown() {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem(this.fs).build();
        ShutdownListenerDatabaseEventListener shutdownHandler = new ShutdownListenerDatabaseEventListener();
        managementService.registerDatabaseEventListener((DatabaseEventListener)shutdownHandler);
        managementService.shutdown();
        Assertions.assertEquals((int)2, (int)shutdownHandler.shutdownCounter());
    }

    private static class TestDatabaseManagementServiceBuilderWithFailingPageCacheFlush
    extends TestDatabaseManagementServiceBuilder {
        private final FileSystemAbstraction fs;
        private LifeSupport globalLife;
        private volatile boolean failFlush;

        TestDatabaseManagementServiceBuilderWithFailingPageCacheFlush(Path homeDirectory, FileSystemAbstraction fs) {
            super(homeDirectory);
            this.fs = fs;
        }

        protected DatabaseManagementService newDatabaseManagementService(Config config, ExternalDependencies dependencies) {
            return new DatabaseManagementServiceFactory(DbmsInfo.COMMUNITY, CommunityEditionModule::new){

                protected GlobalModule createGlobalModule(Config config, boolean daemonMode, ExternalDependencies dependencies) {
                    GlobalModule globalModule = new GlobalModule(config, this.dbmsInfo, daemonMode, dependencies){

                        protected PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, LogService logging, Tracers tracers, JobScheduler jobScheduler, SystemNanoClock clock, MemoryPools memoryPools) {
                            PageCache pageCache = super.createPageCache(fileSystem, config, logging, tracers, jobScheduler, clock, memoryPools);
                            return new DelegatingPageCache(pageCache){

                                public PagedFile map(Path path, int pageSize, String databaseName, ImmutableSet<OpenOption> openOptions, IOController ioController, EvictionBouncer evictionGuard, VersionStorage versionStorage) throws IOException {
                                    PagedFile pagedFile = super.map(path, pageSize, databaseName, openOptions, ioController, evictionGuard, versionStorage);
                                    return new DelegatingPagedFile(pagedFile){

                                        public void flushAndForce(FileFlushEvent flushEvent) throws IOException {
                                            if (failFlush) {
                                                throw new IOException("Boom!");
                                            }
                                            super.flushAndForce(flushEvent);
                                        }
                                    };
                                }
                            };
                        }

                        protected FileSystemAbstraction createFileSystemAbstraction() {
                            return fs;
                        }
                    };
                    globalLife = globalModule.getGlobalLife();
                    return globalModule;
                }
            }.build(config, this.daemonMode, dependencies);
        }

        LifecycleStatus getDatabaseStatus() {
            return this.globalLife.getStatus();
        }

        void setFailFlush(boolean failFlush) {
            this.failFlush = failFlush;
        }
    }

    private static class ShutdownListenerDatabaseEventListener
    extends DatabaseEventListenerAdapter {
        private int shutdownCounter;

        private ShutdownListenerDatabaseEventListener() {
        }

        public void databaseShutdown(DatabaseEventContext eventContext) {
            ++this.shutdownCounter;
        }

        int shutdownCounter() {
            return this.shutdownCounter;
        }
    }
}

