/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.db;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilderImplementation;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.facade.DatabaseManagementServiceFactory;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.transaction.log.LogTailLogVersionsMetadata;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
class DatabaseStartupTest {
    @Inject
    FileSystemAbstraction fs;
    @Inject
    private Neo4jLayout neoLayout;

    DatabaseStartupTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void startDatabaseWithWrongVersionShouldFail() throws Throwable {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.neoLayout).build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        StorageEngineFactory storageEngineFactory = (StorageEngineFactory)db.getDependencyResolver().resolveDependency(StorageEngineFactory.class);
        DatabaseLayout databaseLayout = db.databaseLayout();
        managementService.shutdown();
        this.tamperWithMetaDataStore(storageEngineFactory, databaseLayout, metadataProvider -> {
            StoreId originalId = metadataProvider.getStoreId();
            metadataProvider.regenerateMetadata(new StoreId(originalId.getCreationTime(), originalId.getRandom(), "bad", "even_worse", 1, 1), UUID.randomUUID(), CursorContext.NULL_CONTEXT);
        });
        managementService = new TestDatabaseManagementServiceBuilder(databaseLayout).build();
        GraphDatabaseAPI databaseService = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            Assertions.assertThrows(DatabaseShutdownException.class, () -> ((GraphDatabaseAPI)databaseService).beginTx());
            DatabaseStateService dbStateService = (DatabaseStateService)databaseService.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Assertions.assertTrue((boolean)dbStateService.causeOfFailure(databaseService.databaseId()).isPresent());
            LogAssertions.assertThat((Throwable)((Throwable)dbStateService.causeOfFailure(databaseService.databaseId()).get())).hasRootCauseExactlyInstanceOf(IllegalArgumentException.class).hasRootCauseMessage("Unknown store version 'bad-even_worse-1.1'");
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void startDatabaseWithWrongTransactionFilesShouldFail() throws Exception {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.neoLayout).build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        DatabaseLayout databaseLayout = db.databaseLayout();
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        StorageEngineFactory storageEngineFactory = (StorageEngineFactory)db.getDependencyResolver().resolveDependency(StorageEngineFactory.class);
        managementService.shutdown();
        this.tamperWithMetaDataStore(storageEngineFactory, databaseLayout, metadataProvider -> {
            StoreId originalId = metadataProvider.getStoreId();
            StoreId newStoreId = new StoreId(System.currentTimeMillis() + 1L, originalId.getRandom(), originalId.getStorageEngineName(), originalId.getFormatName(), originalId.getMajorVersion(), originalId.getMinorVersion());
            metadataProvider.regenerateMetadata(newStoreId, UUID.randomUUID(), CursorContext.NULL_CONTEXT);
        });
        managementService = new TestDatabaseManagementServiceBuilder(databaseLayout).build();
        try {
            db = (GraphDatabaseAPI)managementService.database("neo4j");
            Assertions.assertFalse((boolean)db.isAvailable(10L));
            DatabaseStateService dbStateService = (DatabaseStateService)db.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Optional cause = dbStateService.causeOfFailure(db.databaseId());
            Assertions.assertTrue((boolean)cause.isPresent());
            Assertions.assertTrue((boolean)((Throwable)cause.get()).getCause().getMessage().contains("Mismatching store id"));
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void startDatabaseWithoutStoreFilesAndWithTransactionLogFilesFailure() throws IOException {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.neoLayout).build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        DatabaseLayout databaseLayout = db.databaseLayout();
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        managementService.shutdown();
        this.fs.deleteRecursively(databaseLayout.databaseDirectory());
        managementService = new TestDatabaseManagementServiceBuilder(databaseLayout).build();
        try {
            db = (GraphDatabaseAPI)managementService.database("neo4j");
            Assertions.assertFalse((boolean)db.isAvailable(10L));
            DatabaseStateService dbStateService = (DatabaseStateService)db.getDependencyResolver().resolveDependency(DatabaseStateService.class);
            Optional cause = dbStateService.causeOfFailure(db.databaseId());
            Assertions.assertTrue((boolean)cause.isPresent());
            LogAssertions.assertThat((Throwable)((Throwable)cause.get())).hasStackTraceContaining("Fail to start '" + db.databaseId() + "' since transaction logs were found, while database ");
        }
        finally {
            managementService.shutdown();
        }
    }

    @Test
    void startTestDatabaseOnProvidedNonAbsoluteFile() {
        Path directory = Path.of("target/notAbsoluteDirectory", new String[0]);
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(directory).impermanent().build();
        managementService.shutdown();
    }

    @Test
    void startCommunityDatabaseOnProvidedNonAbsoluteFile() {
        Path directory = Path.of("target/notAbsoluteDirectory", new String[0]);
        EphemeralCommunityManagementServiceFactory factory = new EphemeralCommunityManagementServiceFactory();
        EphemeralDatabaseManagementServiceBuilder databaseFactory = new EphemeralDatabaseManagementServiceBuilder(directory, factory);
        DatabaseManagementService managementService = databaseFactory.build();
        managementService.database("neo4j");
        managementService.shutdown();
    }

    @Test
    void dumpSystemDiagnosticLoggingOnStartup() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.neoLayout).setInternalLogProvider((InternalLogProvider)logProvider).setConfig(GraphDatabaseInternalSettings.dump_diagnostics, (Object)true).build();
        managementService.database("neo4j");
        try {
            LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{"System diagnostics", "System memory information", "JVM memory information", "Operating system information", "JVM information", "Java classpath", "Library path", "System properties", "(IANA) TimeZone database version", "Network information", "DBMS config"});
        }
        finally {
            managementService.shutdown();
        }
    }

    private void tamperWithMetaDataStore(StorageEngineFactory storageEngineFactory, DatabaseLayout databaseLayout, Consumer<MetadataProvider> tamper) throws Exception {
        try (JobScheduler scheduler = JobSchedulerFactory.createInitialisedScheduler();
             MuninnPageCache pageCache = new MuninnPageCache((PageSwapperFactory)new SingleFilePageSwapperFactory(this.fs, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE), scheduler, MuninnPageCache.config((int)1000));
             MetadataProvider metadataProvider = storageEngineFactory.transactionMetaDataStore(this.fs, databaseLayout, Config.defaults(), (PageCache)pageCache, DatabaseReadOnlyChecker.writable(), CursorContextFactory.NULL_CONTEXT_FACTORY, LogTailLogVersionsMetadata.EMPTY_LOG_TAIL, PageCacheTracer.NULL);){
            tamper.accept(metadataProvider);
        }
    }

    private static class EphemeralCommunityManagementServiceFactory
    extends DatabaseManagementServiceFactory {
        EphemeralCommunityManagementServiceFactory() {
            super(DbmsInfo.COMMUNITY, CommunityEditionModule::new);
        }

        protected GlobalModule createGlobalModule(Config config, boolean daemonMode, ExternalDependencies dependencies) {
            return new GlobalModule(config, this.dbmsInfo, daemonMode, dependencies){

                protected FileSystemAbstraction createFileSystemAbstraction() {
                    return new EphemeralFileSystemAbstraction();
                }
            };
        }
    }

    private static class EphemeralDatabaseManagementServiceBuilder
    extends DatabaseManagementServiceBuilderImplementation {
        private final EphemeralCommunityManagementServiceFactory factory;

        EphemeralDatabaseManagementServiceBuilder(Path homeDirectory, EphemeralCommunityManagementServiceFactory factory) {
            super(homeDirectory);
            this.factory = factory;
        }

        protected DatabaseManagementService newDatabaseManagementService(Config config, ExternalDependencies dependencies) {
            return this.factory.build(this.augmentConfig(config), this.daemonMode, dependencies);
        }
    }
}

