/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.harness;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheTestSupport;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.randomharness.Command;
import org.neo4j.io.pagecache.randomharness.PageCountRecordFormat;
import org.neo4j.io.pagecache.randomharness.Phase;
import org.neo4j.io.pagecache.randomharness.RandomPageCacheTestHarness;
import org.neo4j.io.pagecache.randomharness.RecordFormat;
import org.neo4j.io.pagecache.randomharness.StandardRecordFormat;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
@ResourceLock(value="sharedContext")
abstract class PageCacheHarnessTest<T extends PageCache>
extends PageCacheTestSupport<T> {
    @Inject
    public TestDirectory directory;

    PageCacheHarnessTest() {
    }

    ImmutableSet<OpenOption> getOpenOptions() {
        return Sets.immutable.empty();
    }

    List<Command> additionalDisabledCommands() {
        return List.of();
    }

    @RepeatedTest(value=10)
    void readsAndWritesMustBeMutuallyConsistent() throws Exception {
        int filePageCount = 100;
        try (RandomPageCacheTestHarness harness = new RandomPageCacheTestHarness();){
            harness.disableCommands(Command.FlushCache, Command.FlushFile, Command.MapFile, Command.UnmapFile);
            this.additionalDisabledCommands().forEach(xva$0 -> harness.disableCommands((Command)((Object)xva$0)));
            harness.setCommandProbabilityFactor(Command.ReadRecord, 0.5);
            harness.setCommandProbabilityFactor(Command.WriteRecord, 0.5);
            harness.setConcurrencyLevel(8);
            harness.setFilePageCount(filePageCount);
            harness.setInitialMappedFiles(1);
            harness.setFileSystem(this.fs);
            harness.setVerification(this.filesAreCorrectlyWrittenVerification(new StandardRecordFormat(), filePageCount));
            harness.setBasePath(this.directory.directory("readsAndWritesMustBeMutuallyConsistent"));
            harness.setOpenOptions(this.getOpenOptions());
            harness.run(this.SEMI_LONG_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
    }

    @Test
    void concurrentPageFaultingMustNotPutInterleavedDataIntoPages() throws Exception {
        int filePageCount = 11;
        PageCountRecordFormat recordFormat = new PageCountRecordFormat();
        try (RandomPageCacheTestHarness harness = new RandomPageCacheTestHarness();){
            harness.setConcurrencyLevel(11);
            harness.setUseAdversarialIO(false);
            harness.setCachePageCount(3);
            harness.setFilePageCount(filePageCount);
            harness.setInitialMappedFiles(1);
            harness.setCommandCount(10000);
            harness.setRecordFormat(recordFormat);
            harness.setFileSystem(this.fs);
            harness.setBasePath(this.directory.directory("concurrentPageFaultingMustNotPutInterleavedDataIntoPages"));
            harness.setOpenOptions(this.getOpenOptions());
            harness.disableCommands(Command.FlushCache, Command.FlushFile, Command.MapFile, Command.UnmapFile, Command.WriteRecord, Command.WriteMulti);
            this.additionalDisabledCommands().forEach(xva$0 -> harness.disableCommands((Command)((Object)xva$0)));
            harness.setPreparation((cache, fs, filesTouched) -> {
                Path file = (Path)filesTouched.iterator().next();
                try (PagedFile pf = cache.map(file, cache.pageSize(), "neo4j", this.getOpenOptions());
                     PageCursor cursor = pf.io(0L, 2, CursorContext.NULL_CONTEXT);){
                    for (int pageId = 0; pageId < filePageCount; ++pageId) {
                        cursor.next();
                        recordFormat.fillWithRecords(cursor);
                    }
                }
            });
            harness.run(this.LONG_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
    }

    @Test
    void concurrentFlushingMustNotPutInterleavedDataIntoFile() throws Exception {
        StandardRecordFormat recordFormat = new StandardRecordFormat();
        int filePageCount = 2000;
        try (RandomPageCacheTestHarness harness = new RandomPageCacheTestHarness();){
            harness.setConcurrencyLevel(16);
            harness.setUseAdversarialIO(false);
            harness.setCachePageCount(filePageCount / 2);
            harness.setFilePageCount(filePageCount);
            harness.setInitialMappedFiles(3);
            harness.setCommandCount(15000);
            harness.setFileSystem(this.fs);
            harness.setBasePath(this.directory.directory("concurrentFlushingMustNotPutInterleavedDataIntoFile"));
            harness.setOpenOptions(this.getOpenOptions());
            harness.disableCommands(Command.MapFile, Command.UnmapFile, Command.ReadRecord, Command.ReadMulti);
            this.additionalDisabledCommands().forEach(xva$0 -> harness.disableCommands((Command)((Object)xva$0)));
            harness.setVerification(this.filesAreCorrectlyWrittenVerification(recordFormat, filePageCount));
            harness.run(this.LONG_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
    }

    @Test
    void concurrentFlushingWithMischiefMustNotPutInterleavedDataIntoFile() throws Exception {
        StandardRecordFormat recordFormat = new StandardRecordFormat();
        int filePageCount = 2000;
        try (RandomPageCacheTestHarness harness = new RandomPageCacheTestHarness();){
            harness.setConcurrencyLevel(16);
            harness.setUseAdversarialIO(true);
            harness.setMischiefRate(0.5);
            harness.setFailureRate(0.0);
            harness.setErrorRate(0.0);
            harness.setCachePageCount(filePageCount / 2);
            harness.setFilePageCount(filePageCount);
            harness.setInitialMappedFiles(3);
            harness.setCommandCount(15000);
            harness.setFileSystem(this.fs);
            harness.setBasePath(this.directory.directory("concurrentFlushingWithMischiefMustNotPutInterleavedDataIntoFile"));
            harness.setOpenOptions(this.getOpenOptions());
            harness.disableCommands(Command.MapFile, Command.UnmapFile, Command.ReadRecord, Command.ReadMulti);
            this.additionalDisabledCommands().forEach(xva$0 -> harness.disableCommands((Command)((Object)xva$0)));
            harness.setVerification(this.filesAreCorrectlyWrittenVerification(recordFormat, filePageCount));
            harness.run(this.LONG_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
    }

    @Test
    void concurrentFlushingWithFailuresMustNotPutInterleavedDataIntoFile() throws Exception {
        StandardRecordFormat recordFormat = new StandardRecordFormat();
        int filePageCount = 2000;
        try (RandomPageCacheTestHarness harness = new RandomPageCacheTestHarness();){
            harness.setConcurrencyLevel(16);
            harness.setUseAdversarialIO(true);
            harness.setMischiefRate(0.0);
            harness.setFailureRate(0.5);
            harness.setErrorRate(0.0);
            harness.setCachePageCount(filePageCount / 2);
            harness.setFilePageCount(filePageCount);
            harness.setInitialMappedFiles(3);
            harness.setCommandCount(15000);
            harness.setFileSystem(this.fs);
            harness.setBasePath(this.directory.directory("concurrentFlushingWithFailuresMustNotPutInterleavedDataIntoFile"));
            harness.setOpenOptions(this.getOpenOptions());
            harness.disableCommands(Command.MapFile, Command.UnmapFile, Command.ReadRecord, Command.ReadMulti);
            this.additionalDisabledCommands().forEach(xva$0 -> harness.disableCommands((Command)((Object)xva$0)));
            harness.setVerification(this.filesAreCorrectlyWrittenVerification(recordFormat, filePageCount));
            harness.run(this.LONG_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
    }

    @RepeatedTest(value=10)
    void readsWritesAndTouches() throws Exception {
        int filePageCount = 100;
        try (RandomPageCacheTestHarness harness = new RandomPageCacheTestHarness();){
            harness.disableCommands(Command.MapFile, Command.UnmapFile);
            this.additionalDisabledCommands().forEach(xva$0 -> harness.disableCommands((Command)((Object)xva$0)));
            harness.setCommandProbabilityFactor(Command.ReadRecord, 0.5);
            harness.setCommandProbabilityFactor(Command.WriteRecord, 0.5);
            harness.setCommandProbabilityFactor(Command.Touch, 0.5);
            harness.setConcurrencyLevel(8);
            harness.setFilePageCount(filePageCount);
            harness.setInitialMappedFiles(5);
            harness.setCachePageCount(filePageCount);
            harness.setFileSystem(this.fs);
            harness.setVerification(this.filesAreCorrectlyWrittenVerification(new StandardRecordFormat(), filePageCount));
            harness.setBasePath(this.directory.directory("readsWritesAndTouches"));
            harness.setOpenOptions(this.getOpenOptions());
            harness.run(this.SEMI_LONG_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
    }

    private Phase filesAreCorrectlyWrittenVerification(RecordFormat recordFormat, int filePageCount) {
        return (cache, fs1, filesTouched) -> {
            for (Path file : filesTouched) {
                ImmutableSet<OpenOption> openOptions = this.getOpenOptions();
                try (PagedFile pf = cache.map(file, cache.pageSize(), "neo4j", openOptions);
                     PageCursor cursor = pf.io(0L, 1, CursorContext.NULL_CONTEXT);){
                    for (int pageId = 0; pageId < filePageCount && cursor.next(); ++pageId) {
                        try {
                            recordFormat.assertRecordsWrittenCorrectly(cursor);
                            continue;
                        }
                        catch (Throwable th) {
                            th.addSuppressed(new Exception("pageId = " + pageId));
                            throw th;
                        }
                    }
                }
                int reservedBytes = cache.pageReservedBytes(openOptions);
                StoreChannel channel = fs1.read(file);
                try {
                    recordFormat.assertRecordsWrittenCorrectly(file, channel, reservedBytes);
                }
                finally {
                    if (channel == null) continue;
                    channel.close();
                }
            }
        };
    }
}

