/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.nio.ByteOrder;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.StubPageCursor;
import org.neo4j.io.pagecache.impl.CompositePageCursor;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

public class CompositePageCursorTest {
    private static final int PAYLOAD_SIZE = 16;
    private final int PAGE_SIZE = 16 + this.getReservedBytes();
    private StubPageCursor first;
    private StubPageCursor second;
    private final byte[] bytes = new byte[4];

    private StubPageCursor generatePage(int initialPageId, int pageSize, int initialValue) {
        int reservedBytes = this.getReservedBytes();
        StubPageCursor cursor = new StubPageCursor((long)initialPageId, ByteBuffers.allocate((int)pageSize, (ByteOrder)ByteOrder.BIG_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE), reservedBytes);
        for (int i = 0; i < pageSize - reservedBytes; ++i) {
            cursor.putByte(i, (byte)(initialValue + i));
        }
        return cursor;
    }

    protected int getReservedBytes() {
        return 0;
    }

    @BeforeEach
    void setUp() {
        this.first = this.generatePage(0, this.PAGE_SIZE, 160);
        this.second = this.generatePage(2, this.PAGE_SIZE + 8, 176);
    }

    @Test
    void getByteMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        Assertions.assertThat((byte)c.getByte()).isEqualTo((byte)-96);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getByteMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        Assertions.assertThat((byte)c.getByte()).isEqualTo((byte)-96);
        Assertions.assertThat((byte)c.getByte()).isEqualTo((byte)-80);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getByteMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        Assertions.assertThat((byte)c.getByte()).isEqualTo((byte)-95);
        Assertions.assertThat((byte)c.getByte()).isEqualTo((byte)-80);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getByteMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        Assertions.assertThat((byte)c.getByte()).isEqualTo((byte)-96);
        Assertions.assertThat((byte)c.getByte()).isEqualTo((byte)-79);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putByteMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        c.putByte((byte)1);
        c.setOffset(0);
        Assertions.assertThat((byte)c.getByte()).isEqualTo((byte)1);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putByteMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        c.putByte((byte)1);
        c.putByte((byte)2);
        c.setOffset(1);
        Assertions.assertThat((byte)c.getByte()).isEqualTo((byte)2);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putByteMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        c.putByte((byte)1);
        Assertions.assertThat((byte)this.first.getByte(1)).isEqualTo((byte)1);
        Assertions.assertThat((byte)c.getByte()).isEqualTo((byte)-80);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putByteMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)2);
        c.putByte((byte)1);
        c.putByte((byte)2);
        Assertions.assertThat((byte)this.second.getByte(1)).isEqualTo((byte)2);
        Assertions.assertThat((byte)c.getByte()).isEqualTo((byte)-78);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getByteWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)1);
        Assertions.assertThat((byte)c.getByte(1)).isEqualTo((byte)-94);
        Assertions.assertThat((byte)c.getByte(2)).isEqualTo((byte)-78);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putByteWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        c.putByte(1, (byte)1);
        c.putByte(2, (byte)2);
        Assertions.assertThat((byte)c.getByte()).isEqualTo((byte)-95);
        Assertions.assertThat((byte)c.getByte()).isEqualTo((byte)1);
        Assertions.assertThat((byte)c.getByte()).isEqualTo((byte)2);
        Assertions.assertThat((byte)c.getByte()).isEqualTo((byte)-77);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getShortMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        Assertions.assertThat((short)c.getShort()).isEqualTo((short)-24415);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getShortMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        Assertions.assertThat((short)c.getShort()).isEqualTo((short)-24415);
        Assertions.assertThat((short)c.getShort()).isEqualTo((short)-20303);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getShortMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        Assertions.assertThat((short)c.getShort()).isEqualTo((short)-24158);
        Assertions.assertThat((short)c.getShort()).isEqualTo((short)-20303);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getShortMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        Assertions.assertThat((short)c.getShort()).isEqualTo((short)-24415);
        Assertions.assertThat((short)c.getShort()).isEqualTo((short)-20046);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putShortMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        c.putShort((short)1);
        c.setOffset(0);
        Assertions.assertThat((short)c.getShort()).isEqualTo((short)1);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putShortMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        c.putShort((short)1);
        c.putShort((short)2);
        c.setOffset(2);
        Assertions.assertThat((short)c.getShort()).isEqualTo((short)2);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putShortMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        c.putShort((short)1);
        Assertions.assertThat((short)this.first.getShort(1)).isEqualTo((short)1);
        Assertions.assertThat((short)c.getShort()).isEqualTo((short)-20303);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putShortMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)4);
        c.putShort((short)1);
        c.putShort((short)2);
        Assertions.assertThat((short)this.second.getShort(1)).isEqualTo((short)2);
        Assertions.assertThat((short)c.getShort()).isEqualTo((short)-19532);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getShortWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)3, (PageCursor)this.second, (int)2);
        Assertions.assertThat((short)c.getShort(1)).isEqualTo((short)-23901);
        Assertions.assertThat((short)c.getShort(3)).isEqualTo((short)-19789);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putShortWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.putShort(2, (short)1);
        c.putShort(4, (short)2);
        Assertions.assertThat((short)c.getShort()).isEqualTo((short)-24158);
        Assertions.assertThat((short)c.getShort()).isEqualTo((short)1);
        Assertions.assertThat((short)c.getShort()).isEqualTo((short)2);
        Assertions.assertThat((short)c.getShort()).isEqualTo((short)-19275);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getIntMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        Assertions.assertThat((int)c.getInt()).isEqualTo(-1600019805);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getIntMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        Assertions.assertThat((int)c.getInt()).isEqualTo(-1600019805);
        Assertions.assertThat((int)c.getInt()).isEqualTo(-1330531661);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getIntMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        Assertions.assertThat((int)c.getInt()).isEqualTo(-1583176796);
        Assertions.assertThat((int)c.getInt()).isEqualTo(-1330531661);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getIntMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        Assertions.assertThat((int)c.getInt()).isEqualTo(-1600019805);
        Assertions.assertThat((int)c.getInt()).isEqualTo(-1313688652);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putIntMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.putInt(1);
        c.setOffset(0);
        Assertions.assertThat((int)c.getInt()).isEqualTo(1);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putIntMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.putInt(1);
        c.putInt(2);
        c.setOffset(4);
        Assertions.assertThat((int)c.getInt()).isEqualTo(2);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putIntMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.putInt(1);
        Assertions.assertThat((int)this.first.getInt(1)).isEqualTo(1);
        Assertions.assertThat((int)c.getInt()).isEqualTo(-1330531661);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putIntMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)8);
        c.putInt(1);
        c.putInt(2);
        Assertions.assertThat((int)this.second.getInt(1)).isEqualTo(2);
        Assertions.assertThat((int)c.getInt()).isEqualTo(-1246316616);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getIntWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)5, (PageCursor)this.second, (int)4);
        Assertions.assertThat((int)c.getInt(1)).isEqualTo(-1566333787);
        Assertions.assertThat((int)c.getInt(5)).isEqualTo(-1296845643);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putIntWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        c.putInt(4, 1);
        c.putInt(8, 2);
        Assertions.assertThat((int)c.getInt()).isEqualTo(-1583176796);
        Assertions.assertThat((int)c.getInt()).isEqualTo(1);
        Assertions.assertThat((int)c.getInt()).isEqualTo(2);
        Assertions.assertThat((int)c.getInt()).isEqualTo(-1229473607);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getLongMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        Assertions.assertThat((long)c.getLong()).isEqualTo(-6872032732664977753L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getLongMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        Assertions.assertThat((long)c.getLong()).isEqualTo(-6872032732664977753L);
        Assertions.assertThat((long)c.getLong()).isEqualTo(-5714589967255750985L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getLongMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        Assertions.assertThat((long)c.getLong()).isEqualTo(-6799692559826901080L);
        Assertions.assertThat((long)c.getLong()).isEqualTo(-5714589967255750985L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getLongMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        Assertions.assertThat((long)c.getLong()).isEqualTo(-6872032732664977753L);
        Assertions.assertThat((long)c.getLong()).isEqualTo(-5642249794417674312L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putLongMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        c.putLong(1L);
        c.setOffset(0);
        Assertions.assertThat((long)c.getLong()).isEqualTo(1L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putLongMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        c.putLong(1L);
        c.putLong(2L);
        c.setOffset(8);
        Assertions.assertThat((long)c.getLong()).isEqualTo(2L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putLongMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        c.putLong(1L);
        Assertions.assertThat((long)this.first.getLong(1)).isEqualTo(1L);
        Assertions.assertThat((long)c.getLong()).isEqualTo(-5714589967255750985L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putLongMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)16);
        c.putLong(1L);
        c.putLong(2L);
        Assertions.assertThat((long)this.second.getLong(1)).isEqualTo(2L);
        Assertions.assertThat((long)c.getLong()).isEqualTo(-5063528411713060928L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getLongWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)9, (PageCursor)this.second, (int)8);
        Assertions.assertThat((long)c.getLong(1)).isEqualTo(-6727352386988824407L);
        Assertions.assertThat((long)c.getLong(9)).isEqualTo(-5569909621579597639L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putLongWithOffsetMustHitCorrectCursors() {
        this.first = this.generatePage(0, this.PAGE_SIZE + 8, 160);
        this.second = this.generatePage(0, this.PAGE_SIZE + 8, 192);
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        c.putLong(8, 1L);
        c.putLong(16, 2L);
        Assertions.assertThat((long)c.getLong()).isEqualTo(-6799692559826901080L);
        Assertions.assertThat((long)c.getLong()).isEqualTo(1L);
        Assertions.assertThat((long)c.getLong()).isEqualTo(2L);
        Assertions.assertThat((long)c.getLong()).isEqualTo(-3833745473465757487L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getBytesMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.getBytes(this.bytes);
        Assertions.assertThat((byte[])this.bytes).containsExactly(new int[]{160, 161, 162, 163});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getBytesMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.getBytes(this.bytes);
        Assertions.assertThat((byte[])this.bytes).containsExactly(new int[]{160, 161, 162, 163});
        c.getBytes(this.bytes);
        Assertions.assertThat((byte[])this.bytes).containsExactly(new int[]{176, 177, 178, 179});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getBytesMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.getBytes(this.bytes);
        Assertions.assertThat((byte[])this.bytes).containsExactly(new int[]{161, 162, 163, 164});
        c.getBytes(this.bytes);
        Assertions.assertThat((byte[])this.bytes).containsExactly(new int[]{176, 177, 178, 179});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getBytesMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.getBytes(this.bytes);
        Assertions.assertThat((byte[])this.bytes).containsExactly(new int[]{160, 161, 162, 163});
        c.getBytes(this.bytes);
        Assertions.assertThat((byte[])this.bytes).containsExactly(new int[]{177, 178, 179, 180});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putBytesMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.putBytes(new byte[]{1, 2, 3, 4});
        c.setOffset(0);
        c.getBytes(this.bytes);
        Assertions.assertThat((byte[])this.bytes).containsExactly(new int[]{1, 2, 3, 4});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putBytesMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)4);
        c.putBytes(new byte[]{1});
        c.putBytes(new byte[]{2});
        c.setOffset(1);
        c.getBytes(this.bytes);
        Assertions.assertThat((byte[])Arrays.copyOfRange(this.bytes, 0, 1)).containsExactly(new int[]{2});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putBytesMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)4);
        c.putBytes(new byte[]{1});
        this.first.setOffset(1);
        this.first.getBytes(this.bytes);
        Assertions.assertThat((byte[])Arrays.copyOfRange(this.bytes, 0, 1)).containsExactly(new int[]{1});
        c.getBytes(this.bytes);
        Assertions.assertThat((byte[])this.bytes).containsExactly(new int[]{176, 177, 178, 179});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putBytesMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)8);
        c.putBytes(new byte[]{1});
        c.putBytes(new byte[]{2});
        this.second.setOffset(1);
        this.second.getBytes(this.bytes);
        Assertions.assertThat((byte[])Arrays.copyOfRange(this.bytes, 0, 1)).containsExactly(new int[]{2});
        c.getBytes(this.bytes);
        Assertions.assertThat((byte[])this.bytes).containsExactly(new int[]{181, 182, 183, 184});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void overlappingGetAccess() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        c.setOffset(14);
        Assertions.assertThat((int)c.getInt()).isEqualTo(-1364217679);
        c.setOffset(15);
        Assertions.assertThat((short)c.getShort()).isEqualTo((short)-20560);
        c.setOffset(12);
        Assertions.assertThat((long)c.getLong()).isEqualTo(-6003950658608057677L);
        c.setOffset(14);
        c.getBytes(this.bytes);
        Assertions.assertThat((byte[])this.bytes).containsExactly(new int[]{174, 175, 176, 177});
    }

    @Test
    void overlappingOffsetGetAccess() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        Assertions.assertThat((int)c.getInt(14)).isEqualTo(-1364217679);
        Assertions.assertThat((short)c.getShort(15)).isEqualTo((short)-20560);
        Assertions.assertThat((long)c.getLong(12)).isEqualTo(-6003950658608057677L);
    }

    @Test
    void overlappingPutAccess() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        c.setOffset(14);
        c.putInt(16909060);
        c.setOffset(14);
        Assertions.assertThat((int)c.getInt()).isEqualTo(16909060);
        c.setOffset(15);
        c.putShort((short)258);
        c.setOffset(15);
        Assertions.assertThat((short)c.getShort()).isEqualTo((short)258);
        c.setOffset(12);
        c.putLong(72623859790382856L);
        c.setOffset(12);
        Assertions.assertThat((long)c.getLong()).isEqualTo(72623859790382856L);
        c.setOffset(14);
        for (int i = 0; i < this.bytes.length; ++i) {
            this.bytes[i] = (byte)(i + 1);
        }
        c.putBytes(this.bytes);
        c.setOffset(14);
        c.getBytes(this.bytes);
        Assertions.assertThat((byte[])this.bytes).containsExactly(new int[]{1, 2, 3, 4});
    }

    @Test
    void overlappingOffsetPutAccess() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        c.putInt(14, 16909060);
        Assertions.assertThat((int)c.getInt(14)).isEqualTo(16909060);
        c.putShort(15, (short)258);
        Assertions.assertThat((short)c.getShort(15)).isEqualTo((short)258);
        c.putLong(12, 72623859790382856L);
        Assertions.assertThat((long)c.getLong(12)).isEqualTo(72623859790382856L);
    }

    @Test
    void closeBothCursorsOnClose() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.close();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.first.isClosed());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.second.isClosed());
    }

    @Test
    void nextIsNotSupportedOperation() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
            pageCursor.next();
        });
    }

    @Test
    void nextWithPageIdIsNotSupportedOperation() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
            pageCursor.next(12L);
        });
    }

    @Test
    public void markCompositeCursor() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.getByte();
        this.second.getLong();
        int firstMark = this.first.getOffset();
        int secondMark = this.second.getOffset();
        pageCursor.mark();
        this.first.getByte();
        this.second.getLong();
        org.junit.jupiter.api.Assertions.assertNotEquals((int)firstMark, (int)this.first.getOffset());
        org.junit.jupiter.api.Assertions.assertNotEquals((int)secondMark, (int)this.second.getOffset());
        pageCursor.setOffsetToMark();
        org.junit.jupiter.api.Assertions.assertEquals((int)firstMark, (int)this.first.getOffset());
        org.junit.jupiter.api.Assertions.assertEquals((int)secondMark, (int)this.second.getOffset());
    }

    @Test
    void getOffsetMustReturnOffsetIntoView() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.getLong();
        Assertions.assertThat((int)pageCursor.getOffset()).isEqualTo(8);
        pageCursor.getLong();
        pageCursor.getLong();
        Assertions.assertThat((int)pageCursor.getOffset()).isEqualTo(24);
    }

    @Test
    void setOffsetMustSetOffsetIntoView() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.setOffset(13);
        Assertions.assertThat((int)this.first.getOffset()).isEqualTo(13);
        Assertions.assertThat((int)this.second.getOffset()).isEqualTo(0);
        pageCursor.setOffset(18);
        Assertions.assertThat((int)this.first.getOffset()).isEqualTo(16);
        Assertions.assertThat((int)this.second.getOffset()).isEqualTo(2);
    }

    @Test
    void pageIdEqualFirstCursorPageIdBeforeFlip() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        org.junit.jupiter.api.Assertions.assertEquals((long)this.first.getCurrentPageId(), (long)pageCursor.getCurrentPageId());
        pageCursor.getLong();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.first.getCurrentPageId(), (long)pageCursor.getCurrentPageId());
        pageCursor.getLong();
        org.junit.jupiter.api.Assertions.assertNotEquals((long)this.first.getCurrentPageId(), (long)pageCursor.getCurrentPageId());
    }

    @Test
    void pageIdEqualSecondCursorPageIdAfterFlip() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        org.junit.jupiter.api.Assertions.assertNotEquals((long)this.second.getCurrentPageId(), (long)pageCursor.getCurrentPageId());
        pageCursor.getLong();
        org.junit.jupiter.api.Assertions.assertNotEquals((long)this.second.getCurrentPageId(), (long)pageCursor.getCurrentPageId());
        pageCursor.getLong();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.second.getCurrentPageId(), (long)pageCursor.getCurrentPageId());
    }

    @Test
    void retryShouldCheckAndResetBothCursors() throws Exception {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.shouldRetry());
        this.first.setNeedsRetry(true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.shouldRetry());
        this.first.setNeedsRetry(false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.shouldRetry());
        this.second.setNeedsRetry(true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.shouldRetry());
    }

    @Test
    void retryMustResetOffsetsInBothCursors() throws Exception {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        pageCursor.setOffset(5);
        this.first.setOffset(3);
        this.second.setOffset(4);
        this.first.setNeedsRetry(true);
        pageCursor.shouldRetry();
        Assertions.assertThat((int)this.first.getOffset()).isEqualTo(1);
        Assertions.assertThat((int)this.second.getOffset()).isEqualTo(2);
        Assertions.assertThat((int)pageCursor.getOffset()).isEqualTo(0);
        pageCursor.setOffset(5);
        this.first.setOffset(3);
        this.second.setOffset(4);
        this.first.setNeedsRetry(false);
        this.second.setNeedsRetry(true);
        pageCursor.shouldRetry();
        Assertions.assertThat((int)this.first.getOffset()).isEqualTo(1);
        Assertions.assertThat((int)this.second.getOffset()).isEqualTo(2);
        Assertions.assertThat((int)pageCursor.getOffset()).isEqualTo(0);
    }

    @Test
    void retryMustClearTheOutOfBoundsFlags() throws Exception {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.getByte(-1);
        this.second.getByte(-1);
        pageCursor.getByte(-1);
        this.first.setNeedsRetry(true);
        pageCursor.shouldRetry();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.first.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.second.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void checkAndClearCompositeBoundsFlagMustClearFirstBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.getByte(-1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.first.checkAndClearBoundsFlag());
    }

    @Test
    void checkAndClearCompositeBoundsFlagMustClearSecondBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.second.getByte(-1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.second.checkAndClearBoundsFlag());
    }

    @Test
    void composeMustNotThrowIfFirstLengthExpandsBeyondFirstPage() {
        CompositePageCursor.compose((PageCursor)this.first, (int)Integer.MAX_VALUE, (PageCursor)this.second, (int)16);
    }

    @Test
    void composeMustNotThrowIfSecondLengthExpandsBeyondSecondPage() {
        CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)Integer.MAX_VALUE);
    }

    @Test
    void compositeCursorDoesNotSupportCopyTo() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
            pageCursor.copyTo(0, (PageCursor)new StubPageCursor(0L, 7), 89, 6);
        });
    }

    @Test
    void compositeCursorDoesNotSupportCopyPage() {
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
            pageCursor.copyPage((PageCursor)new StubPageCursor(0L, 1));
        });
    }

    @Test
    void getByteBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 3 * this.PAGE_SIZE; ++i) {
            pageCursor.getByte();
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getByteOffsetBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getByte(i);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putByteBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putByte((byte)1);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putByteOffsetBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putByte(i, (byte)1);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getByteOffsetBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.getByte(-1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putByteOffsetBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.putByte(-1, (byte)1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getShortBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getShort();
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getShortOffsetBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getShort(i);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putShortBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putShort((short)1);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putShortOffsetBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putShort(i, (short)1);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getShortOffsetBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.getShort(-1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putShortOffsetBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.putShort(-1, (short)1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getIntBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getInt();
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getIntOffsetBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getInt(i);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putIntBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putInt(1);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putIntOffsetBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putInt(i, 1);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getIntOffsetBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.getInt(-1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putIntOffsetBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.putInt(-1, 1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getLongBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getLong();
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getLongOffsetBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getLong(i);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putLongBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putLong(1L);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putLongOffsetBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putLong(i, 1L);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getLongOffsetBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.getLong(-1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putLongOffsetBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.putLong(-1, 1L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getByteArrayBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getBytes(this.bytes);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putByteArrayBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putBytes(this.bytes);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void setCursorErrorMustApplyToCursorAtCurrentOffset() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        String firstMsg = "first boo";
        String secondMsg = "second boo";
        cursor.setCursorException(firstMsg);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
        try {
            this.first.checkAndClearCursorException();
            org.junit.jupiter.api.Assertions.fail((String)"first checkAndClearCursorError should have thrown");
        }
        catch (CursorException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo(firstMsg);
        }
        cursor.setOffset(16);
        cursor.setCursorException(secondMsg);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
        try {
            this.second.checkAndClearCursorException();
            org.junit.jupiter.api.Assertions.fail((String)"second checkAndClearCursorError should have thrown");
        }
        catch (CursorException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo(secondMsg);
        }
    }

    @Test
    void checkAndClearCursorErrorMustNotThrowIfNoErrorsAreSet() throws Exception {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        cursor.checkAndClearCursorException();
    }

    @Test
    void checkAndClearCursorErrorMustThrowIfFirstCursorHasError() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setCursorException("boo");
        try {
            cursor.checkAndClearCursorException();
            org.junit.jupiter.api.Assertions.fail((String)"composite cursor checkAndClearCursorError should have thrown");
        }
        catch (CursorException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("boo");
        }
    }

    @Test
    void checkAndClearCursorErrorMustThrowIfSecondCursorHasError() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.second.setCursorException("boo");
        try {
            cursor.checkAndClearCursorException();
            org.junit.jupiter.api.Assertions.fail((String)"composite cursor checkAndClearCursorError should have thrown");
        }
        catch (CursorException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("boo");
        }
    }

    @Test
    void checkAndClearCursorErrorWillOnlyCheckFirstCursorIfBothHaveErrorsSet() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setCursorException("first boo");
        this.second.setCursorException("second boo");
        try {
            cursor.checkAndClearCursorException();
            org.junit.jupiter.api.Assertions.fail((String)"composite cursor checkAndClearCursorError should have thrown");
        }
        catch (CursorException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("first boo");
        }
        try {
            this.second.checkAndClearCursorException();
            org.junit.jupiter.api.Assertions.fail((String)"second cursor checkAndClearCursorError should have thrown");
        }
        catch (CursorException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("second boo");
        }
    }

    @Test
    void clearCursorErrorMustClearBothCursors() throws Exception {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setCursorException("first boo");
        this.second.setCursorException("second boo");
        cursor.clearCursorException();
        this.first.checkAndClearCursorException();
        this.second.checkAndClearCursorException();
        cursor.checkAndClearCursorException();
    }

    @Test
    void isWriteLockedMustBeTrueIfBothCursorsAreWriteLocked() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setWriteLocked(true);
        this.second.setWriteLocked(true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.isWriteLocked());
    }

    @Test
    void isWriteLockedMustBeFalseIfBothCursorsAreNotWriteLocked() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setWriteLocked(false);
        this.second.setWriteLocked(false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.isWriteLocked());
    }

    @Test
    void isWriteLockedMustBeFalseIfFirstCursorIsNotWriteLocked() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setWriteLocked(false);
        this.second.setWriteLocked(true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.isWriteLocked());
    }

    @Test
    void isWriteLockedMustBeFalseIfSecondCursorIsNotWriteLocked() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setWriteLocked(true);
        this.second.setWriteLocked(false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.isWriteLocked());
    }
}

