/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.io.pagecache.impl.muninn.AbstractPageListTest;
import org.neo4j.io.pagecache.impl.muninn.PageList;
import org.neo4j.util.concurrent.Futures;

class MultiwriterPageListTest
extends AbstractPageListTest {
    MultiwriterPageListTest() {
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    void writeLocksMustNotBlockOtherWriteLocks(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)TIMEOUT, () -> {
            PageList.unlockExclusive((long)this.pageRef);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    void writeLocksMustNotBlockOtherWriteLocksInOtherThreads(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)TIMEOUT, () -> {
            PageList.unlockExclusive((long)this.pageRef);
            int threads = 10;
            CountDownLatch end = new CountDownLatch(threads);
            Runnable runnable = () -> {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
                end.countDown();
            };
            ArrayList futures = new ArrayList();
            for (int i = 0; i < threads; ++i) {
                futures.add(this.executor.submit(runnable));
            }
            end.await();
            Futures.getAll(futures);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    void writeLockCountOverflowMustThrow(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalMonitorStateException.class, () -> org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)TIMEOUT, () -> {
            PageList.unlockExclusive((long)this.pageRef);
            while (true) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
            }
        }));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    void concurrentWriteLocksMustFailExclusiveLocks(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned);
        PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned);
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.tryExclusiveLock((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    void unlockExclusiveAndTakeWriteLockMustAllowConcurrentWriteLocks(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)TIMEOUT, () -> {
            PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    void unlockWriteAndTryTakeFlushLockWithOverlappingWriterAndThenUnlockFlushMustNotLowerModifiedFlag(int pageId) {
        this.init(pageId);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        long stamp = PageList.unlockWriteAndTryTakeFlushLock((long)this.pageRef);
        Assertions.assertThat((long)stamp).isNotEqualTo(0L);
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        PageList.unlockFlush((long)this.pageRef, (long)stamp, (boolean)true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
    }
}

