/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import io.netty.channel.unix.DomainSocketAddress;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.neo4j.bolt.BoltServer;
import org.neo4j.bolt.protocol.common.connector.Connector;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.BoltTestConnection;
import org.neo4j.bolt.testing.client.SocketConnection;
import org.neo4j.bolt.testing.client.UnixDomainSocketConnection;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.connectors.ConnectorType;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;

class BoltIT
extends ExclusiveWebContainerTestBase {
    private TestWebContainer testWebContainer;

    BoltIT() {
    }

    @AfterEach
    void stopTheServer() {
        if (this.testWebContainer != null) {
            this.testWebContainer.shutdown();
        }
    }

    @Test
    void shouldLaunchBolt() throws Throwable {
        this.startServerWithBoltEnabled();
        ConnectorPortRegister connectorPortRegister = this.getDependency(ConnectorPortRegister.class);
        BoltIT.assertEventuallyServerResponds("localhost", connectorPortRegister.getLocalAddress(ConnectorType.BOLT).getPort());
    }

    @Test
    void shouldBeAbleToSpecifyHostAndPort() throws Throwable {
        this.startServerWithBoltEnabled();
        ConnectorPortRegister connectorPortRegister = this.getDependency(ConnectorPortRegister.class);
        BoltIT.assertEventuallyServerResponds("localhost", connectorPortRegister.getLocalAddress(ConnectorType.BOLT).getPort());
    }

    @Test
    void boltAddressShouldComeFromConnectorAdvertisedAddress() throws Throwable {
        String host = "neo4j.com";
        this.startServerWithBoltEnabled(host, 9999, "localhost", 0);
        HttpRequest request = HttpRequest.newBuilder(this.testWebContainer.getBaseUri()).GET().build();
        HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
        Map map = JsonHelper.jsonToMap((String)response.body());
        Assertions.assertThat((String)String.valueOf(map.get("bolt_direct"))).contains(new CharSequence[]{"bolt://" + host + ":9999"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldBindToMultipleAddresses() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(BoltConnector.enabled.name(), "true").withProperty(BoltConnector.encryption_level.name(), "DISABLED").withProperty(BoltConnector.advertised_address.name(), "127.0.0.1:0").withProperty(BoltConnector.listen_address.name(), "127.0.0.1:0").withProperty(BoltConnector.additional_listen_addresses.name(), "[::1]:0,127.0.0.1:0").usingDataDir(this.testDirectory.homePath().toString()).build();
        List registeredConnectors = this.testWebContainer.resolveDependency(BoltServer.class).getConnectors();
        Assertions.assertThat((List)registeredConnectors).hasSize(3);
        HashSet<SocketAddress> encounteredAddresses = new HashSet<SocketAddress>();
        for (Connector connector : registeredConnectors) {
            SocketAddress addr = connector.address();
            Assertions.assertThat(encounteredAddresses).isNotIn(encounteredAddresses);
            try (SocketConnection connection = null;){
                if (addr instanceof InetSocketAddress) {
                    InetSocketAddress socketAddress = (InetSocketAddress)addr;
                    connection = new SocketConnection(socketAddress);
                } else if (addr instanceof DomainSocketAddress) {
                    DomainSocketAddress domainSocketAddress = (DomainSocketAddress)addr;
                    connection = new UnixDomainSocketConnection(domainSocketAddress);
                } else {
                    throw new AssertionError((Object)("Encountered connector with unsupported socket address type: " + addr.getClass() + " (" + addr + ")"));
                }
                connection.connect().sendDefaultProtocolVersion();
                BoltConnectionAssertions.assertThat((BoltTestConnection)connection).negotiatesDefaultVersion();
            }
            encounteredAddresses.add(addr);
        }
    }

    private void startServerWithBoltEnabled() throws IOException {
        this.startServerWithBoltEnabled("localhost", 0, "localhost", 0);
    }

    private void startServerWithBoltEnabled(String advertisedHost, int advertisedPort, String listenHost, int listenPort) throws IOException {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(BoltConnector.enabled.name(), "true").withProperty(BoltConnector.encryption_level.name(), "DISABLED").withProperty(BoltConnector.advertised_address.name(), advertisedHost + ":" + advertisedPort).withProperty(BoltConnector.listen_address.name(), listenHost + ":" + listenPort).usingDataDir(this.testDirectory.homePath().toString()).build();
        this.testWebContainer.resolveDependency(ConnectorPortRegister.class);
    }

    private static void assertEventuallyServerResponds(String host, int port) throws Exception {
        try (SocketConnection connection = new SocketConnection(new InetSocketAddress(host, port));){
            connection.connect().sendDefaultProtocolVersion();
            BoltConnectionAssertions.assertThat((BoltTestConnection)connection).negotiatesDefaultVersion();
        }
    }

    private <T> T getDependency(Class<T> clazz) {
        return this.testWebContainer.resolveDependency(clazz);
    }
}

