/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;
import org.neo4j.test.server.InsecureTrustManager;

class HttpsTransportIT
extends ExclusiveWebContainerTestBase {
    private TestWebContainer testWebContainer;

    HttpsTransportIT() {
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    void shouldHandleHttpsVersions(HttpClient.Version httpVersion) throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().persistent().usingDataDir(this.testDirectory.directory(this.methodName).toAbsolutePath().toString()).withHttpsEnabled().withHttpDisabled().withProperty(ServerSettings.http_enabled_transports.name(), "HTTP1_1,HTTP2").build();
        SSLContext trustAllSslContext = SSLContext.getInstance("TLS");
        trustAllSslContext.init(null, new TrustManager[]{new InsecureTrustManager()}, null);
        HttpClient httpClient = HttpClient.newBuilder().version(httpVersion).sslContext(trustAllSslContext).followRedirects(HttpClient.Redirect.NORMAL).build();
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.testWebContainer.httpsUri().get().resolve(HttpsTransportIT.txCommitEndpoint()).toString())).POST(HttpRequest.BodyPublishers.noBody()).build();
        HttpResponse<String> response = httpClient.send(req, HttpResponse.BodyHandlers.ofString());
        Assertions.assertThat((int)response.statusCode()).isEqualTo(200);
        Assertions.assertThat((Comparable)((Object)response.version())).isEqualTo((Object)httpVersion);
    }

    @Test
    void shouldServeHttp11WhenHttp2Disabled() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().persistent().usingDataDir(this.testDirectory.directory(this.methodName).toAbsolutePath().toString()).withHttpsEnabled().withHttpDisabled().withProperty(ServerSettings.http_enabled_transports.name(), "HTTP1_1").build();
        SSLContext trustAllSslContext = SSLContext.getInstance("TLS");
        trustAllSslContext.init(null, new TrustManager[]{new InsecureTrustManager()}, null);
        HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).sslContext(trustAllSslContext).followRedirects(HttpClient.Redirect.NORMAL).build();
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.testWebContainer.httpsUri().get().resolve(HttpsTransportIT.txCommitEndpoint()).toString())).POST(HttpRequest.BodyPublishers.noBody()).build();
        HttpResponse<String> response = httpClient.send(req, HttpResponse.BodyHandlers.ofString());
        Assertions.assertThat((int)response.statusCode()).isEqualTo(200);
        Assertions.assertThat((Comparable)((Object)response.version())).isEqualTo((Object)HttpClient.Version.HTTP_1_1);
    }

    @Test
    void shouldFailIfNoCommonTransport() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().persistent().usingDataDir(this.testDirectory.directory(this.methodName).toAbsolutePath().toString()).withHttpsEnabled().withHttpDisabled().withProperty(ServerSettings.http_enabled_transports.name(), "HTTP2").build();
        SSLContext trustAllSslContext = SSLContext.getInstance("TLS");
        trustAllSslContext.init(null, new TrustManager[]{new InsecureTrustManager()}, null);
        HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).sslContext(trustAllSslContext).followRedirects(HttpClient.Redirect.NORMAL).build();
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.testWebContainer.httpsUri().get().resolve(HttpsTransportIT.txCommitEndpoint()).toString())).POST(HttpRequest.BodyPublishers.noBody()).build();
        org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> httpClient.send(req, HttpResponse.BodyHandlers.ofString()));
    }

    @AfterEach
    void cleanup() {
        if (this.testWebContainer != null) {
            this.testWebContainer.shutdown();
        }
    }

    private static Stream<HttpClient.Version> httpVersions() {
        return Stream.of(HttpClient.Version.HTTP_1_1, HttpClient.Version.HTTP_2);
    }
}

