/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.server;

import java.lang.reflect.Method;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SuppressOutput;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.server.WebContainerHolder;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
@ExtendWith(value={SuppressOutputExtension.class})
@ResourceLock(value="java.lang.System.out")
public class ExclusiveWebContainerTestBase {
    @Inject
    protected TestDirectory testDirectory;
    @Inject
    protected SuppressOutput suppressOutput;
    protected String methodName;

    @BeforeAll
    public static void ensureServerNotRunning() throws Exception {
        System.setProperty("org.neo4j.useInsecureCertificateGeneration", "true");
        SuppressOutput.suppressAll().call(() -> {
            WebContainerHolder.ensureNotRunning();
            return null;
        });
    }

    @BeforeEach
    public void init(TestInfo testInfo) {
        this.methodName = ((Method)testInfo.getTestMethod().get()).getName();
    }

    protected static String txEndpoint() {
        return ExclusiveWebContainerTestBase.txEndpoint("neo4j");
    }

    private static String txEndpoint(String database) {
        return String.format("db/%s/tx", database);
    }

    protected static String txCommitEndpoint() {
        return ExclusiveWebContainerTestBase.txCommitEndpoint("neo4j");
    }

    protected static String txCommitEndpoint(String database) {
        return ExclusiveWebContainerTestBase.txEndpoint(database) + "/commit";
    }
}

