/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.prefetch;

import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.layout.recordstorage.RecordDatabaseFile;
import org.neo4j.io.pagecache.prefetch.PagePrefetcher;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension(configurationCallback="configure")
class CommandPrefetchIT {
    @Inject
    GraphDatabaseService db;
    TestPrefetcher prefetcher;

    CommandPrefetchIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        this.prefetcher = new TestPrefetcher();
        builder.setExternalDependencies((DependencyResolver)Dependencies.dependenciesOf((Object)((Object)this.prefetcher)));
        builder.setConfig(GraphDatabaseInternalSettings.prefetch_on_commit, (Object)true);
    }

    @Test
    void transactionCommitSubmitsEntityFilesToPrefetcher() {
        this.prefetcher.tasks.clear();
        try (Transaction tx = this.db.beginTx();){
            tx.createNode().createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"name"));
            tx.commit();
        }
        String databaseName = this.db.databaseName();
        List<String> prefetchedFiles = this.prefetcher.tasks.stream().filter(file -> file.toString().contains(databaseName)).map(Path::getFileName).map(Path::toString).toList();
        Assertions.assertThat(prefetchedFiles).contains((Object[])new String[]{RecordDatabaseFile.NODE_STORE.getName(), RecordDatabaseFile.RELATIONSHIP_STORE.getName()});
    }

    @Test
    void transactionCommitSubmitsPropertyFilesPrefetcher() {
        this.prefetcher.tasks.clear();
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            node.setProperty("property", (Object)"property");
            node.setProperty("largeStringProperty", (Object)StringUtils.repeat((String)"X", (int)1024));
            node.setProperty("largeArrayProperty", (Object)new long[1024]);
            tx.commit();
        }
        String databaseName = this.db.databaseName();
        List<String> prefetchedFiles = this.prefetcher.tasks.stream().filter(file -> file.toString().contains(databaseName)).map(Path::getFileName).map(Path::toString).toList();
        Assertions.assertThat(prefetchedFiles).contains((Object[])new String[]{RecordDatabaseFile.PROPERTY_STORE.getName(), RecordDatabaseFile.PROPERTY_ARRAY_STORE.getName(), RecordDatabaseFile.PROPERTY_STRING_STORE.getName()});
    }

    private static class TestPrefetcher
    extends LifecycleAdapter
    implements PagePrefetcher {
        private final ConcurrentLinkedQueue<Path> tasks = new ConcurrentLinkedQueue();

        private TestPrefetcher() {
        }

        public void submit(Path path, long[] pages) {
            if (path.toString().contains("system")) {
                return;
            }
            this.tasks.offer(path);
        }
    }
}

