/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.lang.invoke.StringConcatFactory;
import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.server.CommandLineArgs;

class CommandLineArgsTest {
    CommandLineArgsTest() {
    }

    @Test
    void shouldPickUpSpecifiedConfigFile() {
        Path dir = Path.of("/some-dir", new String[0]).toAbsolutePath();
        Path expectedFile = dir.resolve("neo4j.conf");
        Assertions.assertEquals((Object)expectedFile, (Object)CommandLineArgs.parse((String[])new String[]{"--config-dir", dir.toString()}).configFile);
        Assertions.assertEquals((Object)expectedFile, (Object)CommandLineArgs.parse((String[])new String[]{StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"--config-dir=\u0001"}, (String)String.valueOf((Object)dir))}).configFile);
    }

    @Test
    void shouldResolveConfigFileRelativeToWorkingDirectory() {
        Path expectedFile = Path.of("some-dir", "neo4j.conf");
        Assertions.assertEquals((Object)expectedFile, (Object)CommandLineArgs.parse((String[])new String[]{"--config-dir", "some-dir"}).configFile);
        Assertions.assertEquals((Object)expectedFile, (Object)CommandLineArgs.parse((String[])new String[]{"--config-dir=some-dir"}).configFile);
    }

    @Test
    void shouldReturnNullIfConfigDirIsNotSpecified() {
        Assertions.assertNull((Object)CommandLineArgs.parse((String[])new String[0]).configFile);
    }

    @Test
    void shouldPickUpSpecifiedHomeDir() {
        Path homeDir = Path.of("/some/absolute/homedir", new String[0]).toAbsolutePath();
        Assertions.assertEquals((Object)homeDir, (Object)CommandLineArgs.parse((String[])new String[]{"--home-dir", homeDir.toString()}).homeDir);
        Assertions.assertEquals((Object)homeDir, (Object)CommandLineArgs.parse((String[])new String[]{StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"--home-dir=\u0001"}, (String)String.valueOf((Object)homeDir))}).homeDir);
    }

    @Test
    void shouldReturnNullIfHomeDirIsNotSpecified() {
        Assertions.assertNull((Object)CommandLineArgs.parse((String[])new String[0]).homeDir);
    }

    @Test
    void shouldPickUpOverriddenConfigurationParameters() {
        String[] args = (String[])ArrayUtil.array((Object[])new String[]{"-c", "myoption=myvalue"});
        CommandLineArgs parsed = CommandLineArgs.parse((String[])args);
        Assertions.assertEquals((Object)MapUtil.stringMap((String[])new String[]{"myoption", "myvalue"}), (Object)parsed.configOverrides);
    }

    @Test
    void shouldPickUpOverriddenBooleanConfigurationParameters() {
        String[] args = (String[])ArrayUtil.array((Object[])new String[]{"-c", "myoptionenabled"});
        CommandLineArgs parsed = CommandLineArgs.parse((String[])args);
        Assertions.assertEquals((Object)MapUtil.stringMap((String[])new String[]{"myoptionenabled", Boolean.TRUE.toString()}), (Object)parsed.configOverrides);
    }

    @Test
    void shouldPickUpMultipleOverriddenConfigurationParameters() {
        String[] args = (String[])ArrayUtil.array((Object[])new String[]{"-c", "my_first_option=first", "-c", "myoptionenabled", "-c", "my_second_option=second"});
        CommandLineArgs parsed = CommandLineArgs.parse((String[])args);
        Assertions.assertEquals((Object)MapUtil.stringMap((String[])new String[]{"my_first_option", "first", "myoptionenabled", Boolean.TRUE.toString(), "my_second_option", "second"}), (Object)parsed.configOverrides);
    }

    @Test
    void shouldPickUpExpandCommandsArgument() {
        String[] args = (String[])ArrayUtil.array((Object[])new String[]{"--expand-commands"});
        CommandLineArgs parsed = CommandLineArgs.parse((String[])args);
        Assertions.assertTrue((boolean)parsed.expandCommands);
    }

    @Test
    void expandCommandsShouldBeDisabledByDefault() {
        String[] args = (String[])ArrayUtil.array((Object[])new String[]{"--console-mode"});
        CommandLineArgs parsed = CommandLineArgs.parse((String[])args);
        Assertions.assertFalse((boolean)parsed.expandCommands);
        Assertions.assertTrue((boolean)parsed.consoleMode);
    }
}

