/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.log4j.LogUtils;
import org.neo4j.logging.log4j.LoggerTarget;
import org.neo4j.server.AbstractNeoWebServer;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;

class HttpStructuredLoggingIT
extends ExclusiveWebContainerTestBase {
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.NORMAL).build();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<Map<String, String>> MAP_TYPE = new TypeReference<Map<String, String>>(){};

    HttpStructuredLoggingIT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldLogRequestsInStructuredFormat() throws Exception {
        HttpResponse<String> response;
        this.testDirectory.directory("logs");
        Path log4jConfig = this.testDirectory.file("logs/testHttp.xml");
        Path httpLogPath = this.testDirectory.file("logs/http.log");
        LogUtils.newXmlConfigBuilder((FileSystemAbstraction)this.testDirectory.getFileSystem(), (Path)log4jConfig).withLogger(LogUtils.newLoggerBuilder((LoggerTarget)LoggerTarget.HTTP_LOGGER, (Path)httpLogPath).withJsonFormatTemplate("classpath:org/neo4j/logging/StructuredLayoutWithMessage.json").build()).create();
        CommunityBootstrapper bootstrapper = new CommunityBootstrapper();
        try {
            int start = bootstrapper.start(this.testDirectory.homePath(), Map.of(HttpConnector.listen_address.name(), "localhost:0", HttpConnector.advertised_address.name(), "localhost:0", ServerSettings.http_logging_enabled.name(), "true", HttpConnector.enabled.name(), "true", BoltConnector.enabled.name(), "false", GraphDatabaseSettings.server_logging_config_path.name(), log4jConfig.toString()));
            Assertions.assertThat((int)start).isEqualTo(0);
            DependencyResolver dependencyResolver = HttpStructuredLoggingIT.getDependencyResolver(bootstrapper.getDatabaseManagementService());
            URI baseUri = ((AbstractNeoWebServer)dependencyResolver.resolveDependency(AbstractNeoWebServer.class)).getBaseUri();
            Config config = (Config)dependencyResolver.resolveDependency(Config.class);
            HttpRequest request = HttpRequest.newBuilder().uri(baseUri).timeout(Duration.ofSeconds(10L)).header("Accept", "application/json").header("User-Agent", HttpStructuredLoggingIT.class.getSimpleName()).GET().build();
            response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
        }
        finally {
            bootstrapper.stop();
            LogManager.shutdown();
        }
        Assertions.assertThat((int)response.statusCode()).isEqualTo(200);
        List<String> strings = Files.readAllLines(httpLogPath);
        List httpLogLines = strings.stream().map(s -> {
            try {
                return (Map)OBJECT_MAPPER.readValue(s, MAP_TYPE);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        Assertions.assertThat(httpLogLines).anyMatch(logEntry -> logEntry.getOrDefault("message", "").contains(HttpStructuredLoggingIT.class.getSimpleName()));
    }

    private static DependencyResolver getDependencyResolver(DatabaseManagementService managementService) {
        return ((GraphDatabaseAPI)managementService.database("neo4j")).getDependencyResolver();
    }
}

