/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storemigration;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Function;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.dbms.LoadCommand;
import org.neo4j.commandline.dbms.StoreInfoCommand;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.ZippedStoreCommunity;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import picocli.CommandLine;

@Neo4jLayoutExtension
class AdminCommandsWith44StoreIT {
    @Inject
    private Neo4jLayout neo4jLayout;
    @Inject
    private FileSystemAbstraction fileSystemAbstraction;

    AdminCommandsWith44StoreIT() {
    }

    @Test
    void testStoreInfo() throws IOException {
        Path homeDir = this.neo4jLayout.homeDirectory();
        ZippedStoreCommunity.AF430_V44_ALL.unzip(homeDir);
        Result result = this.runCommandFromSameJvm(StoreInfoCommand::new, "neo4j");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)result.exitCode());
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)result.out).contains(new CharSequence[]{"Database name:                neo4j"})).contains(new CharSequence[]{"Database in use:              false"})).contains(new CharSequence[]{"Store format version:         record-aligned-0.1"})).contains(new CharSequence[]{"Store format introduced in:   4.3.0"})).contains(new CharSequence[]{"Store format superseded in:   5.0.0"})).contains(new CharSequence[]{"Store needs recovery:         false"});
    }

    @Test
    void testLod() throws IOException {
        InputStream source = this.getClass().getResourceAsStream("neo4j-44.dump");
        Path dumpFile = this.neo4jLayout.homeDirectory().resolve("test-db.dump");
        Files.copy(source, dumpFile, new CopyOption[0]);
        Result result = this.runCommandFromSameJvm(LoadCommand::new, "test-db", "--from-path", this.neo4jLayout.homeDirectory().toString());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)result.exitCode());
    }

    private Result runCommandFromSameJvm(Function<ExecutionContext, AbstractCommand> commandFactory, String ... args) {
        Path homeDir = this.neo4jLayout.homeDirectory().toAbsolutePath();
        Path configDir = homeDir.resolve("conf");
        Output out = new Output();
        Output err = new Output();
        ExecutionContext ctx = new ExecutionContext(homeDir, configDir, out.printStream, err.printStream, this.fileSystemAbstraction);
        AbstractCommand command = (AbstractCommand)CommandLine.populateCommand((Object)commandFactory.apply(ctx), (String[])args);
        try {
            int exitCode = command.call();
            return new Result(exitCode, out.toString(), err.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private record Result(int exitCode, String out, String err) {
    }

    private static class Output {
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        private final PrintStream printStream = new PrintStream(this.buffer);

        private Output() {
        }

        public String toString() {
            return this.buffer.toString(StandardCharsets.UTF_8);
        }
    }
}

