/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing.linear;

import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFileSwapperTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.linear.HEvents;
import org.neo4j.io.pagecache.tracing.linear.LinearHistoryPageCursorTracer;
import org.neo4j.io.pagecache.tracing.linear.LinearHistoryTracer;

public final class LinearHistoryPageCacheTracer
implements PageCacheTracer {
    private final LinearHistoryTracer tracer;

    LinearHistoryPageCacheTracer(LinearHistoryTracer tracer) {
        this.tracer = tracer;
    }

    public PageFileSwapperTracer createFileSwapperTracer() {
        return PageFileSwapperTracer.NULL;
    }

    public PageCursorTracer createPageCursorTracer(String tag) {
        return new LinearHistoryPageCursorTracer(this.tracer, tag);
    }

    public void mappedFile(int swapperId, PagedFile pagedFile) {
        this.tracer.add(new HEvents.MappedFileHEvent(pagedFile.path()));
    }

    public void unmappedFile(int swapperId, PagedFile pagedFile) {
        this.tracer.add(new HEvents.UnmappedFileHEvent(pagedFile.path()));
    }

    public EvictionRunEvent beginPageEvictions(int pageCountToEvict) {
        return this.tracer.add(new HEvents.EvictionRunHEvent(this.tracer, pageCountToEvict));
    }

    public EvictionRunEvent beginEviction() {
        return this.tracer.add(new HEvents.EvictionRunHEvent(this.tracer, 0));
    }

    public FileFlushEvent beginFileFlush(PageSwapper swapper) {
        return this.tracer.add(new HEvents.FileFlushHEvent(this.tracer, swapper.path()));
    }

    public FileFlushEvent beginFileFlush() {
        return this.tracer.add(new HEvents.FileFlushHEvent(this.tracer, null));
    }

    public DatabaseFlushEvent beginDatabaseFlush() {
        return DatabaseFlushEvent.NULL;
    }

    public long faults() {
        return 0L;
    }

    public long failedFaults() {
        return 0L;
    }

    public long noFaults() {
        return 0L;
    }

    public long vectoredFaults() {
        return 0L;
    }

    public long failedVectoredFaults() {
        return 0L;
    }

    public long noPinFaults() {
        return 0L;
    }

    public long evictions() {
        return 0L;
    }

    public long cooperativeEvictions() {
        return 0L;
    }

    public long pins() {
        return 0L;
    }

    public long unpins() {
        return 0L;
    }

    public long hits() {
        return 0L;
    }

    public long flushes() {
        return 0L;
    }

    public long evictionFlushes() {
        return 0L;
    }

    public long cooperativeEvictionFlushes() {
        return 0L;
    }

    public long merges() {
        return 0L;
    }

    public long bytesRead() {
        return 0L;
    }

    public long bytesWritten() {
        return 0L;
    }

    public long bytesTruncated() {
        return 0L;
    }

    public long filesMapped() {
        return 0L;
    }

    public long filesUnmapped() {
        return 0L;
    }

    public long filesTruncated() {
        return 0L;
    }

    public long evictionExceptions() {
        return 0L;
    }

    public double hitRatio() {
        return 0.0;
    }

    public long maxPages() {
        return 0L;
    }

    public long iopqPerformed() {
        return 0L;
    }

    public long ioLimitedTimes() {
        return 0L;
    }

    public long ioLimitedMillis() {
        return 0L;
    }

    public long openedCursors() {
        return 0L;
    }

    public long closedCursors() {
        return 0L;
    }

    public long copiedPages() {
        return 0L;
    }

    public long snapshotsLoaded() {
        return 0L;
    }

    public void pins(long pins) {
    }

    public void unpins(long unpins) {
    }

    public void hits(long hits) {
    }

    public void faults(long faults) {
    }

    public void noFaults(long noFaults) {
    }

    public void failedFaults(long failedFaults) {
    }

    public void vectoredFaults(long faults) {
    }

    public void failedVectoredFaults(long failedFaults) {
    }

    public void noPinFaults(long faults) {
    }

    public void bytesRead(long bytesRead) {
    }

    public void evictions(long evictions) {
    }

    public void cooperativeEvictions(long evictions) {
    }

    public void cooperativeEvictionFlushes(long evictionFlushes) {
    }

    public void evictionExceptions(long evictionExceptions) {
    }

    public void bytesWritten(long bytesWritten) {
    }

    public void flushes(long flushes) {
    }

    public void merges(long merges) {
    }

    public void snapshotsLoaded(long snapshotsLoaded) {
    }

    public void maxPages(long maxPages, long pageSize) {
    }

    public void iopq(long iopq) {
    }

    public void limitIO(long millis) {
    }

    public void pagesCopied(long copiesCreated) {
    }

    public void filesTruncated(long truncatedFiles) {
    }

    public void bytesTruncated(long bytesTruncated) {
    }

    public void openedCursors(long openedCursors) {
    }

    public void closedCursors(long closedCursors) {
    }

    public void failedUnmap(String reason) {
    }
}

