/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseExistsException;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.event.DatabaseEventContext;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.event.DatabaseEventListenerAdapter;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Panic;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
public class DatabasePanicIT {
    @Inject
    private TestDirectory testDirectory;
    private DatabaseManagementService managementService;

    @BeforeEach
    void setUp() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).build();
    }

    @AfterEach
    void tearDown() {
        this.managementService.shutdown();
    }

    @Test
    void databasePanicNotification() throws DatabaseExistsException {
        PanicDatabaseEventListener panicListener = new PanicDatabaseEventListener("neo4j");
        this.managementService.registerDatabaseEventListener((DatabaseEventListener)panicListener);
        Assertions.assertFalse((boolean)panicListener.isPanic());
        DatabasePanicIT.getDatabaseHealth(this.managementService.database("neo4j")).panic((Throwable)new IllegalStateException("Whoops, something went wrong here."));
        Assertions.assertTrue((boolean)panicListener.isPanic());
        this.assertShowDatabases();
    }

    private void assertShowDatabases() {
        Assert.assertEventually(() -> (DatabaseStatus)this.managementService.database("system").executeTransactionally("SHOW DATABASE neo4j", Map.of(), rawResult -> {
            List resultRows = Iterators.asList((Iterator)rawResult);
            Assertions.assertEquals((int)1, (int)resultRows.size());
            Map resultRow = (Map)resultRows.get(0);
            return new DatabaseStatus((String)resultRow.get("currentStatus"), (String)resultRow.get("statusMessage"));
        }), databaseStatus -> databaseStatus.currentStatus().equals("online") && databaseStatus.statusMessage().equals("Whoops, something went wrong here."), (long)30L, (TimeUnit)TimeUnit.SECONDS);
    }

    private static Panic getDatabaseHealth(GraphDatabaseService service) {
        return (Panic)((GraphDatabaseAPI)service).getDependencyResolver().resolveDependency(DatabaseHealth.class);
    }

    private static class PanicDatabaseEventListener
    extends DatabaseEventListenerAdapter {
        private final String databaseName;
        private boolean panic;

        PanicDatabaseEventListener(String databaseName) {
            this.databaseName = databaseName;
        }

        public void databasePanic(DatabaseEventContext eventContext) {
            if (this.databaseName.equals(eventContext.getDatabaseName())) {
                this.panic = true;
            }
        }

        boolean isPanic() {
            return this.panic;
        }
    }

    private record DatabaseStatus(String currentStatus, String statusMessage) {
    }
}

