/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.kernel.impl.store.format.aligned.PageAligned;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
public class UnsupportedFormatIT {
    @Inject
    private TestDirectory testDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(strings={"block", "high_limit"})
    void startDbmsOnEnterpriseFormatInCommunityShouldNotFailDbmsStartup(String enterpriseFormat) {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).setConfig(GraphDatabaseSettings.db_format, (Object)enterpriseFormat).build();
        try {
            GraphDatabaseAPI system = (GraphDatabaseAPI)managementService.database("system");
            Assertions.assertThat((boolean)system.isAvailable()).isTrue();
            MetadataProvider metadataProvider = (MetadataProvider)system.getDependencyResolver().resolveDependency(MetadataProvider.class);
            Assertions.assertThat((String)metadataProvider.getStoreId().getFormatName()).isEqualTo(PageAligned.LATEST_NAME);
        }
        finally {
            managementService.shutdown();
        }
    }
}

