/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.exceptions.UnsatisfiedDependencyException;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;

public class HttpTransportIT
extends ExclusiveWebContainerTestBase {
    @Test
    public void shouldFailToStartIfNoTransportConfigured() {
        Assertions.assertThatExceptionOfType(UnsatisfiedDependencyException.class).isThrownBy(() -> CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(ServerSettings.http_enabled_transports.name(), "").build());
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    void shouldHandleHttpVersions(HttpClient.Version httpVersion) throws Exception {
        TestWebContainer testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().persistent().usingDataDir(this.testDirectory.directory(this.methodName).toAbsolutePath().toString()).withProperty(ServerSettings.http_enabled_transports.name(), "HTTP1_1,HTTP2").build();
        HttpClient httpClient = HttpClient.newBuilder().version(httpVersion).followRedirects(HttpClient.Redirect.NORMAL).build();
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(testWebContainer.getBaseUri().toString() + HttpTransportIT.txEndpoint())).POST(HttpRequest.BodyPublishers.noBody()).build();
        HttpResponse<Void> response = httpClient.send(req, HttpResponse.BodyHandlers.discarding());
        Assertions.assertThat((int)response.statusCode()).isEqualTo(201);
        Assertions.assertThat((Comparable)((Object)response.version())).isEqualTo((Object)httpVersion);
        testWebContainer.shutdown();
    }

    @Test
    public void shouldServeHttp11WhenHttp2Disabled() throws Exception {
        TestWebContainer testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().persistent().usingDataDir(this.testDirectory.directory(this.methodName).toAbsolutePath().toString()).withProperty(ServerSettings.http_enabled_transports.name(), "HTTP1_1").build();
        HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).build();
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(testWebContainer.getBaseUri().toString())).GET().build();
        HttpResponse<String> response = httpClient.send(req, HttpResponse.BodyHandlers.ofString());
        Assertions.assertThat((int)response.statusCode()).isEqualTo(200);
        Assertions.assertThat((Comparable)((Object)response.version())).isEqualTo((Object)HttpClient.Version.HTTP_1_1);
        testWebContainer.shutdown();
    }

    @Test
    public void shouldFailIfNoCommonTransport() throws Exception {
        TestWebContainer testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().persistent().usingDataDir(this.testDirectory.directory(this.methodName).toAbsolutePath().toString()).withProperty(ServerSettings.http_enabled_transports.name(), "HTTP2").build();
        HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.NORMAL).build();
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(testWebContainer.getBaseUri().toString())).GET().build();
        org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> httpClient.send(req, HttpResponse.BodyHandlers.ofString()));
        testWebContainer.shutdown();
    }

    private static Stream<HttpClient.Version> httpVersions() {
        return Stream.of(HttpClient.Version.HTTP_1_1, HttpClient.Version.HTTP_2);
    }
}

