/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import java.net.URI;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.HTTP;

class JoltV1ResultFormatIT
extends AbstractRestFunctionalTestBase {
    private final HTTP.Builder http = HTTP.withBaseUri((URI)JoltV1ResultFormatIT.container().getBaseUri()).withHeaders(new String[]{"Accept", "application/vnd.neo4j.jolt"});
    private String commitResource;

    JoltV1ResultFormatIT() {
    }

    private static Stream<String> lineDelimitedMimeTypes() {
        return Stream.of("application/vnd.neo4j.jolt", "application/vnd.neo4j.jolt-v1");
    }

    private static Stream<String> sequentialMimeTypes() {
        return Stream.of("application/vnd.neo4j.jolt+json-seq", "application/vnd.neo4j.jolt-v1+json-seq");
    }

    @BeforeEach
    void setUp() {
        HTTP.Response begin = this.http.POST(JoltV1ResultFormatIT.txUri());
        Assertions.assertThat((int)begin.status()).isEqualTo(201);
        JoltV1ResultFormatIT.assertHasTxLocation(begin);
        try {
            this.commitResource = begin.get("info").get("commit").asText();
        }
        catch (JsonParseException e) {
            org.junit.jupiter.api.Assertions.fail((String)("Exception caught when setting up test: " + e.getMessage()));
        }
        Assertions.assertThat((String)this.commitResource).isEqualTo(begin.location() + "/commit");
    }

    @ParameterizedTest
    @CsvSource(value={"true", "TRUE"})
    void shouldReturnJoltInStrictFormat(String booleanString) {
        String cacheBuster = ";cacheBuster=" + ThreadLocalRandom.current().nextLong();
        HTTP.Response response = this.http.withHeaders(new String[]{"Accept", "application/vnd.neo4j.jolt;strict=" + booleanString + cacheBuster}).POST(this.commitResource, JoltV1ResultFormatIT.queryAsJsonRow("RETURN 1, 5.5, true"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        JoltV1ResultFormatIT.splitAndVerify(response.rawContent(), "\n", "{\"header\":{\"fields\":[\"1\",\"5.5\",\"true\"]}}", "{\"data\":[{\"Z\":\"1\"},{\"R\":\"5.5\"},{\"?\":\"true\"}]}", "{\"summary\":{}}", "{\"info\":{" + JoltV1ResultFormatIT.lineDeprecationNotification() + ",\"commit\":\"" + this.commitResource + "\",\"lastBookmarks\":[");
    }

    @ParameterizedTest
    @CsvSource(value={"true", "TRUE"})
    void shouldReturnJoltInStrictRecordSeparatedFormat(String booleanString) {
        String cacheBuster = ";cacheBuster=" + ThreadLocalRandom.current().nextLong();
        HTTP.Response response = this.http.withHeaders(new String[]{"Accept", "application/vnd.neo4j.jolt+json-seq;strict=" + booleanString + cacheBuster}).POST(this.commitResource, JoltV1ResultFormatIT.queryAsJsonRow("RETURN 1, 5.5, true"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        JoltV1ResultFormatIT.splitAndVerify(response.rawContent(), "\u001e", "", "{\"header\":{\"fields\":[\"1\",\"5.5\",\"true\"]}}\n", "{\"data\":[{\"Z\":\"1\"},{\"R\":\"5.5\"},{\"?\":\"true\"}]}\n", "{\"summary\":{}}\n", "{\"info\":{" + JoltV1ResultFormatIT.seqDeprecationNotification() + ",\"commit\":\"" + this.commitResource + "\",\"lastBookmarks\":[");
    }

    @ParameterizedTest
    @MethodSource(value={"lineDelimitedMimeTypes"})
    void shouldReturnJoltInSparseFormat(String mimeType) {
        HTTP.Response response = this.http.withHeaders(new String[]{"Accept", mimeType}).POST(this.commitResource, JoltV1ResultFormatIT.queryAsJsonRow("RETURN 1, 5.5, true"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        JoltV1ResultFormatIT.splitAndVerify(response.rawContent(), "\n", "{\"header\":{\"fields\":[\"1\",\"5.5\",\"true\"]}}", "{\"data\":[1,{\"R\":\"5.5\"},true]}", "{\"summary\":{}}", "{\"info\":{" + JoltV1ResultFormatIT.lineDeprecationNotification() + ",\"commit\":\"" + this.commitResource + "\",\"lastBookmarks\":[");
    }

    @ParameterizedTest
    @MethodSource(value={"sequentialMimeTypes"})
    void shouldReturnJoltInRecordSeparatedFormat(String mimeTypes) {
        HTTP.Response response = this.http.withHeaders(new String[]{"Accept", mimeTypes}).POST(this.commitResource, JoltV1ResultFormatIT.queryAsJsonRow("RETURN 1, 5.5, true"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        JoltV1ResultFormatIT.splitAndVerify(response.rawContent(), "\u001e", "", "{\"header\":{\"fields\":[\"1\",\"5.5\",\"true\"]}}\n", "{\"data\":[1,{\"R\":\"5.5\"},true]}\n", "{\"summary\":{}}\n", "{\"info\":{" + JoltV1ResultFormatIT.seqDeprecationNotification() + ",\"commit\":\"" + this.commitResource + "\",\"lastBookmarks\":");
    }

    private static HTTP.RawPayload queryAsJsonRow(String query) {
        return HTTP.RawPayload.quotedJson((String)("{ 'statements': [ { 'statement': '" + query + "' } ] }"));
    }

    private static String seqDeprecationNotification() {
        return "\"notifications\":[{\"code\":\"Neo.ClientNotification.Request.DeprecatedFormat\",\"severity\":\"WARNING\",\"title\":\"The client made a request for a format which has been deprecated.\",\"description\":\"The requested format has been deprecated. ('application/vnd.neo4j.jolt+json-seq' and 'application/vnd.neo4j.jolt-v1+json-seq' have been deprecated and will be removed in a future version. Please use 'application/vnd.neo4j.jolt-v2+json-seq'.)\"}]";
    }

    private static String lineDeprecationNotification() {
        return "\"notifications\":[{\"code\":\"Neo.ClientNotification.Request.DeprecatedFormat\",\"severity\":\"WARNING\",\"title\":\"The client made a request for a format which has been deprecated.\",\"description\":\"The requested format has been deprecated. ('application/vnd.neo4j.jolt' and 'application/vnd.neo4j.jolt-v1' have been deprecated and will be removed in a future version. Please use 'application/vnd.neo4j.jolt-v2'.)\"}]";
    }

    public static void splitAndVerify(String input, String separator, String ... expectedOutput) {
        String[] splitContent = input.split(separator);
        for (int i = 0; i < expectedOutput.length - 1; ++i) {
            Assertions.assertThat((String)splitContent[i]).isEqualTo(expectedOutput[i]);
        }
        Assertions.assertThat((String)splitContent[expectedOutput.length - 1]).startsWith((CharSequence)expectedOutput[expectedOutput.length - 1]);
    }
}

