/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.SplittableRandom;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.Sets;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;

@PageCacheExtension
class PageCachePrefetchingTest {
    @Inject
    TestDirectory dir;
    @Inject
    FileSystemAbstraction fs;
    @Inject
    PageCache pageCache;
    private Path file;
    private CursorContext cursorContext;
    private Consumer<PageCursor> scanner;

    PageCachePrefetchingTest() {
    }

    @BeforeEach
    void setUp() {
        this.file = this.dir.createFile("file");
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        CursorContextFactory cursorContextFactory = new CursorContextFactory((PageCacheTracer)pageCacheTracer, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER);
        this.cursorContext = cursorContextFactory.create("test");
    }

    @Test
    void scanningWithPreFetcherMustGiveScannerFewerPageFaultsWhenScannerIsFast() throws Exception {
        this.scanner = cursor -> cursor.putBytes(8192, (byte)-89);
        this.runScan(this.file, this.cursorContext, "Warmup", 8);
        long faultsWithPreFetch = this.runScan(this.file, this.cursorContext, "Scanner With Prefetch", 8);
        long faultsWithoutPreFetch = this.runScan(this.file, this.cursorContext, "Scanner Without Prefetch", 0);
        ((AbstractLongAssert)Assertions.assertThat((long)faultsWithPreFetch).as("faults", new Object[0])).isLessThan(faultsWithoutPreFetch);
    }

    @Test
    void scanningWithPreFetchMustGiveScannerFewerPageFaultsWhenScannerIsSlow() throws Exception {
        RecordFormat format = RecordFormatSelector.defaultFormat().relationship();
        RelationshipRecord record = (RelationshipRecord)format.newRecord();
        int recordSize = format.getRecordSize((StoreHeader)NoStoreHeader.NO_STORE_HEADER);
        int recordsPerPage = 8192 / recordSize;
        SplittableRandom rng = new SplittableRandom(13L);
        this.scanner = cursor -> {
            for (int j = 0; j < recordsPerPage; ++j) {
                try {
                    record.initialize(rng.nextBoolean(), (long)rng.nextInt(), (long)rng.nextInt(), (long)rng.nextInt(), rng.nextInt() & 0xFFFF, (long)rng.nextInt(), (long)rng.nextInt(), (long)rng.nextInt(), (long)rng.nextInt(), rng.nextBoolean(), rng.nextBoolean());
                    format.write((AbstractBaseRecord)record, cursor, recordSize, recordsPerPage);
                    continue;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        this.runScan(this.file, this.cursorContext, "Warmup", 8);
        long faultsWithPreFetch = this.runScan(this.file, this.cursorContext, "Scanner With Prefetch", 8);
        long faultsWithoutPreFetch = this.runScan(this.file, this.cursorContext, "Scanner Without Prefetch", 0);
        ((AbstractLongAssert)Assertions.assertThat((long)faultsWithPreFetch).as("faults", new Object[0])).isLessThan(faultsWithoutPreFetch);
    }

    private long runScan(Path file, CursorContext cursorContext, String threadName, int additionalPfFlags) throws InterruptedException {
        RunnerThread thread = new RunnerThread(threadName);
        thread.additionalPfFlags = additionalPfFlags;
        thread.file = file;
        thread.cursorContext = cursorContext;
        thread.start();
        thread.join();
        long faultsWith = thread.faults;
        return faultsWith;
    }

    private void writeToFile(Path file, CursorContext cursorContext, int additionalPfFlags) throws IOException {
        try (PagedFile pagedFile = this.pageCache.map(file, 8192, "neo4j", Sets.immutable.of((Object)StandardOpenOption.CREATE, (Object)StandardOpenOption.READ, (Object)StandardOpenOption.WRITE));){
            for (int i = 0; i < 5; ++i) {
                this.writeToFile(pagedFile, cursorContext, additionalPfFlags);
            }
        }
    }

    private void writeToFile(PagedFile pagedFile, CursorContext cursorContext, int additionalPfFlags) throws IOException {
        try (PageCursor cursor = pagedFile.io(0L, 2 | additionalPfFlags, cursorContext);){
            for (int i = 0; i < 6000; ++i) {
                cursor.next();
                this.scanner.accept(cursor);
            }
        }
    }

    private class RunnerThread
    extends Thread {
        private int additionalPfFlags;
        private Path file;
        private CursorContext cursorContext;
        private long faults;

        RunnerThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            try {
                this.cursorContext.getCursorTracer().reportEvents();
                PageCachePrefetchingTest.this.writeToFile(this.file, this.cursorContext, this.additionalPfFlags);
                this.faults = this.cursorContext.getCursorTracer().faults();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

