/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.Test;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCacheTest;

public class MuninnPageCacheWithReserveBytesTest
extends MuninnPageCacheTest {
    private static final ImmutableSet<OpenOption> TEST_OPEN_OPTIONS = Sets.immutable.of((Object)PageCacheOpenOptions.MULTI_VERSIONED);

    @Override
    protected ImmutableSet<OpenOption> getOpenOptions() {
        return TEST_OPEN_OPTIONS;
    }

    @Override
    protected boolean isMultiVersioned() {
        return true;
    }

    @Test
    void allowOpeningMultipleReadAndLinkedWriteCursorsPerThread() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            Path fileA = this.existingFile("a");
            Path fileB = this.existingFile("b");
            this.generateFileWithRecords(fileA, 1, 16, this.recordsPerFilePage, this.reservedBytes, this.filePageSize);
            this.generateFileWithRecords(fileB, 1, 16, this.recordsPerFilePage, this.reservedBytes, this.filePageSize);
            try (PagedFile pfA = this.map(fileA, this.filePageSize);
                 PagedFile pfB = this.map(fileB, this.filePageSize);
                 PageCursor a = pfA.io(0L, 1, CursorContext.NULL_CONTEXT);
                 PageCursor b = pfA.io(0L, 1, CursorContext.NULL_CONTEXT);
                 PageCursor writerMain = pfA.io(0L, 2, CursorContext.NULL_CONTEXT);
                 PageCursor writerLinked1 = writerMain.openLinkedCursor(0L);
                 PageCursor writerLinked2 = writerLinked1.openLinkedCursor(0L);
                 PageCursor e = pfB.io(0L, 1, CursorContext.NULL_CONTEXT);
                 PageCursor f = pfB.io(0L, 1, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)a.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)b.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writerMain.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writerLinked1.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writerLinked2.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)e.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)f.next());
                AtomicBoolean anotherWriterLockedPage = new AtomicBoolean();
                Future<?> anotherThreadWriter = executor.submit(() -> {
                    try (PageCursor lockerWriter = pfA.io(0L, 2, CursorContext.NULL_CONTEXT);){
                        lockerWriter.next();
                        anotherWriterLockedPage.set(true);
                    }
                    catch (IOException e1) {
                        throw new UncheckedIOException(e1);
                    }
                });
                TimeUnit.MILLISECONDS.sleep(ThreadLocalRandom.current().nextInt(1000));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)anotherWriterLockedPage.get());
                writerMain.close();
                anotherThreadWriter.get();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)anotherWriterLockedPage.get());
            }
        });
    }

    @Test
    void eagerFlushMustWriteToFileOnUnpinWithLinkedCursors() throws Exception {
        this.configureStandardPageCache();
        Path file = this.file("a");
        try (PagedFile pf = this.map(file, this.filePageSize);
             PageCursor cursor = pf.io(0L, 66, CursorContext.NULL_CONTEXT);
             PageCursor linked = cursor.openLinkedCursor(0L);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)linked.next());
            this.writeRecords(cursor);
            cursor.unpin();
            Assertions.assertThatThrownBy(() -> this.verifyRecordsInFile(file, this.recordsPerFilePage)).isInstanceOf(AssertionError.class);
            linked.unpin();
            this.verifyRecordsInFile(file, this.recordsPerFilePage);
        }
    }
}

