/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.DummyPageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFileSwapperTracer;
import org.neo4j.io.pagecache.tracing.PageReferenceTranslator;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.io.pagecache.tracing.PinPageFaultEvent;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

class DefaultPageFileTracerTest {
    private PageCacheTracer pageCacheTracer;
    private DummyPageSwapper swapper;
    private PageFileSwapperTracer swapperTracer;

    DefaultPageFileTracerTest() {
    }

    @BeforeEach
    public void setUp() {
        this.pageCacheTracer = new DefaultPageCacheTracer(true);
        this.swapperTracer = this.pageCacheTracer.createFileSwapperTracer();
        this.swapper = new DummyPageSwapper("filename", (int)ByteUnit.kibiBytes((long)8L), this.swapperTracer);
    }

    @Test
    void pageCursorEventReportPinUnpinEventsToFileTracer() {
        PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer("pageCursorEventReportPinUnpinEventsToFileTracer");
        cursorTracer.beginPin(false, 1L, (PageSwapper)this.swapper).close();
        cursorTracer.unpin(1L, (PageSwapper)this.swapper);
        Assertions.assertEquals((long)1L, (long)this.swapperTracer.pins());
        Assertions.assertEquals((long)0L, (long)this.swapperTracer.hits());
        Assertions.assertEquals((long)1L, (long)this.swapperTracer.unpins());
    }

    @Test
    void pageCursorEventReportPinUnpinHitEventsToFileTracer() {
        PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer("pageCursorEventReportPinUnpinHitEventsToFileTracer");
        try (PinEvent pinEvent = cursorTracer.beginPin(false, 1L, (PageSwapper)this.swapper);){
            pinEvent.hit();
        }
        cursorTracer.unpin(1L, (PageSwapper)this.swapper);
        Assertions.assertEquals((long)1L, (long)this.swapperTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.swapperTracer.hits());
        Assertions.assertEquals((long)1L, (long)this.swapperTracer.unpins());
    }

    @Test
    void pageCursorEventReportPageFaultAndBytesReadEventsToFileTracer() {
        PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer("pageCursorEventReportPageFaultAndBytesReadEventsToFileTracer");
        try (PinEvent pinEvent = cursorTracer.beginPin(false, 1L, (PageSwapper)this.swapper);
             PinPageFaultEvent pageFaultEvent = pinEvent.beginPageFault(1L, (PageSwapper)this.swapper);){
            pageFaultEvent.addBytesRead(123L);
        }
        cursorTracer.unpin(1L, (PageSwapper)this.swapper);
        Assertions.assertEquals((long)1L, (long)this.swapperTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.swapperTracer.unpins());
        Assertions.assertEquals((long)1L, (long)this.swapperTracer.faults());
        Assertions.assertEquals((long)123L, (long)this.swapperTracer.bytesRead());
    }

    @Test
    void pageCursorEventReportEvictionExceptionEventsToFileTracer() {
        PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer("pageCursorEventReportEvictionExceptionEventsToFileTracer");
        try (PinEvent pinEvent = cursorTracer.beginPin(false, 1L, (PageSwapper)this.swapper);
             PinPageFaultEvent pageFaultEvent = pinEvent.beginPageFault(1L, (PageSwapper)this.swapper);
             EvictionEvent evictionEvent = pageFaultEvent.beginEviction(2L);){
            evictionEvent.setSwapper((PageSwapper)this.swapper);
            evictionEvent.setException(new IOException());
        }
        cursorTracer.unpin(1L, (PageSwapper)this.swapper);
        Assertions.assertEquals((long)1L, (long)this.swapperTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.swapperTracer.unpins());
        Assertions.assertEquals((long)1L, (long)this.swapperTracer.faults());
        Assertions.assertEquals((long)1L, (long)this.swapperTracer.evictionExceptions());
    }

    @Test
    void pageCursorEventReportEvictionEventsToFileTracer() {
        PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer("pageCursorEventReportEvictionEventsToFileTracer");
        try (PinEvent pinEvent = cursorTracer.beginPin(false, 1L, (PageSwapper)this.swapper);
             PinPageFaultEvent pageFaultEvent = pinEvent.beginPageFault(1L, (PageSwapper)this.swapper);
             EvictionEvent evictionEvent = pageFaultEvent.beginEviction(2L);){
            evictionEvent.setSwapper((PageSwapper)this.swapper);
            FlushEvent flushEvent = evictionEvent.beginFlush(1L, (PageSwapper)this.swapper, (PageReferenceTranslator)Mockito.mock(PageReferenceTranslator.class));
            flushEvent.addPagesMerged(11);
            flushEvent.addPagesFlushed(22);
            flushEvent.addBytesWritten(33L);
        }
        cursorTracer.unpin(1L, (PageSwapper)this.swapper);
        Assertions.assertEquals((long)1L, (long)this.swapperTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.swapperTracer.unpins());
        Assertions.assertEquals((long)1L, (long)this.swapperTracer.faults());
        Assertions.assertEquals((long)1L, (long)this.swapperTracer.evictions());
        Assertions.assertEquals((long)11L, (long)this.swapperTracer.merges());
        Assertions.assertEquals((long)22L, (long)this.swapperTracer.flushes());
        Assertions.assertEquals((long)33L, (long)this.swapperTracer.bytesWritten());
        Assertions.assertEquals((long)0L, (long)this.swapperTracer.evictionExceptions());
    }
}

