/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.server.NeoWebServer;
import org.neo4j.server.http.cypher.TransactionRegistry;

public class TestWebContainer {
    private final DatabaseManagementService managementService;
    private final NeoWebServer neoWebServer;
    private final InternalLogProvider logProvider;

    public TestWebContainer(DatabaseManagementService managementService, InternalLogProvider logProvider) {
        Objects.requireNonNull(managementService);
        this.managementService = managementService;
        this.neoWebServer = TestWebContainer.getNeoWebServer(managementService);
        this.logProvider = logProvider;
    }

    public URI getBaseUri() {
        return this.neoWebServer.getBaseUri();
    }

    public Optional<URI> httpsUri() {
        return this.neoWebServer.httpsUri();
    }

    public void shutdown() {
        this.managementService.shutdown();
        this.logProvider.close();
    }

    public DatabaseManagementService getDatabaseManagementService() {
        return this.managementService;
    }

    public GraphDatabaseFacade getDefaultDatabase() {
        Config config = (Config)TestWebContainer.getDependencyResolver(this.managementService).resolveDependency(Config.class);
        String defaultDatabase = (String)config.get(GraphDatabaseSettings.initial_default_database);
        return (GraphDatabaseFacade)this.managementService.database(defaultDatabase);
    }

    public <T> T resolveDependency(Class<T> clazz) {
        return (T)TestWebContainer.getDependencyResolver(this.managementService).resolveDependency(clazz);
    }

    public Config getConfig() {
        return this.neoWebServer.getConfig();
    }

    public TransactionRegistry getTransactionRegistry() {
        return this.neoWebServer.getTransactionRegistry();
    }

    private static NeoWebServer getNeoWebServer(DatabaseManagementService managementService) {
        return (NeoWebServer)TestWebContainer.getDependencyResolver(managementService).resolveDependency(NeoWebServer.class);
    }

    private static DependencyResolver getDependencyResolver(DatabaseManagementService managementService) {
        return ((GraphDatabaseAPI)managementService.database("system")).getDependencyResolver();
    }
}

