/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.PageCacheTestSupport;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCacheTest;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class MuninnPageCacheWithRealFileSystemWithReservedBytesIT
extends MuninnPageCacheTest {
    private static final ImmutableSet<OpenOption> TEST_OPEN_OPTIONS = Sets.immutable.of((Object)PageCacheOpenOptions.MULTI_VERSIONED);
    @Inject
    TestDirectory directory;

    MuninnPageCacheWithRealFileSystemWithReservedBytesIT() {
        this.SHORT_TIMEOUT_MILLIS = 240000L;
        this.SEMI_LONG_TIMEOUT_MILLIS = 720000L;
        this.LONG_TIMEOUT_MILLIS = 2400000L;
    }

    @Override
    protected ImmutableSet<OpenOption> getOpenOptions() {
        return TEST_OPEN_OPTIONS;
    }

    @Override
    protected boolean isMultiVersioned() {
        return true;
    }

    @Override
    protected PageCacheTestSupport.Fixture<MuninnPageCache> createFixture() {
        return super.createFixture().withFileSystemAbstraction(DefaultFileSystemAbstraction::new).withFileConstructor(arg_0 -> ((TestDirectory)this.directory).file(arg_0));
    }

    @Test
    void writeAndReadFullPageWithReservedBytesWithoutOutOfBounds() throws IOException {
        byte data = 5;
        try (MuninnPageCache pageCache = (MuninnPageCache)this.getPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());
             PagedFile pagedFile = this.map(this.file("a"), pageCache.pageSize());){
            int counter;
            try (MuninnPageCursor writer = (MuninnPageCursor)pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                counter = 0;
                while (writer.getOffset() < writer.getPayloadSize()) {
                    writer.putByte(data);
                    ++counter;
                }
                org.junit.jupiter.api.Assertions.assertFalse((boolean)writer.checkAndClearBoundsFlag());
                org.junit.jupiter.api.Assertions.assertEquals((int)counter, (int)writer.getPayloadSize());
            }
            try (MuninnPageCursor reader = (MuninnPageCursor)pagedFile.io(0L, 1, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                counter = 0;
                while (reader.getOffset() < reader.getPayloadSize()) {
                    org.junit.jupiter.api.Assertions.assertEquals((byte)data, (byte)reader.getByte());
                    ++counter;
                }
                org.junit.jupiter.api.Assertions.assertFalse((boolean)reader.checkAndClearBoundsFlag());
                org.junit.jupiter.api.Assertions.assertEquals((int)counter, (int)reader.getPayloadSize());
            }
        }
    }

    @Test
    void outOfBoundsOnAttemptToWriteOrReadWholePageData() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.getPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());
             PagedFile pagedFile = this.map(this.file("a"), pageCache.pageSize());){
            try (PageCursor writer = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                long value = 1L;
                while (writer.getOffset() < pageCache.pageSize()) {
                    writer.putLong(value++);
                }
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.checkAndClearBoundsFlag());
            }
            try (PageCursor reader = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                while (reader.getOffset() < pageCache.pageSize()) {
                    Assertions.assertThat((long)reader.getLong()).isGreaterThan(0L);
                }
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.checkAndClearBoundsFlag());
            }
        }
    }

    @Test
    void offsetIsLogicalAndDoesNotDependFromNumberOfReservedBytesForInts() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.getPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());
             PagedFile pagedFile = this.map(this.file("a"), pageCache.pageSize());){
            int offset = 0;
            int typeBytes = 4;
            int expectedIterations = pagedFile.payloadSize() / typeBytes;
            Assertions.assertThat((int)expectedIterations).isNotZero();
            try (PageCursor writer = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                int writes = 0;
                while (writer.getOffset() < writer.getPagedFile().payloadSize()) {
                    org.junit.jupiter.api.Assertions.assertEquals((int)offset, (int)writer.getOffset());
                    writer.putInt(offset);
                    offset += typeBytes;
                    ++writes;
                }
                org.junit.jupiter.api.Assertions.assertFalse((boolean)writer.checkAndClearBoundsFlag());
                org.junit.jupiter.api.Assertions.assertEquals((int)expectedIterations, (int)writes);
            }
            try (PageCursor reader = pagedFile.io(0L, 1, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                int reads = 0;
                while (offset > 0) {
                    int value = offset - typeBytes;
                    org.junit.jupiter.api.Assertions.assertEquals((int)value, (int)reader.getInt(value));
                    offset = value;
                    ++reads;
                }
                org.junit.jupiter.api.Assertions.assertFalse((boolean)reader.checkAndClearBoundsFlag());
                org.junit.jupiter.api.Assertions.assertEquals((int)expectedIterations, (int)reads);
            }
        }
    }

    @Test
    void offsetIsLogicalAndDoesNotDependFromNumberOfReservedBytesForLongs() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.getPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());
             PagedFile pagedFile = this.map(this.file("a"), pageCache.pageSize());){
            int offset = 0;
            int typeBytes = 8;
            int expectedIterations = pagedFile.payloadSize() / typeBytes;
            Assertions.assertThat((int)expectedIterations).isNotZero();
            try (PageCursor writer = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                int writes = 0;
                while (writer.getOffset() < writer.getPagedFile().payloadSize()) {
                    org.junit.jupiter.api.Assertions.assertEquals((int)offset, (int)writer.getOffset());
                    writer.putLong((long)offset);
                    offset += typeBytes;
                    ++writes;
                }
                org.junit.jupiter.api.Assertions.assertFalse((boolean)writer.checkAndClearBoundsFlag());
                org.junit.jupiter.api.Assertions.assertEquals((int)expectedIterations, (int)writes);
            }
            try (PageCursor reader = pagedFile.io(0L, 1, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                int reads = 0;
                while (offset > 0) {
                    int value = offset - typeBytes;
                    org.junit.jupiter.api.Assertions.assertEquals((long)value, (long)reader.getLong(value));
                    offset = value;
                    ++reads;
                }
                org.junit.jupiter.api.Assertions.assertFalse((boolean)reader.checkAndClearBoundsFlag());
                org.junit.jupiter.api.Assertions.assertEquals((int)expectedIterations, (int)reads);
            }
        }
    }

    @Test
    void outOfBoundsWhenReadDataOutsideOfPayloadWindow() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.getPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());){
            Path file = this.file("a");
            this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize, this.recordsPerFilePage, this.reservedBytes, this.filePageSize);
            try (PagedFile pagedFile = this.map(file, pageCache.pageSize());
                 PageCursor reader = pagedFile.io(0L, 1, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                this.checkReadOob(reader, pagedFile.payloadSize());
                this.checkReadOob(reader, -1);
                this.checkReadOob(reader, -5);
                this.checkReadOob(reader, -10);
                reader.getByte();
                org.junit.jupiter.api.Assertions.assertFalse((boolean)reader.checkAndClearBoundsFlag());
            }
        }
    }

    @Test
    void outOfBoundsWhenWriteDataOutsideOfPayloadWindow() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.getPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());){
            Path file = this.file("a");
            this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize, this.recordsPerFilePage, this.reservedBytes, this.filePageSize);
            try (PagedFile pagedFile = this.map(file, pageCache.pageSize());
                 PageCursor writer = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                this.checkWriteOob(writer, pagedFile.payloadSize());
                this.checkWriteOob(writer, -1);
                this.checkWriteOob(writer, -5);
                this.checkWriteOob(writer, -10);
                writer.putByte((byte)7);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)writer.checkAndClearBoundsFlag());
            }
        }
    }

    @Test
    void offsetAccessAndMutationTakeReservedBytesIntoAccount() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.getPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());
             PagedFile pagedFile = this.map(this.file("a"), pageCache.pageSize());){
            int offset = 0;
            try (PageCursor writer = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                writer.putByte(offset, (byte)1);
                writer.putShort(++offset, (short)2);
                writer.putInt(offset += 2, 3);
                writer.putLong(offset += 4, 4L);
                offset += 8;
            }
            try (PageCursor reader = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)reader.getLong(offset -= 8));
                org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)reader.getInt(offset -= 4));
                org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)reader.getShort(offset -= 2));
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)reader.getByte(--offset));
                org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)reader.getOffset());
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)reader.getByte());
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)reader.getOffset());
                org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)reader.getShort());
                org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)reader.getOffset());
                org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)reader.getInt());
                org.junit.jupiter.api.Assertions.assertEquals((int)7, (int)reader.getOffset());
                org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)reader.getLong());
                org.junit.jupiter.api.Assertions.assertEquals((int)15, (int)reader.getOffset());
            }
        }
    }

    @Test
    void copyToCursorFailToCopyWholePageSizeAndCopyOnlyPayload() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.getPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());
             PagedFile pagedFile = this.map(this.file("a"), pageCache.pageSize());
             MuninnPageCursor writer = (MuninnPageCursor)pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);
             MuninnPageCursor writer2 = (MuninnPageCursor)pagedFile.io(1L, 2, CursorContext.NULL_CONTEXT);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer2.next());
            int value = 1;
            while (writer.getOffset() < writer.getPagedFile().payloadSize()) {
                writer.putInt(value);
            }
            int copiedBytes = writer.copyTo(0, (PageCursor)writer2, 0, writer.getPageSize());
            org.junit.jupiter.api.Assertions.assertEquals((int)writer.getPagedFile().payloadSize(), (int)copiedBytes);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)writer.checkAndClearBoundsFlag());
            int expectedValue = 1;
            while (writer2.getOffset() < writer2.getPagedFile().payloadSize()) {
                org.junit.jupiter.api.Assertions.assertEquals((int)expectedValue, (int)writer2.getInt());
            }
        }
    }

    @Test
    void copyPageCopyWholePageWithPayload() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.getPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());
             PagedFile pagedFile = this.map(this.file("a"), pageCache.pageSize());
             MuninnPageCursor writer = (MuninnPageCursor)pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);
             MuninnPageCursor writer2 = (MuninnPageCursor)pagedFile.io(1L, 2, CursorContext.NULL_CONTEXT);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer2.next());
            int value = 7;
            while (writer.getOffset() < writer.getPagedFile().payloadSize()) {
                writer.putInt(value);
            }
            MuninnPageCursor.putLongAt((long)writer.pointer, (long)101L, (boolean)true);
            MuninnPageCursor.putLongAt((long)(writer.pointer + 8L), (long)4242L, (boolean)true);
            writer.copyPage((PageCursor)writer2);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)writer.checkAndClearBoundsFlag());
            org.junit.jupiter.api.Assertions.assertEquals((long)101L, (long)MuninnPageCursor.getLongAt((long)writer2.pointer, (boolean)true));
            org.junit.jupiter.api.Assertions.assertEquals((long)4242L, (long)MuninnPageCursor.getLongAt((long)(writer.pointer + 8L), (boolean)true));
            int expectedValue = 7;
            while (writer2.getOffset() < writer2.getPagedFile().payloadSize()) {
                org.junit.jupiter.api.Assertions.assertEquals((int)expectedValue, (int)writer2.getInt());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void copyToByteBufferTakeReservedBytesIntoAccount() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.getPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());
             PagedFile pagedFile = this.map(this.file("a"), pageCache.pageSize());
             MuninnPageCursor writer = (MuninnPageCursor)pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            int value = 1;
            int writtenValues = 0;
            while (writer.getOffset() < writer.getPagedFile().payloadSize()) {
                writer.putInt(value++);
                ++writtenValues;
            }
            Assertions.assertThat((int)writtenValues).isNotZero();
            ByteBuffer heapBuffer = ByteBuffers.allocate((int)writer.getPageSize(), (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            ByteBuffer nativeBuffer = ByteBuffers.allocateDirect((int)writer.getPageSize(), (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            try {
                this.checkCopiedBuffer(writer, writtenValues, heapBuffer, writer.copyTo(0, heapBuffer));
                this.checkCopiedBuffer(writer, writtenValues, nativeBuffer, writer.copyTo(0, nativeBuffer));
            }
            finally {
                ByteBuffers.releaseBuffer((ByteBuffer)nativeBuffer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            }
        }
    }

    @Test
    void shiftBytesOverflowsWhenShiftingOverPayloadWindow() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.getPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());
             PagedFile pagedFile = this.map(this.file("a"), pageCache.pageSize());
             PageCursor writer = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            int value = 1;
            while (writer.getOffset() < writer.getPagedFile().payloadSize()) {
                writer.putInt(value++);
            }
            writer.shiftBytes(0, writer.getPagedFile().payloadSize(), 1);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesTakesReservedBytesIntoAccount() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.getPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());
             PagedFile pagedFile = this.map(this.file("a"), pageCache.pageSize());
             PageCursor writer = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
            int value = 1;
            while (writer.getOffset() < writer.getPagedFile().payloadSize()) {
                writer.putInt(value++);
            }
            int windowSize = 16;
            writer.shiftBytes(0, windowSize, 4);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)writer.checkAndClearBoundsFlag());
            writer.shiftBytes(4, windowSize, -4);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)writer.checkAndClearBoundsFlag());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)writer.getInt(0));
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)writer.getInt(4));
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)writer.getInt(8));
            org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)writer.getInt(12));
        }
    }

    @Test
    void overflowOnAccessingDataWithOffsetGreaterThanPayload() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.getPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());
             PagedFile pagedFile = this.map(this.file("a"), pageCache.pageSize());){
            try (PageCursor writer = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                writer.getByte(writer.getPagedFile().payloadSize() - 1);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)writer.checkAndClearBoundsFlag());
                writer.getByte(writer.getPagedFile().payloadSize());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.checkAndClearBoundsFlag());
            }
            try (MuninnPageCursor reader = (MuninnPageCursor)pagedFile.io(0L, 1, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                reader.getByte(reader.getPayloadSize() - 1);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)reader.checkAndClearBoundsFlag());
                reader.getByte(reader.getPayloadSize());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.checkAndClearBoundsFlag());
            }
        }
    }

    private void checkCopiedBuffer(MuninnPageCursor writer, int writtenValues, ByteBuffer buffer, int copiedBytes) {
        org.junit.jupiter.api.Assertions.assertEquals((int)writer.getPayloadSize(), (int)copiedBytes);
        buffer.flip();
        int copiedValue = 1;
        int numberOfItems = 0;
        while (buffer.hasRemaining()) {
            org.junit.jupiter.api.Assertions.assertEquals((int)copiedValue++, (int)buffer.getInt());
            ++numberOfItems;
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)numberOfItems, (int)writtenValues);
    }

    private void checkReadOob(PageCursor reader, int offset) {
        reader.getLong(offset);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.checkAndClearBoundsFlag());
        reader.getInt(offset);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.checkAndClearBoundsFlag());
        reader.getShort(offset);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.checkAndClearBoundsFlag());
        reader.getByte(offset);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.checkAndClearBoundsFlag());
    }

    private void checkWriteOob(PageCursor writer, int offset) {
        writer.putLong(offset, 1L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.checkAndClearBoundsFlag());
        writer.putInt(offset, 1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.checkAndClearBoundsFlag());
        writer.putShort(offset, (short)1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.checkAndClearBoundsFlag());
        writer.putByte(offset, (byte)1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.checkAndClearBoundsFlag());
    }
}

