/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.pagecache.impl.muninn.OffHeapPageLock;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.scheduler.DaemonThreadFactory;
import org.neo4j.util.concurrent.Futures;

class SequenceLockStressIT {
    private static ExecutorService executor;
    private static long lockAddr;

    SequenceLockStressIT() {
    }

    @BeforeAll
    static void initialise() {
        lockAddr = UnsafeUtil.allocateMemory((long)8L, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        executor = Executors.newCachedThreadPool((ThreadFactory)new DaemonThreadFactory());
    }

    @AfterAll
    static void cleanup() {
        executor.shutdown();
        UnsafeUtil.free((long)lockAddr, (long)8L, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    @BeforeEach
    void allocateLock() {
        UnsafeUtil.putLong((long)lockAddr, (long)0L);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void stressTest(boolean multiVersioned) throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.runTest(multiVersioned);
        }
    }

    private void runTest(final boolean multiVersioned) throws InterruptedException, ExecutionException {
        int i;
        final int[][] data = new int[10][10];
        final AtomicBoolean stop = new AtomicBoolean();
        final AtomicInteger writerId = new AtomicInteger();
        abstract class Worker
        implements Runnable {
            final /* synthetic */ AtomicBoolean val$stop;

            Worker() {
                this.val$stop = atomicBoolean;
            }

            @Override
            public void run() {
                try {
                    this.doWork();
                }
                finally {
                    this.val$stop.set(true);
                }
            }

            protected abstract void doWork();
        }
        Worker reader = new Worker(){
            {
                super(SequenceLockStressIT.this, atomicBoolean);
            }

            @Override
            protected void doWork() {
                while (!stop.get()) {
                    ThreadLocalRandom rng = ThreadLocalRandom.current();
                    int[] record = data[rng.nextInt(data.length)];
                    long stamp = OffHeapPageLock.tryOptimisticReadLock((long)lockAddr);
                    int value = record[0];
                    boolean consistent = true;
                    for (int i : record) {
                        consistent &= i == value;
                    }
                    if (OffHeapPageLock.validateReadLock((long)lockAddr, (long)stamp) && !consistent) {
                        throw new AssertionError((Object)"inconsistent read");
                    }
                }
            }
        };
        Worker writer = new Worker(){
            private volatile long unused;
            {
                super(SequenceLockStressIT.this, atomicBoolean);
            }

            @Override
            protected void doWork() {
                int id = writerId.getAndIncrement();
                int counter = 1;
                ThreadLocalRandom rng = ThreadLocalRandom.current();
                int smallSpin = rng.nextInt(5, 50);
                int bigSpin = rng.nextInt(100, 1000);
                while (!stop.get()) {
                    if (OffHeapPageLock.tryWriteLock((long)lockAddr, (boolean)multiVersioned)) {
                        int[] record = data[id];
                        for (int i = 0; i < record.length; ++i) {
                            record[i] = counter;
                            for (int j = 0; j < smallSpin; ++j) {
                                this.unused = rng.nextLong();
                            }
                        }
                        OffHeapPageLock.unlockWrite((long)lockAddr);
                    }
                    for (int j = 0; j < bigSpin; ++j) {
                        this.unused = rng.nextLong();
                    }
                }
            }
        };
        Worker exclusive = new Worker(){
            private volatile long unused;
            {
                super(SequenceLockStressIT.this, atomicBoolean);
            }

            @Override
            protected void doWork() {
                ThreadLocalRandom rng = ThreadLocalRandom.current();
                int spin = rng.nextInt(20, 2000);
                while (!stop.get()) {
                    while (!OffHeapPageLock.tryExclusiveLock((long)lockAddr)) {
                    }
                    long sumA = 0L;
                    long sumB = 0L;
                    int[][] nArray = data;
                    int n = nArray.length;
                    for (int i = 0; i < n; ++i) {
                        int[] ints;
                        for (int i2 : ints = nArray[i]) {
                            sumA += (long)i2;
                        }
                    }
                    for (int i = 0; i < spin; ++i) {
                        this.unused = rng.nextLong();
                    }
                    for (int[] record : data) {
                        for (int value : record) {
                            sumB += (long)value;
                        }
                        Arrays.fill(record, 0);
                    }
                    OffHeapPageLock.unlockExclusive((long)lockAddr);
                    if (sumA != sumB) {
                        throw new AssertionError((Object)("Inconsistent exclusive lock. 'Sum A' = " + sumA + ", 'Sum B' = " + sumB));
                    }
                }
            }
        };
        ArrayList readers = new ArrayList();
        ArrayList writers = new ArrayList();
        Future<?> exclusiveFuture = executor.submit(exclusive);
        for (i = 0; i < 20; ++i) {
            readers.add(executor.submit(reader));
        }
        for (i = 0; i < data.length; ++i) {
            writers.add(executor.submit(writer));
        }
        long deadline = System.currentTimeMillis() + 1000L;
        while (!stop.get() && System.currentTimeMillis() < deadline) {
            Thread.sleep(20L);
        }
        stop.set(true);
        exclusiveFuture.get();
        Futures.getAll(writers);
        Futures.getAll(readers);
    }

    @Test
    void thoroughlyEnsureAtomicityOfUnlockExclusiveAndTakeWriteLock() throws Exception {
        for (int i = 0; i < 30000; ++i) {
            SequenceLockStressIT.unlockExclusiveAndTakeWriteLockMustBeAtomic();
            OffHeapPageLock.unlockWrite((long)lockAddr);
        }
    }

    private static void unlockExclusiveAndTakeWriteLockMustBeAtomic() throws Exception {
        int threads = Runtime.getRuntime().availableProcessors() - 1;
        CountDownLatch start = new CountDownLatch(threads);
        AtomicBoolean stop = new AtomicBoolean();
        OffHeapPageLock.tryExclusiveLock((long)lockAddr);
        Runnable runnable = () -> {
            while (!stop.get()) {
                if (OffHeapPageLock.tryExclusiveLock((long)lockAddr)) {
                    OffHeapPageLock.unlockExclusive((long)lockAddr);
                    throw new RuntimeException("I should not have gotten that lock");
                }
                start.countDown();
            }
        };
        ArrayList futures = new ArrayList();
        for (int i = 0; i < threads; ++i) {
            futures.add(executor.submit(runnable));
        }
        start.await();
        OffHeapPageLock.unlockExclusiveAndTakeWriteLock((long)lockAddr);
        stop.set(true);
        Futures.getAll(futures);
    }
}

