/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.randomharness;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.randomharness.Record;
import org.neo4j.io.pagecache.randomharness.RecordFormat;

public class StandardRecordFormat
extends RecordFormat {
    @Override
    public int getRecordSize() {
        return 32;
    }

    @Override
    public Record createRecord(Path path, int recordId, int page, int offset) {
        return new StandardRecord(path, recordId, page, offset);
    }

    @Override
    public Record readRecord(PageCursor cursor) throws IOException {
        int recordOffset;
        int page;
        long f2;
        int recordId;
        short f1;
        byte f;
        byte t;
        int offset = cursor.getOffset();
        do {
            cursor.setOffset(offset);
            t = cursor.getByte();
            f = cursor.getByte();
            f1 = cursor.getShort();
            recordId = cursor.getInt();
            f2 = cursor.getLong();
            page = cursor.getInt();
            recordOffset = cursor.getInt();
            cursor.getLong();
        } while (cursor.shouldRetry());
        return new StandardRecord(t, f, f1, recordId, f2, page, recordOffset);
    }

    @Override
    public Record zeroRecord() {
        byte z = MuninnPageCache.ZERO_BYTE;
        short sz = (short)((z << 8) + z);
        int iz = (sz << 16) + sz;
        long lz = ((long)iz << 32) + (long)iz;
        return new StandardRecord(z, z, sz, iz, lz, 0, 0);
    }

    @Override
    public void write(Record record, PageCursor cursor) {
        StandardRecord r = (StandardRecord)record;
        byte[] pathBytes = r.path.toString().getBytes(StandardCharsets.UTF_8);
        byte fileByte = pathBytes[pathBytes.length - 1];
        cursor.putByte(r.type);
        cursor.putByte(fileByte);
        cursor.putShort(r.fill1);
        cursor.putInt(r.recordId);
        cursor.putLong(r.fill2);
        cursor.putInt(r.page);
        cursor.putInt(r.offset);
        cursor.putLong(0L);
    }

    static final class StandardRecord
    implements Record {
        final byte type;
        final Path path;
        final int recordId;
        final short fill1;
        final long fill2;
        private final int page;
        private final int offset;

        StandardRecord(Path path, int recordId, int page, int offset) {
            this.type = (byte)42;
            this.path = path;
            this.recordId = recordId;
            this.page = page;
            this.offset = offset;
            int fileHash = path.hashCode();
            int a = StandardRecord.xorshift(fileHash ^ StandardRecord.xorshift(recordId));
            int b = StandardRecord.xorshift(a);
            int c = StandardRecord.xorshift(b);
            long d = b;
            d <<= 32;
            this.fill1 = (short)a;
            this.fill2 = d += (long)c;
        }

        StandardRecord(byte type, byte fileName, short fill1, int recordId, long fill2, int page, int offset) {
            this.type = type;
            this.path = fileName == 0 ? null : Path.of(new String(new byte[]{fileName}), new String[0]);
            this.fill1 = fill1;
            this.recordId = recordId;
            this.page = page;
            this.offset = offset;
            this.fill2 = fill2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StandardRecord record = (StandardRecord)o;
            return this.type == record.type && this.recordId == record.recordId && this.fill1 == record.fill1 && this.fill2 == record.fill2 && this.filesEqual(record);
        }

        private boolean filesEqual(StandardRecord record) {
            byte[] thatPath;
            if (this.path == record.path) {
                return true;
            }
            if (this.path == null || record.path == null) {
                return false;
            }
            byte[] thisPath = this.path.toString().getBytes(StandardCharsets.UTF_8);
            return thisPath[thisPath.length - 1] == (thatPath = record.path.toString().getBytes(StandardCharsets.UTF_8))[thatPath.length - 1];
        }

        public int hashCode() {
            int result = this.type;
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + this.recordId;
            result = 31 * result + this.fill1;
            result = 31 * result + (int)(this.fill2 ^ this.fill2 >>> 32);
            return result;
        }

        private static int xorshift(int x) {
            x ^= x << 6;
            x ^= x >>> 21;
            return x ^ x << 7;
        }

        public String toString() {
            return this.format(this.type, this.path, this.recordId, this.fill1, this.fill2);
        }

        public String format(byte type, Path path, int recordId, short fill1, long fill2) {
            return String.format("Record%s on page: %s offset: %s [file=%s, recordId=%s; %04x %016x]", type, this.page, this.offset, path, recordId, fill1, fill2);
        }
    }
}

