/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.server.AbstractNeoWebServer;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;

class StartupLoggingIT
extends ExclusiveWebContainerTestBase {
    StartupLoggingIT() {
    }

    @Test
    void shouldLogHelpfulStartupMessages() throws IOException {
        CommunityBootstrapper bootstrapper = new CommunityBootstrapper();
        Map<String, String> propertyPairs = this.getPropertyPairs();
        bootstrapper.start(this.testDirectory.homePath(), Path.of("nonexistent-file.conf", new String[0]), propertyPairs, false, false);
        DependencyResolver resolver = StartupLoggingIT.getDependencyResolver(bootstrapper.getDatabaseManagementService());
        URI uri = ((AbstractNeoWebServer)resolver.resolveDependency(AbstractNeoWebServer.class)).getBaseUri();
        bootstrapper.stop();
        List captured = FileSystemUtils.readLines((FileSystemAbstraction)this.testDirectory.getFileSystem(), (Path)this.testDirectory.homePath().resolve("neo4j.log"), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        Assertions.assertThat((List)captured).satisfies(StartupLoggingIT.containsAtLeastTheseLines(StartupLoggingIT.warn("Config file \\[nonexistent-file.conf\\] does not exist."), StartupLoggingIT.info("Starting..."), StartupLoggingIT.info(AbstractNeoWebServer.NEO4J_IS_STARTING_MESSAGE), StartupLoggingIT.info("Remote interface available at " + String.valueOf(uri)), StartupLoggingIT.info("id: .*"), StartupLoggingIT.info("name: system"), StartupLoggingIT.info("creationDate: .*"), StartupLoggingIT.info("Started."), StartupLoggingIT.info("Stopping..."), StartupLoggingIT.info("Stopped.")));
    }

    private static DependencyResolver getDependencyResolver(DatabaseManagementService managementService) {
        return ((GraphDatabaseAPI)managementService.database("neo4j")).getDependencyResolver();
    }

    private Map<String, String> getPropertyPairs() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(GraphDatabaseSettings.data_directory.name(), this.testDirectory.homePath().toString());
        properties.put(GraphDatabaseSettings.logs_directory.name(), this.testDirectory.homePath().toString());
        properties.put(HttpConnector.listen_address.name(), "localhost:0");
        properties.put(HttpConnector.advertised_address.name(), ":0");
        properties.put(HttpConnector.enabled.name(), "true");
        properties.put(HttpsConnector.listen_address.name(), "localhost:0");
        properties.put(HttpsConnector.advertised_address.name(), ":0");
        properties.put(HttpsConnector.enabled.name(), "false");
        properties.put(BoltConnector.enabled.name(), "true");
        properties.put(BoltConnector.listen_address.name(), "localhost:0");
        properties.put(BoltConnector.advertised_address.name(), ":0");
        properties.put(BoltConnector.encryption_level.name(), "DISABLED");
        properties.put(GraphDatabaseInternalSettings.databases_root_path.name(), this.testDirectory.absolutePath().toString());
        return properties;
    }

    private static Condition<? super List<? extends String>> containsAtLeastTheseLines(Pattern ... expectedLinePatterns) {
        return new Condition(lines -> {
            if (expectedLinePatterns.length > lines.size()) {
                return false;
            }
            int e = 0;
            for (int i = 0; i < lines.size(); ++i) {
                String line = (String)lines.get(i);
                while (!expectedLinePatterns[e].matcher(line).matches()) {
                    if (++i >= lines.size()) {
                        return false;
                    }
                    line = (String)lines.get(i);
                }
                ++e;
            }
            return true;
        }, "Expected: " + String.valueOf(Arrays.asList(expectedLinePatterns)), new Object[0]);
    }

    private static Pattern info(String messagePattern) {
        return StartupLoggingIT.line("INFO", messagePattern);
    }

    private static Pattern warn(String messagePattern) {
        return StartupLoggingIT.line("WARN", messagePattern);
    }

    private static Pattern line(String level, String messagePattern) {
        return Pattern.compile(".*" + level + "\\s+" + messagePattern);
    }
}

