/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.http.cypher.integration.TransactionConditions;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.test.server.HTTP;

public class TransactionErrorIT
extends AbstractRestFunctionalTestBase {
    @Test
    public void begin__commit_with_invalid_cypher() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response response = this.POST("db/neo4j/tx", HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        String commitResource = response.stringFromContent("commit");
        response = this.POST(commitResource, HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE ;;' } ] }"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((Object)response).satisfies(new Consumer[]{TransactionConditions.hasErrors((Status[])new Status[]{Status.Statement.SyntaxError})});
        Assertions.assertThat((Object)response).satisfies(TransactionConditions.containsNoStackTraces());
        Assertions.assertThat((long)this.countNodes()).isEqualTo(nodesInDatabaseBeforeTransaction);
    }

    @Test
    public void begin__commit_with_malformed_json() throws Exception {
        long nodesInDatabaseBeforeTransaction = this.countNodes();
        HTTP.Response begin = this.POST("db/neo4j/tx", HTTP.RawPayload.quotedJson((String)"{ 'statements': [ { 'statement': 'CREATE (n)' } ] }"));
        String commitResource = begin.stringFromContent("commit");
        HTTP.Response response = this.POST(commitResource, HTTP.RawPayload.rawPayload((String)"[{asd,::}]"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Assertions.assertThat((Object)response).satisfies(new Consumer[]{TransactionConditions.hasErrors((Status[])new Status[]{Status.Request.InvalidFormat})});
        Assertions.assertThat((long)this.countNodes()).isEqualTo(nodesInDatabaseBeforeTransaction);
    }

    private long countNodes() {
        return TransactionConditions.countNodes((GraphDatabaseService)this.graphdb());
    }
}

