/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;

public class RedirectorIT
extends AbstractRestFunctionalTestBase {
    @Test
    public void shouldRedirectRootToBrowser() throws Exception {
        HttpRequest request = HttpRequest.newBuilder(RedirectorIT.container().getBaseUri()).GET().build();
        HttpResponse<Void> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.discarding());
        Assertions.assertThat((int)response.statusCode()).isNotEqualTo(404);
    }

    @Test
    public void shouldNotRedirectTheRestOfTheWorld() throws Exception {
        URI uri = URI.create(String.valueOf(RedirectorIT.container().getBaseUri()) + "a/different/relative/data/uri/");
        HttpRequest request = HttpRequest.newBuilder(uri).GET().build();
        HttpResponse<Void> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.discarding());
        Assertions.assertThat((int)response.statusCode()).isEqualTo(404);
    }
}

