/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storemigration;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.cli.AdminTool;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.dbms.MigrateStoreCommand;
import org.neo4j.consistency.checking.ConsistencyCheckIncompleteException;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.ZippedStore;
import org.neo4j.kernel.ZippedStoreCommunity;
import org.neo4j.server.security.systemgraph.versions.KnownCommunitySecurityComponentVersion;
import org.neo4j.storemigration.DatabaseMigrationITBase;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import picocli.CommandLine;

public class DatabaseMigrationCommunityIT
extends DatabaseMigrationITBase {
    public static Stream<Arguments> migrations() {
        ArrayList<Arguments> permutations = new ArrayList<Arguments>();
        permutations.add(Arguments.arguments((Object[])new Object[]{ZippedStoreCommunity.AF430_V42_INJECTED_NLI, "aligned"}));
        permutations.add(Arguments.arguments((Object[])new Object[]{ZippedStoreCommunity.AF430_V43D4_PERSISTED_NLI, "aligned"}));
        permutations.add(Arguments.arguments((Object[])new Object[]{ZippedStoreCommunity.SF430_V43D4_ALL_NO_BTREE, "standard"}));
        permutations.add(Arguments.arguments((Object[])new Object[]{ZippedStoreCommunity.SF430_V43D4_ALL_NO_BTREE, "aligned"}));
        permutations.add(Arguments.arguments((Object[])new Object[]{ZippedStoreCommunity.AF430_V43D4_ALL_NO_BTREE, "aligned"}));
        permutations.add(Arguments.arguments((Object[])new Object[]{ZippedStoreCommunity.SF430_V44_ALL, "standard"}));
        permutations.add(Arguments.arguments((Object[])new Object[]{ZippedStoreCommunity.SF430_V44_ALL, "aligned"}));
        permutations.add(Arguments.arguments((Object[])new Object[]{ZippedStoreCommunity.AF430_V44_ALL, "aligned"}));
        permutations.add(Arguments.arguments((Object[])new Object[]{ZippedStoreCommunity.REC_SF11_V50_ALL, "standard"}));
        permutations.add(Arguments.arguments((Object[])new Object[]{ZippedStoreCommunity.REC_SF11_V50_ALL, "aligned"}));
        permutations.add(Arguments.arguments((Object[])new Object[]{ZippedStoreCommunity.REC_AF11_V50_ALL, "aligned"}));
        return permutations.stream();
    }

    public static Stream<DatabaseMigrationITBase.SystemDbMigration> systemDbMigrations() {
        ArrayList<DatabaseMigrationITBase.SystemDbMigration> permutations = new ArrayList<DatabaseMigrationITBase.SystemDbMigration>();
        permutations.add(new DatabaseMigrationITBase.SystemDbMigration((ZippedStore)ZippedStoreCommunity.AF430_V42_INJECTED_NLI, false));
        permutations.add(new DatabaseMigrationITBase.SystemDbMigration((ZippedStore)ZippedStoreCommunity.AF430_V43D4_PERSISTED_NLI, false));
        permutations.add(new DatabaseMigrationITBase.SystemDbMigration((ZippedStore)ZippedStoreCommunity.AF430_V43D4_ALL_NO_BTREE, true));
        permutations.add(new DatabaseMigrationITBase.SystemDbMigration((ZippedStore)ZippedStoreCommunity.AF430_V44_ALL, true));
        return permutations.stream();
    }

    @Test
    public void shouldSelectCommunityVersionOfMigrateCommand() {
        ExecutionContext executionContext = new ExecutionContext(Path.of("hej", new String[0]), Path.of("something", new String[0]));
        CommandLine commandLine = AdminTool.getCommandLine((ExecutionContext)executionContext);
        CommandLine.ParseResult result = commandLine.parseArgs(new String[]{"database", "migrate", "neo4j"});
        List commandLines = result.asCommandLineList();
        Object command = ((CommandLine)commandLines.get(commandLines.size() - 1)).getCommand();
        Assertions.assertThat((Object)command).isExactlyInstanceOf(MigrateStoreCommand.class);
    }

    @ParameterizedTest
    @MethodSource(value={"migrations"})
    void shouldMigrateDatabase(ZippedStore zippedStore, String toRecordFormat) throws IOException, ConsistencyCheckIncompleteException {
        this.doShouldMigrateDatabase(zippedStore, toRecordFormat, false);
    }

    @ParameterizedTest
    @MethodSource(value={"systemDbMigrations"})
    void shouldMigrateSystemDatabase(DatabaseMigrationITBase.SystemDbMigration systemDbMigration) throws IOException, ConsistencyCheckIncompleteException {
        this.doShouldMigrateSystemDatabase(systemDbMigration);
    }

    @ParameterizedTest
    @MethodSource(value={"systemDbMigrations"})
    void shouldMigrateSystemDatabaseAndOthers(DatabaseMigrationITBase.SystemDbMigration systemDbMigration) throws IOException, ConsistencyCheckIncompleteException {
        this.doShouldMigrateSystemDatabaseAndOthers(systemDbMigration);
    }

    @Override
    protected TestDatabaseManagementServiceBuilder newDbmsBuilder(Path homeDir) {
        return new TestDatabaseManagementServiceBuilder(homeDir);
    }

    @Override
    protected void verifySystemDbSchema(GraphDatabaseService system, DatabaseMigrationITBase.SystemDbMigration systemDbMigration) {
        try (Transaction tx = system.beginTx();){
            List constraints = Iterables.asList((Iterable)tx.schema().getConstraints());
            DatabaseMigrationCommunityIT.verifyHasUniqueConstraint(constraints, TopologyGraphDbmsModel.DATABASE_NAME_LABEL, "name", "namespace");
            DatabaseMigrationCommunityIT.verifyHasUniqueConstraint(constraints, TopologyGraphDbmsModel.DATABASE_LABEL, "name");
            DatabaseMigrationCommunityIT.verifyHasUniqueConstraint(constraints, KnownCommunitySecurityComponentVersion.USER_LABEL, "id");
            DatabaseMigrationCommunityIT.verifyHasUniqueConstraint(constraints, KnownCommunitySecurityComponentVersion.USER_LABEL, "name");
            DatabaseMigrationCommunityIT.verifyHasUniqueConstraint(constraints, KnownCommunitySecurityComponentVersion.AUTH_LABEL, "id", "provider");
            Assertions.assertThat((List)constraints).hasSize(5);
            List indexes = Iterables.asList((Iterable)tx.schema().getIndexes());
            DatabaseMigrationCommunityIT.verifyHasIndex(indexes, TopologyGraphDbmsModel.DATABASE_NAME_LABEL, "name", "namespace");
            DatabaseMigrationCommunityIT.verifyHasIndex(indexes, TopologyGraphDbmsModel.DATABASE_LABEL, "name");
            DatabaseMigrationCommunityIT.verifyHasIndex(indexes, KnownCommunitySecurityComponentVersion.USER_LABEL, "id");
            DatabaseMigrationCommunityIT.verifyHasIndex(indexes, KnownCommunitySecurityComponentVersion.USER_LABEL, "name");
            DatabaseMigrationCommunityIT.verifyHasIndex(indexes, KnownCommunitySecurityComponentVersion.AUTH_LABEL, "id", "provider");
            Assertions.assertThat((List)indexes).anySatisfy(indexDefinition -> {
                Assertions.assertThat((Comparable)indexDefinition.getIndexType()).isEqualTo((Object)IndexType.LOOKUP);
                Assertions.assertThat((boolean)indexDefinition.isNodeIndex()).isEqualTo(true);
            });
            if (systemDbMigration.hasRelationshipTypeIndex()) {
                Assertions.assertThat((List)indexes).anySatisfy(indexDefinition -> {
                    Assertions.assertThat((Comparable)indexDefinition.getIndexType()).isEqualTo((Object)IndexType.LOOKUP);
                    Assertions.assertThat((boolean)indexDefinition.isRelationshipIndex()).isEqualTo(true);
                });
                Assertions.assertThat((List)indexes).hasSize(7);
            } else {
                Assertions.assertThat((List)indexes).hasSize(6);
            }
            tx.commit();
        }
    }
}

