/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.availability;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.AvailabilityRequirement;
import org.neo4j.kernel.availability.CompositeDatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailability;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.database.AbstractDatabase;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;

@TestDirectoryExtension
@DbmsExtension
class DatabaseAvailabilityIT {
    private NamedDatabaseId defaultNamedDatabaseId;
    @Inject
    private GraphDatabaseAPI database;

    DatabaseAvailabilityIT() {
    }

    @BeforeEach
    void setUp() {
        this.defaultNamedDatabaseId = this.database.databaseId();
    }

    @Test
    void anyOfDatabaseUnavailabilityIsGlobalUnavailability() {
        AvailabilityRequirement outerSpaceRequirement = () -> "outer space";
        DependencyResolver dependencyResolver = this.database.getDependencyResolver();
        DatabaseContextProvider<?> databaseContextProvider = DatabaseAvailabilityIT.getDatabaseManager(dependencyResolver);
        CompositeDatabaseAvailabilityGuard compositeGuard = (CompositeDatabaseAvailabilityGuard)dependencyResolver.resolveDependency(CompositeDatabaseAvailabilityGuard.class);
        Assertions.assertTrue((boolean)compositeGuard.isAvailable());
        DatabaseContext systemContext = (DatabaseContext)databaseContextProvider.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID).get();
        DatabaseContext defaultContext = (DatabaseContext)databaseContextProvider.getDatabaseContext(this.defaultNamedDatabaseId).get();
        AvailabilityGuard systemGuard = (AvailabilityGuard)systemContext.dependencies().resolveDependency(DatabaseAvailabilityGuard.class);
        systemGuard.require(outerSpaceRequirement);
        Assertions.assertFalse((boolean)compositeGuard.isAvailable());
        systemGuard.fulfill(outerSpaceRequirement);
        Assertions.assertTrue((boolean)compositeGuard.isAvailable());
        AvailabilityGuard defaultGuard = (AvailabilityGuard)defaultContext.dependencies().resolveDependency(DatabaseAvailabilityGuard.class);
        defaultGuard.require(outerSpaceRequirement);
        Assertions.assertFalse((boolean)compositeGuard.isAvailable());
        defaultGuard.fulfill(outerSpaceRequirement);
        Assertions.assertTrue((boolean)compositeGuard.isAvailable());
    }

    @Test
    void stoppedDatabaseIsNotAvailable() {
        DependencyResolver dependencyResolver = this.database.getDependencyResolver();
        DatabaseContextProvider<?> databaseContextProvider = DatabaseAvailabilityIT.getDatabaseManager(dependencyResolver);
        DatabaseContext databaseContext = (DatabaseContext)databaseContextProvider.getDatabaseContext(this.defaultNamedDatabaseId).get();
        databaseContext.database().stop();
        Assertions.assertThrows(DatabaseShutdownException.class, () -> this.database.beginTx());
    }

    @Test
    void notConfusingMessageOnDatabaseNonAvailability() {
        DependencyResolver dependencyResolver = this.database.getDependencyResolver();
        DatabaseContextProvider<?> databaseContextProvider = DatabaseAvailabilityIT.getDatabaseManager(dependencyResolver);
        DatabaseContext databaseContext = (DatabaseContext)databaseContextProvider.getDatabaseContext(this.defaultNamedDatabaseId).get();
        DatabaseAvailability databaseAvailability = (DatabaseAvailability)databaseContext.database().getDependencyResolver().resolveDependency(DatabaseAvailability.class);
        databaseAvailability.stop();
        TransactionFailureException exception = (TransactionFailureException)Assertions.assertThrows(TransactionFailureException.class, () -> this.database.beginTx());
        Assertions.assertEquals((Object)"Timeout waiting for database to become available and allow new transactions. Waited 1s. 1 reasons for blocking: Database unavailable.", (Object)exception.getMessage());
    }

    @Test
    void restartedDatabaseIsAvailable() {
        DependencyResolver dependencyResolver = this.database.getDependencyResolver();
        DatabaseContextProvider<?> databaseContextProvider = DatabaseAvailabilityIT.getDatabaseManager(dependencyResolver);
        DatabaseContext databaseContext = (DatabaseContext)databaseContextProvider.getDatabaseContext(this.defaultNamedDatabaseId).get();
        AbstractDatabase database = databaseContext.database();
        this.executeTransactionOnDefaultDatabase();
        database.stop();
        Assertions.assertThrows(DatabaseShutdownException.class, () -> this.database.beginTx());
        database.start();
        this.executeTransactionOnDefaultDatabase();
    }

    private void executeTransactionOnDefaultDatabase() {
        try (Transaction transaction = this.database.beginTx();){
            transaction.commit();
        }
    }

    private static DatabaseContextProvider<?> getDatabaseManager(DependencyResolver dependencyResolver) {
        return (DatabaseContextProvider)dependencyResolver.resolveDependency(DatabaseContextProvider.class);
    }
}

