/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.buffer.IOBufferFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;

@ResourceLock(value="sharedContext")
public abstract class PageCacheTestSupport<T extends PageCache> {
    protected static ExecutorService executor;
    protected long SHORT_TIMEOUT_MILLIS = 30000L;
    protected long SEMI_LONG_TIMEOUT_MILLIS = 120000L;
    protected long LONG_TIMEOUT_MILLIS = 360000L;
    protected int recordSize = 9;
    protected int maxPages = 40;
    protected int pageCachePageSize;
    protected int pageCachePayloadSize;
    protected int reservedBytes;
    protected boolean multiVersioned;
    protected int recordsPerFilePage;
    protected int recordCount;
    protected int filePageSize;
    protected int filePayloadSize;
    protected ByteBuffer bufA;
    protected FileSystemAbstraction fs;
    protected JobScheduler jobScheduler;
    protected T pageCache;
    private Fixture<T> fixture;

    @BeforeAll
    public static void startExecutor() {
        executor = Executors.newCachedThreadPool();
    }

    @AfterAll
    public static void stopExecutor() {
        executor.shutdown();
    }

    protected abstract Fixture<T> createFixture();

    protected boolean isMultiVersioned() {
        return false;
    }

    @BeforeEach
    public void setUp() throws IOException {
        this.fixture = this.createFixture();
        this.multiVersioned = this.isMultiVersioned();
        this.reservedBytes = this.isMultiVersioned() ? this.fixture.getReservedBytes() : 0;
        Thread.interrupted();
        this.fs = this.createFileSystemAbstraction();
        this.jobScheduler = new ThreadPoolJobScheduler();
        this.ensureExists(this.file("a"));
    }

    @AfterEach
    public void tearDown() throws Exception {
        Thread.interrupted();
        if (this.pageCache != null) {
            this.tearDownPageCache(this.pageCache);
        }
        this.jobScheduler.close();
        this.fs.close();
    }

    protected final T createPageCache(PageSwapperFactory swapperFactory, int maxPages, PageCacheTracer tracer) {
        T pageCache = this.fixture.createPageCache(swapperFactory, maxPages, tracer, this.jobScheduler, this.fixture.getBufferFactory());
        this.pageCachePageSize = pageCache.pageSize();
        this.pageCachePayloadSize = pageCache.pageSize() - this.reservedBytes;
        this.recordsPerFilePage = this.pageCachePayloadSize / this.recordSize;
        this.recordCount = 5 * maxPages * this.recordsPerFilePage;
        this.filePayloadSize = this.recordsPerFilePage * this.recordSize;
        this.filePageSize = this.filePayloadSize + this.reservedBytes;
        this.bufA = ByteBuffers.allocate((int)this.recordSize, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        return pageCache;
    }

    protected T createPageCache(FileSystemAbstraction fs, int maxPages, PageCacheTracer tracer) {
        SingleFilePageSwapperFactory swapperFactory = this.createDefaultPageSwapperFactory(fs, tracer);
        return this.createPageCache((PageSwapperFactory)swapperFactory, maxPages, tracer);
    }

    protected SingleFilePageSwapperFactory createDefaultPageSwapperFactory(FileSystemAbstraction fs, PageCacheTracer tracer) {
        return new SingleFilePageSwapperFactory(fs, tracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    protected final T getPageCache(FileSystemAbstraction fs, int maxPages, PageCacheTracer tracer) {
        if (this.pageCache != null) {
            this.tearDownPageCache(this.pageCache);
        }
        this.pageCache = this.createPageCache(fs, maxPages, tracer);
        return this.pageCache;
    }

    protected void configureStandardPageCache() {
        this.getPageCache(this.fs, this.maxPages, PageCacheTracer.NULL);
    }

    protected final void tearDownPageCache(T pageCache) {
        this.fixture.tearDownPageCache(pageCache);
    }

    protected final FileSystemAbstraction createFileSystemAbstraction() {
        return this.fixture.getFileSystemAbstraction();
    }

    protected final Path file(String pathname) throws IOException {
        return this.fixture.file(pathname);
    }

    protected final Path path() throws IOException {
        return this.fixture.file("a").getParent();
    }

    protected void ensureExists(Path file) throws IOException {
        this.fs.mkdirs(file.getParent());
        this.fs.write(file).close();
    }

    protected Path existingFile(String name) throws IOException {
        Path file = this.file(name);
        this.ensureExists(file);
        return file;
    }

    protected void verifyRecordsMatchExpected(PageCursor cursor) throws IOException {
        this.verifyRecordsMatchExpected(cursor, this.recordsPerFilePage, 0);
    }

    protected void verifyRecordsMatchExpected(PageCursor cursor, int recordToCheck, int startingOffset) throws IOException {
        ByteBuffer expectedPageContents = ByteBuffers.allocate((int)this.filePageSize, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ByteBuffer actualPageContents = ByteBuffers.allocate((int)this.filePageSize, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        byte[] recordBytesPart = new byte[this.recordSize - 4];
        long pageId = cursor.getCurrentPageId();
        for (int i = 0; i < recordToCheck; ++i) {
            int recordInPart;
            long recordId = pageId * (long)recordToCheck + (long)i;
            expectedPageContents.position(startingOffset + this.recordSize * i);
            ByteBuffer slice = expectedPageContents.slice().order(ByteOrder.LITTLE_ENDIAN);
            slice.limit(this.recordSize);
            PageCacheTestSupport.generateRecordForId(recordId, slice);
            do {
                cursor.setOffset(startingOffset + this.recordSize * i);
                recordInPart = cursor.getInt();
                cursor.getBytes(recordBytesPart);
            } while (cursor.shouldRetry());
            actualPageContents.position(startingOffset + this.recordSize * i);
            actualPageContents.putInt(recordInPart);
            actualPageContents.put(recordBytesPart);
        }
        PageCacheTestSupport.assertRecords(pageId, actualPageContents, expectedPageContents);
    }

    protected void verifyRecordsMatchExpected(long pageId, int offset, ByteBuffer actualPageContents) {
        ByteBuffer expectedPageContents = ByteBuffers.allocate((int)this.filePayloadSize, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        for (int i = 0; i < this.recordsPerFilePage; ++i) {
            long recordId = pageId * (long)this.recordsPerFilePage + (long)i;
            expectedPageContents.position(this.recordSize * i);
            ByteBuffer slice = expectedPageContents.slice().order(ByteOrder.LITTLE_ENDIAN);
            slice.limit(this.recordSize);
            PageCacheTestSupport.generateRecordForId(recordId, slice);
        }
        int len = actualPageContents.limit() - actualPageContents.position();
        byte[] actual = new byte[len];
        byte[] expected = new byte[len];
        actualPageContents.get(actual);
        expectedPageContents.position(offset);
        expectedPageContents.get(expected);
        PageCacheTestSupport.assertRecords(pageId, actual, expected);
    }

    protected static void assertRecords(long pageId, ByteBuffer actualPageContents, ByteBuffer expectedPageContents) {
        byte[] actualBytes = actualPageContents.array();
        byte[] expectedBytes = expectedPageContents.array();
        PageCacheTestSupport.assertRecords(pageId, actualBytes, expectedBytes);
    }

    protected static void assertRecords(long pageId, byte[] actualBytes, byte[] expectedBytes) {
        int estimatedPageId = PageCacheTestSupport.estimateId(actualBytes);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])actualBytes).as("Page id: " + pageId + " (based on record data, it should have been " + estimatedPageId + ", a difference of " + Math.abs(pageId - (long)estimatedPageId) + ")", new Object[0])).containsExactly(expectedBytes);
    }

    protected static int estimateId(byte[] record) {
        return ByteBuffer.wrap(record).getInt() - 1;
    }

    protected void writeRecords(PageCursor cursor) {
        cursor.setOffset(0);
        for (int i = 0; i < this.recordsPerFilePage; ++i) {
            long recordId = cursor.getCurrentPageId() * (long)this.recordsPerFilePage + (long)i;
            PageCacheTestSupport.generateRecordForId(recordId, this.bufA);
            cursor.putBytes(this.bufA.array());
        }
    }

    protected void generateFileWithRecords(Path file, int recordCount, int recordSize, int recordsPerFilePage, int reservedBytes, int pageSize) throws IOException {
        try (StoreChannel channel = this.fs.write(file);){
            PageCacheTestSupport.generateFileWithRecords(channel, recordCount, recordSize, recordsPerFilePage, reservedBytes, pageSize);
        }
    }

    protected static void generateFileWithRecords(StoreChannel channel, int recordCount, int recordSize, int recordsPerFilePage, int reservedBytes, int pageSize) throws IOException {
        ByteBuffer buf = ByteBuffers.allocate((int)recordSize, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        for (int i = 0; i < recordCount; ++i) {
            if (i % recordsPerFilePage == 0) {
                long position = channel.position();
                if (position % (long)pageSize != 0L) {
                    PageCacheTestSupport.writeBuffer((WritableByteChannel)channel, ByteBuffer.allocate((int)((long)pageSize - position % (long)pageSize)));
                }
                PageCacheTestSupport.writeBuffer((WritableByteChannel)channel, ByteBuffer.allocate(reservedBytes));
            }
            PageCacheTestSupport.generateRecordForId(i, buf);
            PageCacheTestSupport.writeBuffer((WritableByteChannel)channel, buf);
        }
    }

    private static void writeBuffer(WritableByteChannel channel, ByteBuffer buf) throws IOException {
        int rem = buf.remaining();
        while ((rem -= channel.write(buf)) > 0) {
        }
    }

    protected static void generateRecordForId(long id, ByteBuffer buf) {
        buf.position(0);
        int x = (int)(id + 1L);
        buf.putInt(x);
        while (buf.position() < buf.limit()) {
            buf.put((byte)(++x & 0xFF));
        }
        buf.position(0);
    }

    protected void verifyRecordsInFile(Path file, int recordCount) throws IOException {
        try (StoreChannel channel = this.fs.read(file);){
            this.verifyRecordsInFile(channel, recordCount);
        }
    }

    protected void verifyRecordsInFile(StoreChannel channel, int recordCount) throws IOException {
        ByteBuffer buf = ByteBuffers.allocate((int)this.recordSize, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ByteBuffer observation = ByteBuffers.allocate((int)this.recordSize, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        for (int i = 0; i < recordCount; ++i) {
            if (i % this.recordsPerFilePage == 0) {
                channel.position(channel.position() + (long)this.reservedBytes);
            }
            PageCacheTestSupport.generateRecordForId(i, buf);
            observation.position(0);
            channel.read(observation);
            PageCacheTestSupport.assertRecords((long)i, observation, buf);
        }
    }

    protected static Runnable closePageFile(PagedFile file) {
        return () -> ((PagedFile)file).close();
    }

    public static abstract class Fixture<T extends PageCache> {
        private Supplier<FileSystemAbstraction> fileSystemAbstractionSupplier = EphemeralFileSystemAbstraction::new;
        private Function<String, Path> fileConstructor = x$0 -> Path.of(x$0, new String[0]);
        private IOBufferFactory bufferFactory;
        private int reservedBytes = 24;

        public abstract T createPageCache(PageSwapperFactory var1, int var2, PageCacheTracer var3, JobScheduler var4, IOBufferFactory var5);

        public abstract void tearDownPageCache(T var1);

        public final FileSystemAbstraction getFileSystemAbstraction() {
            return this.fileSystemAbstractionSupplier.get();
        }

        public IOBufferFactory getBufferFactory() {
            return this.bufferFactory;
        }

        public int getReservedBytes() {
            return this.reservedBytes;
        }

        public final Fixture<T> withFileSystemAbstraction(Supplier<FileSystemAbstraction> fileSystemAbstractionSupplier) {
            this.fileSystemAbstractionSupplier = fileSystemAbstractionSupplier;
            return this;
        }

        public final Path file(String pathname) {
            return this.fileConstructor.apply(pathname).toAbsolutePath().normalize();
        }

        public final Fixture<T> withBufferFactory(IOBufferFactory bufferFactory) {
            this.bufferFactory = bufferFactory;
            return this;
        }

        public final Fixture<T> withReservedBytes(int reservedBytes) {
            this.reservedBytes = reservedBytes;
            return this;
        }

        public final Fixture<T> withFileConstructor(Function<String, Path> fileConstructor) {
            this.fileConstructor = fileConstructor;
            return this;
        }
    }
}

