/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.ChecksumMismatchException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.PageCacheTestSupport;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCacheFixture;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;

public class MuninnPageCacheChecksumIT
extends PageCacheTestSupport<MuninnPageCache> {
    public static final ImmutableSet<OpenOption> OPEN_OPTIONS = Sets.immutable.of((Object)PageCacheOpenOptions.MULTI_VERSIONED);
    private final DefaultPageCacheTracer tracer = new DefaultPageCacheTracer();
    private final CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)this.tracer, EmptyVersionContextSupplier.EMPTY);
    private final AtomicBoolean checksumPagesFlag = new AtomicBoolean(true);

    @Override
    protected PageCacheTestSupport.Fixture<MuninnPageCache> createFixture() {
        return new MuninnPageCacheFixture();
    }

    @Test
    void checksumMultiVersionedPages() throws IOException {
        try (MuninnPageCache pageCache = this.createPageCache(this.fs, 1024, (PageCacheTracer)this.tracer);){
            CursorContext context;
            try (PagedFile pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());){
                context = this.contextFactory.create("checksumMultiVersionedPages");
                try (PageCursor mutator = pageFile.io(0L, 2, context);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)mutator.next());
                    mutator.putInt(10);
                }
                finally {
                    if (context != null) {
                        context.close();
                    }
                }
            }
            pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());
            try {
                context = this.contextFactory.create("checksumMultiVersionedPages");
                try (MuninnPageCursor reader = (MuninnPageCursor)pageFile.io(0L, 1, context);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                    org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)reader.getInt());
                    long pageChecksum = reader.getPageChecksum();
                    Assertions.assertThat((long)pageChecksum).isNotEqualTo(0L);
                }
                finally {
                    if (context != null) {
                        context.close();
                    }
                }
            }
            finally {
                if (pageFile != null) {
                    pageFile.close();
                }
            }
        }
    }

    @Test
    void anyByteChangeInfluencesChecksum() throws IOException {
        try (MuninnPageCache pageCache = this.createPageCache(this.fs, 1024, (PageCacheTracer)this.tracer);){
            long previousChecksum = 0L;
            int payloadSize = pageCache.pageSize() - pageCache.pageReservedBytes(OPEN_OPTIONS);
            for (int offset = 0; offset < payloadSize; ++offset) {
                CursorContext context;
                try (PagedFile pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());){
                    context = this.contextFactory.create("anyByteChangeInfluencesChecksum");
                    try (PageCursor mutator = pageFile.io(0L, 2, context);){
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)mutator.next());
                        mutator.putByte(offset, (byte)1);
                    }
                    finally {
                        if (context != null) {
                            context.close();
                        }
                    }
                }
                pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());
                try {
                    context = this.contextFactory.create("anyByteChangeInfluencesChecksum");
                    try (MuninnPageCursor reader = (MuninnPageCursor)pageFile.io(0L, 1, context);){
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)reader.getByte(offset));
                        long pageChecksum = reader.getPageChecksum();
                        Assertions.assertThat((long)pageChecksum).isNotEqualTo(0L).isNotEqualTo(previousChecksum);
                        previousChecksum = pageChecksum;
                        continue;
                    }
                    finally {
                        if (context != null) {
                            context.close();
                        }
                    }
                }
                finally {
                    if (pageFile != null) {
                        pageFile.close();
                    }
                }
            }
        }
    }

    @Test
    void pageChecksumIsNotChangedByReaders() throws IOException {
        try (MuninnPageCache pageCache = this.createPageCache(this.fs, 1024, (PageCacheTracer)this.tracer);){
            try (PagedFile pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());
                 CursorContext context = this.contextFactory.create("pageChecksumIsNotChangedByReaders");
                 PageCursor mutator = pageFile.io(0L, 2, context);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)mutator.next());
                mutator.putInt(10);
            }
            long checksum = 0L;
            for (int i = 0; i < 1024; ++i) {
                try (PagedFile pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());
                     CursorContext context = this.contextFactory.create("pageChecksumIsNotChangedByReaders");
                     MuninnPageCursor reader = (MuninnPageCursor)pageFile.io(0L, 1, context);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                    org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)reader.getInt());
                    long pageChecksum = reader.getPageChecksum();
                    if (checksum == 0L) {
                        checksum = pageChecksum;
                    }
                    Assertions.assertThat((long)pageChecksum).isNotEqualTo(0L).isEqualTo(checksum);
                    continue;
                }
            }
        }
    }

    @Test
    void failToReadPageWithBrokenChecksum() throws IOException {
        try (MuninnPageCache pageCache = this.createPageCache(this.fs, 1024, (PageCacheTracer)this.tracer);){
            MuninnPageCursor reader;
            PageCursor mutator;
            CursorContext context;
            try (PagedFile pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());){
                context = this.contextFactory.create("failToReadPageWithBrokenChecksum");
                try {
                    mutator = pageFile.io(0L, 2, context);
                    try {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)mutator.next());
                        mutator.putInt(10);
                    }
                    finally {
                        if (mutator != null) {
                            mutator.close();
                        }
                    }
                }
                finally {
                    if (context != null) {
                        context.close();
                    }
                }
            }
            pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());
            try {
                context = this.contextFactory.create("failToReadPageWithBrokenChecksum");
                try {
                    reader = (MuninnPageCursor)pageFile.io(0L, 1, context);
                    try {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)reader.getInt());
                        long pageChecksum = reader.getPageChecksum();
                        Assertions.assertThat((long)pageChecksum).isNotEqualTo(0L);
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                finally {
                    if (context != null) {
                        context.close();
                    }
                }
            }
            finally {
                if (pageFile != null) {
                    pageFile.close();
                }
            }
            this.checksumPagesFlag.set(false);
            pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());
            try {
                context = this.contextFactory.create("failToReadPageWithBrokenChecksum");
                try {
                    mutator = pageFile.io(0L, 2, context);
                    try {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)mutator.next());
                        mutator.putInt(20);
                    }
                    finally {
                        if (mutator != null) {
                            mutator.close();
                        }
                    }
                }
                finally {
                    if (context != null) {
                        context.close();
                    }
                }
            }
            finally {
                if (pageFile != null) {
                    pageFile.close();
                }
            }
            this.checksumPagesFlag.set(true);
            pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());
            try {
                context = this.contextFactory.create("failToReadPageWithBrokenChecksum");
                try {
                    reader = (MuninnPageCursor)pageFile.io(0L, 1, context);
                    try {
                        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next()));
                        Assertions.assertThat((Throwable)e).isInstanceOf(ChecksumMismatchException.class);
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                finally {
                    if (context != null) {
                        context.close();
                    }
                }
            }
            finally {
                if (pageFile != null) {
                    pageFile.close();
                }
            }
        }
    }

    @Test
    void neverWrittenPagesHaveZeroChecksum() throws IOException {
        try (MuninnPageCache pageCache = this.createPageCache(this.fs, 1024, (PageCacheTracer)this.tracer);){
            long pageChecksum;
            MuninnPageCursor reader;
            CursorContext context;
            try (PagedFile pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());){
                context = this.contextFactory.create("neverWrittenPagesHaveZeroChecksum");
                try (PageCursor mutator = pageFile.io(10L, 2, context);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)mutator.next());
                    mutator.putInt(10);
                }
                finally {
                    if (context != null) {
                        context.close();
                    }
                }
            }
            pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());
            try {
                context = this.contextFactory.create("neverWrittenPagesHaveZeroChecksum");
                try {
                    reader = (MuninnPageCursor)pageFile.io(0L, 1, context);
                    try {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)reader.getInt());
                        pageChecksum = reader.getPageChecksum();
                        Assertions.assertThat((long)pageChecksum).isEqualTo(0L);
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                finally {
                    if (context != null) {
                        context.close();
                    }
                }
            }
            finally {
                if (pageFile != null) {
                    pageFile.close();
                }
            }
            pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());
            try {
                context = this.contextFactory.create("neverWrittenPagesHaveZeroChecksum");
                try {
                    reader = (MuninnPageCursor)pageFile.io(10L, 1, context);
                    try {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)reader.getInt());
                        pageChecksum = reader.getPageChecksum();
                        Assertions.assertThat((long)pageChecksum).isNotEqualTo(0L);
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                finally {
                    if (context != null) {
                        context.close();
                    }
                }
            }
            finally {
                if (pageFile != null) {
                    pageFile.close();
                }
            }
        }
    }

    @Test
    void fileFlushUpdatingPageChecksums() throws IOException {
        try (MuninnPageCache pageCache = this.createPageCache(this.fs, 1024, (PageCacheTracer)this.tracer);){
            int i;
            CursorContext context;
            try (PagedFile pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());){
                context = this.contextFactory.create("fileFlushUpdatingPageChecksums");
                try {
                    for (i = 0; i < 1000; ++i) {
                        try (PageCursor mutator = pageFile.io((long)i, 2, context);){
                            org.junit.jupiter.api.Assertions.assertTrue((boolean)mutator.next());
                            mutator.putInt(i);
                            continue;
                        }
                    }
                    pageFile.flushAndForce(FileFlushEvent.NULL);
                }
                finally {
                    if (context != null) {
                        context.close();
                    }
                }
            }
            pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());
            try {
                context = this.contextFactory.create("fileFlushUpdatingPageChecksums");
                try {
                    for (i = 0; i < 1000; ++i) {
                        try (MuninnPageCursor reader = (MuninnPageCursor)pageFile.io((long)i, 1, context);){
                            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)reader.getInt());
                            Assertions.assertThat((long)reader.getPageChecksum()).isNotEqualTo(0L);
                            continue;
                        }
                    }
                }
                finally {
                    if (context != null) {
                        context.close();
                    }
                }
            }
            finally {
                if (pageFile != null) {
                    pageFile.close();
                }
            }
        }
    }

    @Test
    void fileSwapInOutUpdatingPageChecksums() throws IOException {
        try (MuninnPageCache pageCache = this.createPageCache(this.fs, 10, (PageCacheTracer)this.tracer);){
            int i;
            CursorContext context;
            try (PagedFile pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());){
                context = this.contextFactory.create("fileSwapInOutUpdatingPageChecksums");
                try {
                    for (i = 0; i < 1000; ++i) {
                        try (PageCursor mutator = pageFile.io((long)i, 2, context);){
                            org.junit.jupiter.api.Assertions.assertTrue((boolean)mutator.next());
                            mutator.putInt(i);
                            continue;
                        }
                    }
                }
                finally {
                    if (context != null) {
                        context.close();
                    }
                }
            }
            pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());
            try {
                context = this.contextFactory.create("fileSwapInOutUpdatingPageChecksums");
                try {
                    for (i = 0; i < 1000; ++i) {
                        try (MuninnPageCursor reader = (MuninnPageCursor)pageFile.io((long)i, 1, context);){
                            org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                            org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)reader.getInt());
                            Assertions.assertThat((long)reader.getPageChecksum()).isNotEqualTo(0L);
                            continue;
                        }
                    }
                }
                finally {
                    if (context != null) {
                        context.close();
                    }
                }
            }
            finally {
                if (pageFile != null) {
                    pageFile.close();
                }
            }
        }
    }

    @Override
    protected MuninnPageCache createPageCache(FileSystemAbstraction fs, int maxPages, PageCacheTracer tracer) {
        SingleFilePageSwapperFactory swapperFactory = this.createDefaultPageSwapperFactory(fs, tracer);
        PageSwapperFactory pageSwapperFactory = (path, filePageSize, reservedPageBytes, onEviction, createIfNotExist, useDirectIO, checksumPages, ioController, swappers) -> swapperFactory.createPageSwapper(path, filePageSize, reservedPageBytes, onEviction, createIfNotExist, useDirectIO, this.checksumPagesFlag.get(), ioController, swappers);
        return (MuninnPageCache)super.createPageCache(pageSwapperFactory, maxPages, tracer);
    }

    private PagedFile map(PageCache pageCache, Path file, int filePageSize) throws IOException {
        return pageCache.map(file, filePageSize, "neo4j", OPEN_OPTIONS);
    }
}

