/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;

@Neo4jLayoutExtension
class MuninnPageCacheExplicitPreallocateTest {
    private static final int PAGE_CACHE_CHUNK_SIZE = 4096;
    private JobScheduler jobScheduler;
    private final PageSwapper swapper = (PageSwapper)Mockito.mock(PageSwapper.class);
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private Neo4jLayout neo4jLayout;

    MuninnPageCacheExplicitPreallocateTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.jobScheduler = new ThreadPoolJobScheduler();
        Mockito.when((Object)this.swapper.canAllocate()).thenReturn((Object)true);
    }

    @AfterEach
    void afterEach() throws Exception {
        this.jobScheduler.close();
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void testPreAllocationSupport(boolean automaticPreAllocation) throws IOException {
        try (MuninnPageCache pageCache = this.createPageCache(automaticPreAllocation);
             PagedFile pageFile = this.mapFile((PageCache)pageCache);){
            Assertions.assertTrue((boolean)pageFile.preAllocateSupported());
            Mockito.when((Object)this.swapper.canAllocate()).thenReturn((Object)false);
            Assertions.assertFalse((boolean)pageFile.preAllocateSupported());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void testSmallPreAllocation(boolean automaticPreAllocation) throws IOException {
        try (MuninnPageCache pageCache = this.createPageCache(automaticPreAllocation);
             PagedFile pageFile = this.mapFile((PageCache)pageCache);){
            pageFile.preAllocate(2L);
            pageFile.preAllocate(3L);
            pageFile.preAllocate(7L);
            ((PageSwapper)Mockito.verify((Object)this.swapper)).allocate((long)(pageFile.pageSize() * 2));
            ((PageSwapper)Mockito.verify((Object)this.swapper)).allocate((long)(pageFile.pageSize() * 3));
            ((PageSwapper)Mockito.verify((Object)this.swapper)).allocate((long)(pageFile.pageSize() * 7));
        }
    }

    @Test
    void testLargeExplicitPreAllocationWithAutomaticPreAllocation() throws IOException {
        try (MuninnPageCache pageCache = this.createPageCache(true);
             PagedFile pageFile = this.mapFile((PageCache)pageCache);){
            pageFile.preAllocate(4219L);
            pageFile.preAllocate(5330L);
            pageFile.preAllocate(8199L);
            ((PageSwapper)Mockito.verify((Object)this.swapper)).allocate((long)(pageFile.pageSize() * 8192));
            ((PageSwapper)Mockito.verify((Object)this.swapper)).allocate((long)(pageFile.pageSize() * 12288));
        }
    }

    @Test
    void testLargeExplicitPreAllocationWithoutAutomaticPreAllocation() throws IOException {
        try (MuninnPageCache pageCache = this.createPageCache(false);
             PagedFile pageFile = this.mapFile((PageCache)pageCache);){
            pageFile.preAllocate(4219L);
            pageFile.preAllocate(5330L);
            ((PageSwapper)Mockito.verify((Object)this.swapper)).allocate((long)(pageFile.pageSize() * 4219));
            ((PageSwapper)Mockito.verify((Object)this.swapper)).allocate((long)(pageFile.pageSize() * 5330));
        }
    }

    private PagedFile mapFile(PageCache pageCache) throws IOException {
        return pageCache.map(this.neo4jLayout.databasesDirectory().resolve("a"), pageCache.pageSize(), "neo4j");
    }

    private MuninnPageCache createPageCache(boolean automaticPreAllocation) {
        long memory = MuninnPageCache.memoryRequiredForPages((long)1024L);
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        MemoryAllocator allocator = MemoryAllocator.createAllocator((long)memory, (MemoryTracker)memoryTracker);
        MuninnPageCache.Configuration configuration = MuninnPageCache.config((MemoryAllocator)allocator).preallocateStoreFiles(automaticPreAllocation);
        PageSwapperFactory pageSwapperFactory = (path, filePageSize, reservedPageBytes, onEviction, createIfNotExist, useDirectIO, checksumPages, ioController, swappers) -> {
            Mockito.when((Object)this.swapper.swapperId()).thenReturn((Object)swappers.allocate(this.swapper));
            return this.swapper;
        };
        return new MuninnPageCache(pageSwapperFactory, this.jobScheduler, configuration);
    }
}

