/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.nio.file.OpenOption;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.Test;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.monitoring.PageCacheCounters;
import org.neo4j.io.pagecache.stress.Condition;
import org.neo4j.io.pagecache.stress.Conditions;
import org.neo4j.io.pagecache.stress.PageCacheStressTest;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class MuninnPageCacheStressIT {
    @Inject
    TestDirectory testDirectory;

    MuninnPageCacheStressIT() {
    }

    @Test
    void shouldHandleTheStressOfManyManyEvictions() throws Exception {
        this.runTest((ImmutableSet<OpenOption>)Sets.immutable.empty());
    }

    @Test
    void shouldHandleTheStressOfManyManyEvictionsMultiversion() throws Exception {
        this.runTest((ImmutableSet<OpenOption>)Sets.immutable.of((Object)PageCacheOpenOptions.MULTI_VERSIONED));
    }

    private void runTest(ImmutableSet<OpenOption> openOptions) throws Exception {
        DefaultPageCacheTracer monitor = new DefaultPageCacheTracer();
        Condition condition = Conditions.numberOfEvictions((PageCacheCounters)monitor, (long)100000L);
        PageCacheStressTest runner = new PageCacheStressTest.Builder().withWorkingDirectory(this.testDirectory.homePath()).with((PageCacheTracer)monitor).with(condition).with(openOptions).build();
        runner.run();
    }
}

