/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntSupplier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.pagecache.ConfigurableIOBufferFactory;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DelegatingFileSystemAbstraction;
import org.neo4j.io.fs.DelegatingStoreChannel;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.pagecache.DelegatingPageSwapper;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.PageCacheTest;
import org.neo4j.io.pagecache.PageCacheTestSupport;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.buffer.IOBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.context.OldestTransactionIdFactory;
import org.neo4j.io.pagecache.context.TransactionIdSnapshotFactory;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.io.pagecache.context.VersionContextSupplier;
import org.neo4j.io.pagecache.impl.FileIsNotMappedException;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.CacheLiveLockException;
import org.neo4j.io.pagecache.impl.muninn.LatchMap;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCacheFixture;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile;
import org.neo4j.io.pagecache.impl.muninn.PageList;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.DelegatingPageCacheTracer;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionEventOpportunity;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.PageReferenceTranslator;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.io.pagecache.tracing.PinPageFaultEvent;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.recording.RecordingPageCacheTracer;
import org.neo4j.io.pagecache.tracing.recording.RecordingPageCursorTracer;
import org.neo4j.io.pagecache.tracing.version.FileTruncateEvent;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryTracker;
import org.neo4j.test.Race;
import org.neo4j.test.assertion.Assert;

public class MuninnPageCacheTest
extends PageCacheTest<MuninnPageCache> {
    private static final long X = -3819410105021120785L;
    private static final long Y = -2392823106362282833L;
    private MuninnPageCacheFixture fixture;

    @Override
    protected PageCacheTestSupport.Fixture<MuninnPageCache> createFixture() {
        ConfigurableIOBufferFactory bufferFactory = new ConfigurableIOBufferFactory(Config.defaults((Setting)GraphDatabaseSettings.pagecache_buffered_flush_enabled, (Object)true), (MemoryTracker)new ScopedMemoryTracker((MemoryTracker)EmptyMemoryTracker.INSTANCE));
        this.fixture = new MuninnPageCacheFixture();
        this.fixture.withBufferFactory((IOBufferFactory)bufferFactory);
        return this.fixture;
    }

    private PageCacheTracer blockCacheFlush(PageCacheTracer delegate) {
        this.fixture.backgroundFlushLatch = new CountDownLatch(1);
        return new DelegatingPageCacheTracer(delegate){

            @Override
            public FileFlushEvent beginFileFlush() {
                try {
                    MuninnPageCacheTest.this.fixture.backgroundFlushLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return super.beginFileFlush();
            }
        };
    }

    @Test
    void payloadSizeEqualsPageSizePlusReservedBytes() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());
             PagedFile pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());){
            org.junit.jupiter.api.Assertions.assertEquals((int)pageFile.pageSize(), (int)(pageFile.payloadSize() + pageFile.pageReservedBytes()));
        }
    }

    @Test
    void payloadSizeForCacheWithCustomConfiguration() throws IOException {
        int reservedBytes = 24;
        MuninnPageCacheFixture customFixture = new MuninnPageCacheFixture();
        customFixture.withReservedBytes(reservedBytes);
        PageCacheTracer cacheTracer = PageCacheTracer.NULL;
        try (MuninnPageCache pageCache = customFixture.createPageCache((PageSwapperFactory)new SingleFilePageSwapperFactory(this.fs, cacheTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE), 10, cacheTracer, this.jobScheduler, IOBufferFactory.DISABLED_BUFFER_FACTORY);
             PagedFile pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize(), (ImmutableSet<OpenOption>)Sets.immutable.of((Object)PageCacheOpenOptions.MULTI_VERSIONED));){
            org.junit.jupiter.api.Assertions.assertEquals((int)reservedBytes, (int)pageFile.pageReservedBytes());
            org.junit.jupiter.api.Assertions.assertEquals((int)8192, (int)pageFile.pageSize());
            org.junit.jupiter.api.Assertions.assertEquals((int)(8192 - reservedBytes), (int)pageFile.payloadSize());
            org.junit.jupiter.api.Assertions.assertEquals((int)reservedBytes, (int)(pageFile.pageSize() - pageFile.payloadSize()));
        }
    }

    @Test
    void writeUntilPayloadDoesNotCauseOverflow() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());
             PagedFile pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());
             PageCursor pageCursor = pageFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
            org.junit.jupiter.api.Assertions.assertTrue((boolean)pageCursor.next());
            for (int i = 0; i < pageFile.payloadSize(); ++i) {
                pageCursor.putByte((byte)1);
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void readWriteUninitialisedPage() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());
             PagedFile pageFile = this.map((PageCache)pageCache, this.file("a"), pageCache.pageSize());){
            int i;
            try (PageCursor reader = pageFile.io(0L, 1, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertFalse((boolean)reader.next());
            }
            reader = pageFile.io(10L, 1, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertFalse((boolean)reader.next());
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            try (PageCursor mutator = pageFile.io(20L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)mutator.next());
                for (i = 0; i < pageFile.payloadSize(); ++i) {
                    mutator.putByte((byte)1);
                }
            }
            reader = pageFile.io(0L, 1, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                for (i = 0; i < pageFile.payloadSize(); ++i) {
                    org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)reader.getByte());
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = pageFile.io(10L, 1, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                for (i = 0; i < pageFile.payloadSize(); ++i) {
                    org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)reader.getByte());
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    @Test
    void reusePagesOverPageListOnFileTruncation() throws IOException {
        int pageCachePages = 20;
        int pagesToKeep = 5;
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, pageCachePages, (PageCacheTracer)new DefaultPageCacheTracer());){
            Path file = this.file("a");
            try (PagedFile pf = this.map((PageCache)pageCache, file, this.filePageSize);){
                for (int i = 0; i < 10; ++i) {
                    try (PageCursor cursor = pf.io((long)i, 2, CursorContext.NULL_CONTEXT);){
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                        cursor.putLong((long)i);
                        continue;
                    }
                }
                for (int iteration = 0; iteration < 10; ++iteration) {
                    pf.truncate((long)pagesToKeep, FileTruncateEvent.NULL);
                    org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)pageCache.tryGetNumberOfPagesToEvict(pageCachePages));
                    for (int i = 0; i < 5; ++i) {
                        try (PageCursor cursor = pf.io((long)(pagesToKeep + i), 2, CursorContext.NULL_CONTEXT);){
                            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                            cursor.putLong((long)i);
                        }
                        pf.flushAndForce(FileFlushEvent.NULL);
                    }
                    org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)pageCache.tryGetNumberOfPagesToEvict(pageCachePages));
                }
                org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)pageCache.tryGetNumberOfPagesToEvict(pageCachePages));
                org.junit.jupiter.api.Assertions.assertEquals((long)9L, (long)pf.getLastPageId());
                org.junit.jupiter.api.Assertions.assertEquals((long)pageCachePages, (long)pageCache.maxCachedPages());
            }
        }
    }

    @Test
    void countPagesToEvictOnEmptyPageCache() {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());){
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)pageCache.tryGetNumberOfPagesToEvict(10));
        }
    }

    @Test
    void countPagesToEvictOnAllPagesLocked() throws IOException {
        int maxPages = 1024;
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, maxPages, (PageCacheTracer)new DefaultPageCacheTracer());){
            for (int i = 0; i < maxPages; ++i) {
                pageCache.grabFreeAndExclusivelyLockedPage((PageFaultEvent)PinPageFaultEvent.NULL);
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)pageCache.tryGetNumberOfPagesToEvict(12));
        }
    }

    @Test
    void countPagesToEvictWhenLiveLocked() {
        int maxPages = 1024;
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, maxPages, (PageCacheTracer)new DefaultPageCacheTracer());){
            org.junit.jupiter.api.Assertions.assertThrows(CacheLiveLockException.class, () -> {
                for (int i = 0; i < maxPages + 1; ++i) {
                    pageCache.grabFreeAndExclusivelyLockedPage((PageFaultEvent)PinPageFaultEvent.NULL);
                }
            });
            org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)pageCache.tryGetNumberOfPagesToEvict(12));
            org.junit.jupiter.api.Assertions.assertEquals((int)1024, (int)pageCache.tryGetNumberOfPagesToEvict(1024));
        }
    }

    @Test
    void countPagesToEvictWithReleasedPages() throws IOException {
        int maxPages = 1024;
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, maxPages, (PageCacheTracer)new DefaultPageCacheTracer());){
            long pageRef = pageCache.grabFreeAndExclusivelyLockedPage((PageFaultEvent)PinPageFaultEvent.NULL);
            pageCache.addFreePageToFreelist(pageRef, EvictionRunEvent.NULL);
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)pageCache.tryGetNumberOfPagesToEvict(12));
        }
    }

    @Test
    void countPagesToEvictWithAllPagesAcquiredAndReleased() throws IOException {
        int maxPages = 1024;
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, maxPages, (PageCacheTracer)new DefaultPageCacheTracer());){
            for (int i = 0; i < maxPages; ++i) {
                long pageRef = pageCache.grabFreeAndExclusivelyLockedPage((PageFaultEvent)PinPageFaultEvent.NULL);
                pageCache.addFreePageToFreelist(pageRef, EvictionRunEvent.NULL);
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)pageCache.tryGetNumberOfPagesToEvict(12));
        }
    }

    @Test
    void countPagesToEvictWithPagesAcquiredSomeReleased() throws IOException {
        int maxPages = 1024;
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, maxPages, (PageCacheTracer)new DefaultPageCacheTracer());){
            int i;
            for (i = 0; i < maxPages - 20; ++i) {
                pageCache.grabFreeAndExclusivelyLockedPage((PageFaultEvent)PinPageFaultEvent.NULL);
            }
            for (i = maxPages - 20; i < maxPages; ++i) {
                long page = pageCache.grabFreeAndExclusivelyLockedPage((PageFaultEvent)PinPageFaultEvent.NULL);
                pageCache.addFreePageToFreelist(page, EvictionRunEvent.NULL);
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)pageCache.tryGetNumberOfPagesToEvict(12));
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)pageCache.tryGetNumberOfPagesToEvict(20));
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)pageCache.tryGetNumberOfPagesToEvict(21));
        }
    }

    @Test
    void countPagesToEvictWithPagesAcquiredOneReleasedInLoop() throws IOException {
        int maxPages = 1024;
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, maxPages, (PageCacheTracer)new DefaultPageCacheTracer());){
            int i;
            for (i = 0; i < maxPages - 5; ++i) {
                pageCache.grabFreeAndExclusivelyLockedPage((PageFaultEvent)PinPageFaultEvent.NULL);
            }
            for (i = maxPages - 5; i < maxPages; ++i) {
                long page = pageCache.grabFreeAndExclusivelyLockedPage((PageFaultEvent)PinPageFaultEvent.NULL);
                pageCache.addFreePageToFreelist(page, EvictionRunEvent.NULL);
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)7, (int)pageCache.tryGetNumberOfPagesToEvict(12));
            org.junit.jupiter.api.Assertions.assertEquals((int)(maxPages - 5), (int)pageCache.tryGetNumberOfPagesToEvict(maxPages));
        }
    }

    @Test
    void countPagesToEvictWithAllPagesAcquiredAndReleasedLater() throws IOException {
        int maxPages = 1024;
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, maxPages, (PageCacheTracer)new DefaultPageCacheTracer());){
            MutableLongList pages = LongLists.mutable.withInitialCapacity(maxPages);
            for (int i = 0; i < maxPages; ++i) {
                pages.add(pageCache.grabFreeAndExclusivelyLockedPage((PageFaultEvent)PinPageFaultEvent.NULL));
            }
            pages.forEach((LongProcedure & Serializable)page -> pageCache.addFreePageToFreelist(page, EvictionRunEvent.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)pageCache.tryGetNumberOfPagesToEvict(12));
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)pageCache.tryGetNumberOfPagesToEvict(maxPages));
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)pageCache.tryGetNumberOfPagesToEvict(maxPages + 1));
        }
    }

    @Test
    void countPagesToEvictWithAllWithExceptionPagesAcquiredAndReleased() {
        int maxPages = 1024;
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, maxPages, (PageCacheTracer)new DefaultPageCacheTracer());){
            MutableLongList pages = LongLists.mutable.withInitialCapacity(maxPages);
            org.junit.jupiter.api.Assertions.assertThrows(CacheLiveLockException.class, () -> {
                for (int i = 0; i <= maxPages; ++i) {
                    pages.add(pageCache.grabFreeAndExclusivelyLockedPage((PageFaultEvent)PinPageFaultEvent.NULL));
                }
            });
            pages.forEach((LongProcedure & Serializable)page -> pageCache.addFreePageToFreelist(page, EvictionRunEvent.NULL));
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)pageCache.tryGetNumberOfPagesToEvict(12));
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)pageCache.tryGetNumberOfPagesToEvict(maxPages));
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)pageCache.tryGetNumberOfPagesToEvict(maxPages + 1));
        }
    }

    @Test
    void reuseSwapperIdOnFileClose() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 50, (PageCacheTracer)new DefaultPageCacheTracer());){
            int swapperId = this.pagedFileSwapperId(pageCache);
            for (int i = 0; i < 10; ++i) {
                org.junit.jupiter.api.Assertions.assertEquals((int)swapperId, (int)this.pagedFileSwapperId(pageCache));
            }
        }
    }

    @Test
    void doNotReuseSwapperIdWhenThereAreOpenCursors() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 50, (PageCacheTracer)new DefaultPageCacheTracer());){
            MutableIntSet swapperIds = IntSets.mutable.empty();
            ArrayList<Object> cursorWithIds = new ArrayList<Object>();
            SwapperSet swapperSet = this.extractSwapperSet(pageCache);
            while (!swapperSet.skipSweep()) {
                CursorSwapperId cursorSwapperId = this.pagedFileCursorSwapperId(pageCache);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)swapperIds.add(cursorSwapperId.cursorId), (String)"swapper id with open cursors should not be reused");
                cursorWithIds.add(cursorSwapperId);
            }
            for (CursorSwapperId cursorSwapperId : cursorWithIds) {
                cursorSwapperId.pageCursor.close();
            }
            MutableIntSet sweeppedIds = IntSets.mutable.empty();
            swapperSet.sweep(arg_0 -> ((MutableIntSet)sweeppedIds).addAll(arg_0));
            for (CursorSwapperId cursorSwapperId : cursorWithIds) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)swapperIds.contains(cursorSwapperId.cursorId));
            }
        }
    }

    @Test
    void evaluateNumberOfPagesToKeepFree() {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, (PageCacheTracer)new DefaultPageCacheTracer());){
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)pageCache.getKeepFree());
        }
        pageCache = (MuninnPageCache)this.createPageCache(this.fs, 30, (PageCacheTracer)new DefaultPageCacheTracer());
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)15, (int)pageCache.getKeepFree());
        }
        finally {
            if (pageCache != null) {
                pageCache.close();
            }
        }
        pageCache = (MuninnPageCache)this.createPageCache(this.fs, 50, (PageCacheTracer)new DefaultPageCacheTracer());
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)25, (int)pageCache.getKeepFree());
        }
        finally {
            if (pageCache != null) {
                pageCache.close();
            }
        }
        pageCache = (MuninnPageCache)this.createPageCache(this.fs, 100, (PageCacheTracer)new DefaultPageCacheTracer());
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)30, (int)pageCache.getKeepFree());
        }
        finally {
            if (pageCache != null) {
                pageCache.close();
            }
        }
        pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10000, (PageCacheTracer)new DefaultPageCacheTracer());
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)500, (int)pageCache.getKeepFree());
        }
        finally {
            if (pageCache != null) {
                pageCache.close();
            }
        }
    }

    @Test
    void countOpenedAndClosedCursors() throws IOException {
        DefaultPageCacheTracer defaultPageCacheTracer = new DefaultPageCacheTracer();
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)defaultPageCacheTracer, EmptyVersionContextSupplier.EMPTY);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 42, (PageCacheTracer)defaultPageCacheTracer);){
            int iterations = 14;
            for (int i = 0; i < iterations; ++i) {
                this.writeInitialDataTo(this.file("a" + i), this.reservedBytes);
                try (CursorContext cursorContext = contextFactory.create("countOpenedAndClosedCursors");
                     PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a" + i), 8 + this.reservedBytes);){
                    try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                        org.junit.jupiter.api.Assertions.assertEquals((long)(i * 3 + 1), (long)defaultPageCacheTracer.openedCursors());
                        org.junit.jupiter.api.Assertions.assertEquals((long)(i * 3), (long)defaultPageCacheTracer.closedCursors());
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                        cursor.putLong(0L);
                    }
                    cursor = pagedFile.io(0L, 2, cursorContext);
                    try {
                        org.junit.jupiter.api.Assertions.assertEquals((long)(i * 3 + 2), (long)defaultPageCacheTracer.openedCursors());
                        org.junit.jupiter.api.Assertions.assertEquals((long)(i * 3 + 1), (long)defaultPageCacheTracer.closedCursors());
                    }
                    finally {
                        if (cursor != null) {
                            cursor.close();
                        }
                    }
                    cursor = pagedFile.io(0L, 2, cursorContext);
                    try {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                        org.junit.jupiter.api.Assertions.assertEquals((long)(i * 3 + 3), (long)defaultPageCacheTracer.openedCursors());
                        org.junit.jupiter.api.Assertions.assertEquals((long)(i * 3 + 2), (long)defaultPageCacheTracer.closedCursors());
                    }
                    finally {
                        if (cursor != null) {
                            cursor.close();
                        }
                    }
                    pagedFile.setDeleteOnClose(true);
                    continue;
                }
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)(iterations * 3), (long)defaultPageCacheTracer.openedCursors());
            org.junit.jupiter.api.Assertions.assertEquals((long)(iterations * 3), (long)defaultPageCacheTracer.closedCursors());
        }
    }

    @Test
    void countOpenedAndClosedLinkedCursors() throws IOException {
        DefaultPageCacheTracer defaultPageCacheTracer = new DefaultPageCacheTracer();
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)defaultPageCacheTracer, EmptyVersionContextSupplier.EMPTY);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 42, (PageCacheTracer)defaultPageCacheTracer);){
            int iterations = 14;
            for (int i = 0; i < iterations; ++i) {
                this.writeInitialDataTo(this.file("a" + i), this.reservedBytes);
                try (CursorContext cursorContext = contextFactory.create("countOpenedAndClosedCursors");
                     PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a" + i), 8 + this.reservedBytes);){
                    try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                        cursor.openLinkedCursor(1L);
                        org.junit.jupiter.api.Assertions.assertEquals((long)(i * 7 + 2), (long)defaultPageCacheTracer.openedCursors());
                        org.junit.jupiter.api.Assertions.assertEquals((long)(i * 7), (long)defaultPageCacheTracer.closedCursors());
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                        cursor.putLong(0L);
                    }
                    cursor = pagedFile.io(0L, 2, cursorContext);
                    try {
                        cursor.openLinkedCursor(1L);
                        org.junit.jupiter.api.Assertions.assertEquals((long)(i * 7 + 4), (long)defaultPageCacheTracer.openedCursors());
                        org.junit.jupiter.api.Assertions.assertEquals((long)(i * 7 + 2), (long)defaultPageCacheTracer.closedCursors());
                    }
                    finally {
                        if (cursor != null) {
                            cursor.close();
                        }
                    }
                    cursor = pagedFile.io(0L, 2, cursorContext);
                    try {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                        cursor.openLinkedCursor(1L).close();
                        cursor.openLinkedCursor(1L);
                        org.junit.jupiter.api.Assertions.assertEquals((long)(i * 7 + 7), (long)defaultPageCacheTracer.openedCursors());
                        org.junit.jupiter.api.Assertions.assertEquals((long)(i * 7 + 5), (long)defaultPageCacheTracer.closedCursors());
                    }
                    finally {
                        if (cursor != null) {
                            cursor.close();
                        }
                    }
                    pagedFile.setDeleteOnClose(true);
                    continue;
                }
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)(iterations * 7), (long)defaultPageCacheTracer.openedCursors());
            org.junit.jupiter.api.Assertions.assertEquals((long)(iterations * 7), (long)defaultPageCacheTracer.closedCursors());
        }
    }

    @Test
    void shouldBeAbleToSetDeleteOnCloseFileAfterItWasMapped() throws IOException {
        DefaultPageCacheTracer defaultPageCacheTracer = new DefaultPageCacheTracer();
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)defaultPageCacheTracer, EmptyVersionContextSupplier.EMPTY);
        Path fileForDeletion = this.file("fileForDeletion");
        this.writeInitialDataTo(fileForDeletion, this.reservedBytes);
        long initialFlushes = defaultPageCacheTracer.flushes();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, (PageCacheTracer)defaultPageCacheTracer);){
            try (CursorContext cursorContext = contextFactory.create("shouldBeAbleToSetDeleteOnCloseFileAfterItWasMapped");
                 PagedFile pagedFile = this.map((PageCache)pageCache, fileForDeletion, 8 + this.reservedBytes);){
                try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(0L);
                }
                pagedFile.setDeleteOnClose(true);
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fs.fileExists(fileForDeletion));
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)(defaultPageCacheTracer.flushes() - initialFlushes));
        }
    }

    @Test
    void ableToEvictAllPageInAPageCache() throws IOException {
        this.writeInitialDataTo(this.file("a"), this.reservedBytes);
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer recordingCursor = new RecordingPageCursorTracer(tracer, "ableToEvictAllPageInAPageCache");
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)tracer, EmptyVersionContextSupplier.EMPTY);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, this.blockCacheFlush(tracer));
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8 + this.reservedBytes);
             CursorContext context = contextFactory.create((PageCursorTracer)recordingCursor);){
            try (PageCursor cursor = pagedFile.io(0L, 1, context);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            }
            cursor = pagedFile.io(1L, 1, context);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            MuninnPageCacheTest.evictAllPages(pageCache);
        }
    }

    @Test
    void mustEvictCleanPageWithoutFlushing() throws Exception {
        this.writeInitialDataTo(this.file("a"), this.reservedBytes);
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer recordingTracer = new RecordingPageCursorTracer(tracer, "mustEvictCleanPageWithoutFlushing");
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)tracer, EmptyVersionContextSupplier.EMPTY);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10, this.blockCacheFlush(tracer));
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8 + this.reservedBytes);){
            try (PageCursor cursor = pagedFile.io(0L, 1, contextFactory.create((PageCursorTracer)recordingTracer));){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            }
            recordingTracer.reportEvents();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)recordingTracer.observe(RecordingPageCursorTracer.Fault.class));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)recordingTracer.faults());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)tracer.faults());
            long clockArm = pageCache.evictPages(1, 1, tracer.beginPageEvictions(1));
            Assertions.assertThat((long)clockArm).isEqualTo(1L);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
        }
    }

    @Test
    void mustFlushDirtyPagesOnEvictingFirstPage() throws Exception {
        this.writeInitialDataTo(this.file("a"), this.reservedBytes);
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer recordingTracer = new RecordingPageCursorTracer(tracer, "mustFlushDirtyPagesOnEvictingFirstPage");
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)tracer, EmptyVersionContextSupplier.EMPTY);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10, this.blockCacheFlush(tracer));
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8 + this.reservedBytes);){
            try (PageCursor cursor = pagedFile.io(0L, 2, contextFactory.create((PageCursorTracer)recordingTracer));){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(0L);
            }
            recordingTracer.reportEvents();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)recordingTracer.observe(RecordingPageCursorTracer.Fault.class));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)recordingTracer.faults());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)tracer.faults());
            long clockArm = pageCache.evictPages(1, 0, tracer.beginPageEvictions(1));
            Assertions.assertThat((long)clockArm).isEqualTo(1L);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
            this.checkFileWithTwoLongs("a", 0L, -2392823106362282833L);
        }
    }

    @Test
    void mustFlushDirtyPagesOnEvictingLastPage() throws Exception {
        this.writeInitialDataTo(this.file("a"), this.reservedBytes);
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer recordingTracer = new RecordingPageCursorTracer(tracer, "mustFlushDirtyPagesOnEvictingLastPage");
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)tracer, EmptyVersionContextSupplier.EMPTY);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10, this.blockCacheFlush(tracer));
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8 + this.reservedBytes);){
            try (PageCursor cursor = pagedFile.io(1L, 2, contextFactory.create((PageCursorTracer)recordingTracer));){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(0L);
            }
            recordingTracer.reportEvents();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)recordingTracer.observe(RecordingPageCursorTracer.Fault.class));
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)recordingTracer.faults());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)tracer.faults());
            long clockArm = pageCache.evictPages(1, 0, tracer.beginPageEvictions(1));
            Assertions.assertThat((long)clockArm).isEqualTo(1L);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
            this.checkFileWithTwoLongs("a", -3819410105021120785L, 0L);
        }
    }

    @Test
    void finishPinEventWhenOpenedWithNoFaultOption() throws IOException {
        this.writeInitialDataTo(this.file("a"), this.reservedBytes);
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer(true);
        PageCursorTracer pageCursorTracer = cacheTracer.createPageCursorTracer("finishPinEventWhenOpenedWithNoFaultOption");
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)cacheTracer, EmptyVersionContextSupplier.EMPTY);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 4, (PageCacheTracer)cacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8 + this.reservedBytes);){
            CursorContext cursorContext = contextFactory.create(pageCursorTracer);
            try (PageCursor cursor = pagedFile.io(0L, 17, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)cursorContext.getCursorTracer().pins());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)cursorContext.getCursorTracer().noFaults());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)cursorContext.getCursorTracer().unpins());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFile.pageFileCounters().pins());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFile.pageFileCounters().noFaults());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pagedFile.pageFileCounters().unpins());
        }
    }

    @Test
    void finishPinEventWhenRetryOnEvictedPage() throws IOException {
        this.writeInitialDataTo(this.file("a"), this.reservedBytes);
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer(true);
        PageCursorTracer pageCursorTracer = cacheTracer.createPageCursorTracer("finishPinEventWhenOpenedWithNoFaultOption");
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)cacheTracer, EmptyVersionContextSupplier.EMPTY);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, (PageCacheTracer)cacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8 + this.reservedBytes);){
            CursorContext cursorContext = contextFactory.create(pageCursorTracer);
            try (PageCursor readCursor = pagedFile.io(0L, 1, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)readCursor.next());
                int clockArm = pageCache.evictPages(1, 0, cacheTracer.beginPageEvictions(1));
                Assertions.assertThat((int)clockArm).isEqualTo(1L);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)readCursor.shouldRetry());
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)cursorContext.getCursorTracer().pins());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)cursorContext.getCursorTracer().unpins());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFile.pageFileCounters().pins());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFile.pageFileCounters().unpins());
        }
    }

    @Test
    void finishPinEventReportedPerFile() throws IOException {
        this.writeInitialDataTo(this.file("a"), this.reservedBytes);
        this.writeInitialDataTo(this.file("b"), this.reservedBytes);
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer(true);
        PageCursorTracer pageCursorTracer = cacheTracer.createPageCursorTracer("finishPinEventReportedPerFile");
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)cacheTracer, EmptyVersionContextSupplier.EMPTY);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 4, (PageCacheTracer)cacheTracer);
             PagedFile pagedFileA = this.map((PageCache)pageCache, this.file("a"), 8 + this.reservedBytes);
             PagedFile pagedFileB = this.map((PageCache)pageCache, this.file("b"), 8 + this.reservedBytes);){
            CursorContext cursorContext = contextFactory.create(pageCursorTracer);
            try (PageCursor cursor = pagedFileA.io(0L, 1, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
            cursor = pagedFileB.io(0L, 1, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)cursorContext.getCursorTracer().pins());
            org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)cursorContext.getCursorTracer().unpins());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFileA.pageFileCounters().pins());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFileA.pageFileCounters().unpins());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFileB.pageFileCounters().pins());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFileB.pageFileCounters().unpins());
        }
    }

    @Test
    void finishPinEventReportedPerFileAsInTransaction() throws IOException {
        this.writeInitialDataTo(this.file("a"), this.reservedBytes);
        this.writeInitialDataTo(this.file("b"), this.reservedBytes);
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer(true);
        PageCursorTracer pageCursorTracer = cacheTracer.createPageCursorTracer("finishPinEventReportedPerFile");
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)cacheTracer, EmptyVersionContextSupplier.EMPTY);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 4, (PageCacheTracer)cacheTracer);
             PagedFile pagedFileA = this.map((PageCache)pageCache, this.file("a"), 8 + this.reservedBytes);
             PagedFile pagedFileB = this.map((PageCache)pageCache, this.file("b"), 8 + this.reservedBytes);){
            CursorContext cursorContext = contextFactory.create(pageCursorTracer);
            try (PageCursor cursorA = pagedFileA.io(0L, 1, cursorContext);
                 PageCursor cursorB = pagedFileB.io(0L, 1, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorA.next());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursorB.next());
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)cursorContext.getCursorTracer().pins());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)cursorContext.getCursorTracer().unpins());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)pagedFileA.pageFileCounters().pins());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)pagedFileA.pageFileCounters().unpins());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)pagedFileB.pageFileCounters().pins());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)pagedFileB.pageFileCounters().unpins());
        }
    }

    @Test
    void mustFlushDirtyPagesOnEvictingAllPages() throws Exception {
        this.writeInitialDataTo(this.file("a"), this.reservedBytes);
        RecordingPageCacheTracer tracer = new RecordingPageCacheTracer();
        RecordingPageCursorTracer recordingTracer = new RecordingPageCursorTracer(tracer, "mustFlushDirtyPagesOnEvictingAllPages", RecordingPageCursorTracer.Fault.class);
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)tracer, EmptyVersionContextSupplier.EMPTY);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10, this.blockCacheFlush(tracer));
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8 + this.reservedBytes);){
            try (PageCursor cursor = pagedFile.io(0L, 6, contextFactory.create((PageCursorTracer)recordingTracer));){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(0L);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(0L);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            }
            recordingTracer.reportEvents();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)recordingTracer.observe(RecordingPageCursorTracer.Fault.class));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)recordingTracer.observe(RecordingPageCursorTracer.Fault.class));
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)recordingTracer.faults());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)tracer.faults());
            long clockArm = pageCache.evictPages(2, 0, tracer.beginPageEvictions(2));
            Assertions.assertThat((long)clockArm).isEqualTo(2L);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)tracer.observe(RecordingPageCacheTracer.Evict.class));
            this.checkFileWithTwoLongs("a", 0L, 0L);
        }
    }

    @Test
    void trackPageModificationTransactionId() throws Exception {
        Assumptions.assumeFalse((boolean)this.multiVersioned);
        TestVersionContext versionContext = new TestVersionContext(() -> 0);
        CursorContextFactory contextFactory = new CursorContextFactory(PageCacheTracer.NULL, (VersionContextSupplier)new SingleVersionContextSupplier(versionContext));
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);
             CursorContext cursorContext = contextFactory.create("trackPageModificationTransactionId");){
            versionContext.initWrite(7L);
            try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(0L, 1, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                MuninnPageCursor pageCursor = (MuninnPageCursor)cursor;
                org.junit.jupiter.api.Assertions.assertEquals((long)7L, (long)PageList.getLastModifiedTxId((long)pageCursor.pinnedPageRef));
                org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)cursor.getLong());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void reportFreeListSizeToTracers() throws IOException {
        InfoTracer pageCacheTracer = new InfoTracer();
        int maxPages = 40;
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)pageCacheTracer, EmptyVersionContextSupplier.EMPTY);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, maxPages, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 5; ++pageId) {
                CursorContext cursorContext = contextFactory.create("test");
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, cursorContext);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                }
                org.junit.jupiter.api.Assertions.assertEquals((int)(maxPages - (pageId + 1)), (int)pageCacheTracer.getFreeListSize());
            }
            pagedFile.flushAndForce(FileFlushEvent.NULL);
        }
    }

    @Test
    void countNotModifiedPagesPerChunkWithNoBuffers() throws IOException {
        Assumptions.assumeTrue((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        InfoTracer pageCacheTracer = new InfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 40, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, CursorContext.NULL_CONTEXT);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            InfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getNotModifiedPages()).isEqualTo(0L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getNotModifiedPages()).isEqualTo(2L);
        }
    }

    @Test
    void flushFileWithSeveralChunks() throws IOException {
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        InfoTracer pageCacheTracer = new InfoTracer();
        int maxPages = 4346;
        int dirtyPages = 4106;
        MultiChunkSwapperFilePageSwapperFactory swapperFactory = new MultiChunkSwapperFilePageSwapperFactory((PageCacheTracer)pageCacheTracer);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache((PageSwapperFactory)swapperFactory, maxPages, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < dirtyPages; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, CursorContext.NULL_CONTEXT);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(2);
            InfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getFlushPerChunk()).isGreaterThanOrEqualTo((long)(dirtyPages / (Integer)GraphDatabaseSettings.pagecache_flush_buffer_size_in_pages.defaultValue()));
            InfoTracer.ChunkInfo chunkInfo2 = observedChunks.get(1);
            Assertions.assertThat((long)chunkInfo2.getFlushPerChunk()).isGreaterThanOrEqualTo(1L);
            observedChunks.clear();
        }
    }

    @Test
    void countNotModifiedPagesPerChunkWithBuffers() throws IOException {
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        InfoTracer pageCacheTracer = new InfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 40, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, CursorContext.NULL_CONTEXT);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            InfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getNotModifiedPages()).isEqualTo(0L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getNotModifiedPages()).isEqualTo(1L);
        }
    }

    @Test
    void countFlushesPerChunkWithNoBuffers() throws IOException {
        Assumptions.assumeTrue((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        InfoTracer pageCacheTracer = new InfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 40, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, CursorContext.NULL_CONTEXT);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            InfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getFlushPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getFlushPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> thirdFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(thirdFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo thirdChunkInfo = thirdFlushChunks.get(0);
            Assertions.assertThat((long)thirdChunkInfo.getFlushPerChunk()).isEqualTo(2L);
        }
    }

    @Test
    void countFlushesPerChunkWithBuffers() throws IOException {
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        InfoTracer pageCacheTracer = new InfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 40, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, CursorContext.NULL_CONTEXT);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            InfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getFlushPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getFlushPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> thirdFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(thirdFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo thirdChunkInfo = thirdFlushChunks.get(0);
            Assertions.assertThat((long)thirdChunkInfo.getFlushPerChunk()).isEqualTo(1L);
        }
    }

    @Test
    void countMergesPerChunkWithNoBuffers() throws IOException {
        Assumptions.assumeTrue((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        InfoTracer pageCacheTracer = new InfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 40, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, CursorContext.NULL_CONTEXT);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            InfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getMergesPerChunk()).isEqualTo(3L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getMergesPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> thirdFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(thirdFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo thirdChunkInfo = thirdFlushChunks.get(0);
            Assertions.assertThat((long)thirdChunkInfo.getMergesPerChunk()).isEqualTo(0L);
        }
    }

    @Test
    void countMergesPerChunkWithBuffers() throws IOException {
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        InfoTracer pageCacheTracer = new InfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 40, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, CursorContext.NULL_CONTEXT);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            InfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getMergesPerChunk()).isEqualTo(0L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getMergesPerChunk()).isEqualTo(0L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> thirdFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(thirdFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo thirdChunkInfo = thirdFlushChunks.get(0);
            Assertions.assertThat((long)thirdChunkInfo.getMergesPerChunk()).isEqualTo(0L);
        }
    }

    @Test
    void countUsedBuffersPerChunkWithNoBuffers() throws IOException {
        Assumptions.assumeTrue((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        InfoTracer pageCacheTracer = new InfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 40, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, CursorContext.NULL_CONTEXT);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            InfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getBuffersPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getBuffersPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> thirdFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(thirdFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo thirdChunkInfo = thirdFlushChunks.get(0);
            Assertions.assertThat((long)thirdChunkInfo.getBuffersPerChunk()).isEqualTo(2L);
        }
    }

    @Test
    void usedBuffersPerChunkIsAlwaysOneWithBuffers() throws IOException {
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        InfoTracer pageCacheTracer = new InfoTracer();
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 40, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            for (int pageId = 0; pageId < 4; ++pageId) {
                try (PageCursor cursor = pagedFile.io((long)pageId, 2, CursorContext.NULL_CONTEXT);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                    continue;
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> observedChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(observedChunks).hasSize(1);
            InfoTracer.ChunkInfo chunkInfo = observedChunks.get(0);
            Assertions.assertThat((long)chunkInfo.getBuffersPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> secondFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(secondFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo partialChunkInfo = secondFlushChunks.get(0);
            Assertions.assertThat((long)partialChunkInfo.getBuffersPerChunk()).isEqualTo(1L);
            observedChunks.clear();
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            CopyOnWriteArrayList<InfoTracer.ChunkInfo> thirdFlushChunks = pageCacheTracer.getObservedChunks();
            Assertions.assertThat(thirdFlushChunks).hasSize(1);
            InfoTracer.ChunkInfo thirdChunkInfo = thirdFlushChunks.get(0);
            Assertions.assertThat((long)thirdChunkInfo.getBuffersPerChunk()).isEqualTo(1L);
        }
    }

    @Test
    void flushSequentialPagesOnPageFileFlushWithNoBuffers() throws IOException {
        Assumptions.assumeTrue((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer(true);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 4, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pageCacheTracer.flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)pageCacheTracer.merges());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFile.pageFileCounters().flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)pagedFile.pageFileCounters().merges());
        }
    }

    @Test
    void flushSequentialPagesOnPageFileFlushWithNoBuffersWithMultipleFiles() throws IOException {
        Assumptions.assumeTrue((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        this.writeInitialDataTo(this.file("a"), this.reservedBytes);
        this.writeInitialDataTo(this.file("b"), this.reservedBytes);
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer(true);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 4, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFileA = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));
             PagedFile pagedFileB = this.map((PageCache)pageCache, this.file("b"), (int)ByteUnit.kibiBytes((long)8L));){
            try (PageCursor cursor = pagedFileA.io(1L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFileA.io(2L, 2, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFileA.flushAndForce(flushEvent);
            }
            cursor = pagedFileB.io(1L, 2, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            flushEvent = pageCacheTracer.beginFileFlush();
            try {
                pagedFileB.flushAndForce(flushEvent);
            }
            finally {
                if (flushEvent != null) {
                    flushEvent.close();
                }
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)pageCacheTracer.flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)pageCacheTracer.merges());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFileA.pageFileCounters().flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)pagedFileA.pageFileCounters().merges());
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)pagedFileB.pageFileCounters().flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pagedFileB.pageFileCounters().merges());
        }
    }

    @Test
    void flushSequentialPagesOnPageFileFlushWithBuffers() throws IOException {
        Assumptions.assumeFalse((boolean)IOBufferFactory.DISABLED_BUFFER_FACTORY.equals(this.fixture.getBufferFactory()));
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer(true);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 4, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(2L, 2, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pageCacheTracer.flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pageCacheTracer.merges());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFile.pageFileCounters().flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pagedFile.pageFileCounters().merges());
        }
    }

    @Test
    void doNotMergeNonSequentialPageBuffersOnPageFileFlush() throws IOException {
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer(true);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 6, (PageCacheTracer)pageCacheTracer);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), (int)ByteUnit.kibiBytes((long)8L));){
            try (PageCursor cursor = pagedFile.io(1L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            cursor = pagedFile.io(3L, 2, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            try (FileFlushEvent flushEvent = pageCacheTracer.beginFileFlush();){
                pagedFile.flushAndForce(flushEvent);
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pageCacheTracer.flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pageCacheTracer.merges());
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)pagedFile.pageFileCounters().flushes());
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)pagedFile.pageFileCounters().merges());
        }
    }

    @Test
    void pageModificationTrackingNoticeWriteFromAnotherThread() throws Exception {
        Assumptions.assumeFalse((boolean)this.multiVersioned);
        TestVersionContext versionContext = new TestVersionContext(() -> 0);
        CursorContextFactory contextFactory = new CursorContextFactory(PageCacheTracer.NULL, (VersionContextSupplier)new SingleVersionContextSupplier(versionContext));
        CursorContext cursorContext = contextFactory.create("pageModificationTrackingNoticeWriteFromAnotherThread");
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            versionContext.initWrite(7L);
            Future<?> future = executor.submit(() -> {
                try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(1L);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            future.get();
            try (PageCursor cursor = pagedFile.io(0L, 1, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                MuninnPageCursor pageCursor = (MuninnPageCursor)cursor;
                org.junit.jupiter.api.Assertions.assertEquals((long)7L, (long)PageList.getLastModifiedTxId((long)pageCursor.pinnedPageRef));
                org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)cursor.getLong());
            }
        }
    }

    @Test
    void pageModificationTracksHighestModifierTransactionId() throws IOException {
        Assumptions.assumeFalse((boolean)this.multiVersioned);
        TestVersionContext versionContext = new TestVersionContext(() -> 0);
        CursorContextFactory contextFactory = new CursorContextFactory(PageCacheTracer.NULL, (VersionContextSupplier)new SingleVersionContextSupplier(versionContext));
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);
             CursorContext cursorContext = contextFactory.create("pageModificationTracksHighestModifierTransactionId");){
            versionContext.initWrite(1L);
            try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(1L);
            }
            versionContext.initWrite(12L);
            cursor = pagedFile.io(0L, 2, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(2L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            versionContext.initWrite(7L);
            cursor = pagedFile.io(0L, 2, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            cursor = pagedFile.io(0L, 1, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                MuninnPageCursor pageCursor = (MuninnPageCursor)cursor;
                org.junit.jupiter.api.Assertions.assertEquals((long)12L, (long)PageList.getLastModifiedTxId((long)pageCursor.pinnedPageRef));
                org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)cursor.getLong());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void markCursorContextDirtyWhenRepositionCursorOnItsCurrentPage() throws IOException {
        Assumptions.assumeFalse((boolean)this.multiVersioned);
        TestVersionContext versionContext = new TestVersionContext(() -> 3);
        CursorContextFactory contextFactory = new CursorContextFactory(PageCacheTracer.NULL, (VersionContextSupplier)new SingleVersionContextSupplier(versionContext));
        CursorContext cursorContext = contextFactory.create("markCursorContextDirtyWhenRepositionCursorOnItsCurrentPage");
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);){
            versionContext.initRead();
            try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(0L));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)versionContext.isDirty());
                MuninnPageCursor pageCursor = (MuninnPageCursor)cursor;
                PageList.setLastModifiedTxId((long)pageCursor.pinnedPageRef, (long)17L);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next(0L));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)versionContext.isDirty());
            }
        }
    }

    @Test
    void markCursorContextAsDirtyWhenReadingDataFromMoreRecentTransactions() throws IOException {
        Assumptions.assumeFalse((boolean)this.multiVersioned);
        TestVersionContext versionContext = new TestVersionContext(() -> 3);
        CursorContextFactory contextFactory = new CursorContextFactory(PageCacheTracer.NULL, (VersionContextSupplier)new SingleVersionContextSupplier(versionContext));
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8);
             CursorContext cursorContext = contextFactory.create("markCursorContextAsDirtyWhenReadingDataFromMoreRecentTransactions");){
            versionContext.initWrite(7L);
            try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            versionContext.initRead();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)versionContext.isDirty());
            cursor = pagedFile.io(0L, 1, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)cursor.getLong());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)versionContext.isDirty());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void doNotMarkCursorContextAsDirtyWhenReadingDataFromOlderTransactions() throws IOException {
        TestVersionContext versionContext = new TestVersionContext(() -> 23);
        CursorContextFactory contextFactory = new CursorContextFactory(PageCacheTracer.NULL, (VersionContextSupplier)new SingleVersionContextSupplier(versionContext));
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8 + this.reservedBytes);
             CursorContext cursorContext = contextFactory.create("doNotMarkCursorContextAsDirtyWhenReadingDataFromOlderTransactions");){
            versionContext.initWrite(17L);
            try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            versionContext.initRead();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)versionContext.isDirty());
            cursor = pagedFile.io(0L, 1, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)cursor.getLong());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)versionContext.isDirty());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void markContextAsDirtyWhenAnyEvictedPageHaveModificationTransactionHigherThenReader() throws IOException {
        Assumptions.assumeFalse((boolean)this.multiVersioned);
        TestVersionContext versionContext = new TestVersionContext(() -> 5);
        CursorContextFactory contextFactory = new CursorContextFactory(PageCacheTracer.NULL, (VersionContextSupplier)new SingleVersionContextSupplier(versionContext));
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8 + this.reservedBytes);
             CursorContext cursorContext = contextFactory.create("markContextAsDirtyWhenAnyEvictedPageHaveModificationTransactionHigherThenReader");){
            versionContext.initWrite(3L);
            try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            versionContext.initWrite(13L);
            cursor = pagedFile.io(1L, 2, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(4L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            MuninnPageCacheTest.evictAllPages(pageCache);
            versionContext.initRead();
            cursor = pagedFile.io(0L, 1, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)cursor.getLong());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)versionContext.isDirty());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void doNotMarkContextAsDirtyWhenAnyEvictedPageHaveModificationTransactionLowerThenReader() throws IOException {
        TestVersionContext versionContext = new TestVersionContext(() -> 15);
        CursorContextFactory contextFactory = new CursorContextFactory(PageCacheTracer.NULL, (VersionContextSupplier)new SingleVersionContextSupplier(versionContext));
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8 + this.reservedBytes);
             CursorContext cursorContext = contextFactory.create("doNotMarkContextAsDirtyWhenAnyEvictedPageHaveModificationTransactionLowerThenReader");){
            versionContext.initWrite(3L);
            try (PageCursor cursor = pagedFile.io(0L, 2, cursorContext);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(3L);
            }
            versionContext.initWrite(13L);
            cursor = pagedFile.io(1L, 2, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                cursor.putLong(4L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            MuninnPageCacheTest.evictAllPages(pageCache);
            versionContext.initRead();
            cursor = pagedFile.io(0L, 1, cursorContext);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)cursor.getLong());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)versionContext.isDirty());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void closingTheCursorMustUnlockModifiedPage() throws Exception {
        this.writeInitialDataTo(this.file("a"), this.reservedBytes);
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 10, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8 + this.reservedBytes);){
            Future<?> task = executor.submit(() -> {
                try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putLong(41L);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            task.get();
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                long value = cursor.getLong();
                cursor.setOffset(0);
                cursor.putLong(value + 1L);
            }
            long clockArm = pageCache.evictPages(1, 0, EvictionRunEvent.NULL);
            Assertions.assertThat((long)clockArm).isEqualTo(1L);
            this.checkFileWithTwoLongs("a", 42L, -2392823106362282833L);
        }
    }

    @Test
    void mustUnblockPageFaultersWhenEvictionGetsException() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.writeInitialDataTo(this.file("a"), this.reservedBytes);
            final MutableBoolean throwException = new MutableBoolean(true);
            DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

                public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
                    return new DelegatingStoreChannel(super.open(fileName, options)){

                        public void writeAll(ByteBuffer src, long position) throws IOException {
                            if (throwException.booleanValue()) {
                                throw new IOException("uh-oh...");
                            }
                            super.writeAll(src, position);
                        }
                    };
                }
            };
            try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache((FileSystemAbstraction)fs, 2, PageCacheTracer.NULL);
                 PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8 + this.reservedBytes);){
                try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                    for (int i = 0; i < 1000; ++i) {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    }
                    org.junit.jupiter.api.Assertions.fail((String)"Expected an exception at this point");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throwException.setFalse();
            }
        });
    }

    @RepeatedTest(value=50)
    void racePageFileCloseAndEviction() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            Assumptions.assumeTrue((this.fs.getClass() == EphemeralFileSystemAbstraction.class ? 1 : 0) != 0, (String)"This test is very slow on real file system");
            int pages = 10;
            try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 2, PageCacheTracer.NULL);){
                Race race = new Race();
                race.addContestant(Race.throwing(() -> {
                    try {
                        for (int i = 0; i < 1000; ++i) {
                            try (PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8 + this.reservedBytes);
                                 PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                                for (int k = 0; k < pages; ++k) {
                                    cursor.next();
                                    cursor.putLong(101010101L);
                                }
                                continue;
                            }
                        }
                    }
                    catch (CacheLiveLockException cacheLiveLockException) {
                    }
                    finally {
                        pageCache.close();
                    }
                }));
                race.addContestant(Race.throwing(() -> {
                    try (EvictionRunEvent evictionRunEvent = PageCacheTracer.NULL.beginPageEvictions(1000);){
                        pageCache.evictPages(1000, 0, evictionRunEvent);
                    }
                }));
                race.go();
            }
        });
    }

    @Test
    void pageCacheFlushAndForceMustClearBackgroundEvictionException() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            final MutableBoolean throwException = new MutableBoolean(true);
            DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

                public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
                    return new DelegatingStoreChannel(super.open(fileName, options)){

                        public void writeAll(ByteBuffer src, long position) throws IOException {
                            if (throwException.booleanValue()) {
                                throw new IOException("uh-oh...");
                            }
                            super.writeAll(src, position);
                        }
                    };
                }
            };
            try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache((FileSystemAbstraction)fs, 10, PageCacheTracer.NULL);
                 PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8 + this.reservedBytes);){
                try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                }
                pageCache.evictPages(1, 0, EvictionRunEvent.NULL);
                throwException.setFalse();
                pageCache.flushAndForce(DatabaseFlushEvent.NULL);
                cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);
                try {
                    for (int i = 0; i < this.maxPages * 20; ++i) {
                        org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    }
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        });
    }

    @Test
    void mustThrowIfMappingFileWouldOverflowReferenceCount() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            Path file = this.file("a");
            this.writeInitialDataTo(file, this.reservedBytes);
            try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 30, PageCacheTracer.NULL);){
                int i;
                PagedFile pf = null;
                try {
                    for (i = 0; i < Integer.MAX_VALUE; ++i) {
                        pf = this.map((PageCache)pageCache, file, this.filePageSize);
                    }
                    org.junit.jupiter.api.Assertions.fail((String)"Failure was expected");
                }
                catch (IllegalStateException j) {
                    for (int j2 = 0; j2 < i; ++j2) {
                        try {
                            pf.close();
                            continue;
                        }
                        catch (Exception e) {
                            throw new AssertionError("Did not expect pf.close() to throw", e);
                        }
                    }
                }
                finally {
                    for (int j = 0; j < i; ++j) {
                        try {
                            pf.close();
                            continue;
                        }
                        catch (Exception e) {
                            throw new AssertionError("Did not expect pf.close() to throw", e);
                        }
                    }
                }
            }
        });
    }

    @Test
    void unlimitedShouldFlushInParallel() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            ArrayList<Path> mappedFiles = new ArrayList<Path>();
            mappedFiles.add(this.existingFile("a"));
            mappedFiles.add(this.existingFile("b"));
            this.getPageCache(this.fs, this.maxPages, (PageCacheTracer)new FlushRendezvousTracer(mappedFiles.size()));
            ArrayList<PagedFile> mappedPagedFiles = new ArrayList<PagedFile>();
            for (Path mappedFile : mappedFiles) {
                PagedFile pagedFile = this.map(this.pageCache, mappedFile, this.filePageSize);
                mappedPagedFiles.add(pagedFile);
                PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);
                try {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                    cursor.putInt(1);
                }
                finally {
                    if (cursor == null) continue;
                    cursor.close();
                }
            }
            ((MuninnPageCache)this.pageCache).flushAndForce(DatabaseFlushEvent.NULL);
            IOUtils.closeAll(mappedPagedFiles);
        });
    }

    @Test
    void transientCursorShouldNotUpdateUsageCounter() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 40, PageCacheTracer.NULL);
             PagedFile pagedFile = this.map((PageCache)pageCache, this.file("a"), 8 + this.reservedBytes);){
            PageList pages = pageCache.pages;
            long zeroPageRef = pages.deref(0);
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((long)PageList.getUsage((long)zeroPageRef)).isEqualTo(1L);
            }
            cursor = pagedFile.io(0L, 1, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((long)PageList.getUsage((long)zeroPageRef)).isEqualTo(2L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            cursor = pagedFile.io(0L, 34, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((long)PageList.getUsage((long)zeroPageRef)).isEqualTo(2L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            cursor = pagedFile.io(0L, 33, CursorContext.NULL_CONTEXT);
            try {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThat((long)PageList.getUsage((long)zeroPageRef)).isEqualTo(2L);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void shouldDealWithOutOfBoundsWithRetries() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.createPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());){
            Path file = this.existingFile("a");
            this.writeInitialDataTo(file, this.reservedBytes);
            try (PagedFile pagedFile = this.map((PageCache)pageCache, file, 8 + this.reservedBytes);
                 PageCursor readCursor = pagedFile.io(0L, 1, CursorContext.NULL_CONTEXT);){
                Assertions.assertThat((boolean)readCursor.next(0L)).isTrue();
                readCursor.setOffset(-256);
                boolean first = true;
                readCursor.mark();
                do {
                    readCursor.setOffsetToMark();
                    readCursor.getLong();
                    if (!first) continue;
                    try (PageCursor writeCursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                        writeCursor.next(0L);
                        writeCursor.putLong(1L);
                    }
                    first = false;
                } while (readCursor.shouldRetry());
                Assertions.assertThat((boolean)readCursor.checkAndClearBoundsFlag()).isTrue();
            }
        }
    }

    @Test
    void pageCursorsHaveCorrectPayloadSize() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.getPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());
             PagedFile pagedFile = this.map(this.file("a"), pageCache.pageSize());){
            try (MuninnPageCursor writer = (MuninnPageCursor)pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writer.next());
                org.junit.jupiter.api.Assertions.assertEquals((int)pagedFile.payloadSize(), (int)writer.getPayloadSize());
                org.junit.jupiter.api.Assertions.assertEquals((int)(pageCache.pageSize() - pagedFile.pageReservedBytes()), (int)writer.getPayloadSize());
                org.junit.jupiter.api.Assertions.assertEquals((int)pageCache.pageSize(), (int)writer.getPageSize());
            }
            try (MuninnPageCursor reader = (MuninnPageCursor)pagedFile.io(0L, 1, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                org.junit.jupiter.api.Assertions.assertEquals((int)pagedFile.payloadSize(), (int)reader.getPayloadSize());
                org.junit.jupiter.api.Assertions.assertEquals((int)(pageCache.pageSize() - pagedFile.pageReservedBytes()), (int)reader.getPayloadSize());
                org.junit.jupiter.api.Assertions.assertEquals((int)pageCache.pageSize(), (int)reader.getPageSize());
            }
        }
    }

    @Test
    void unboundPageCursorPayload() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.getPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());
             PagedFile pagedFile = this.map(this.file("a"), pageCache.pageSize());){
            try (MuninnPageCursor writer = (MuninnPageCursor)pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertEquals((int)writer.getPayloadSize(), (int)0);
            }
            try (MuninnPageCursor reader = (MuninnPageCursor)pagedFile.io(0L, 1, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertEquals((int)reader.getPayloadSize(), (int)0);
            }
        }
    }

    @Test
    void linkedCursorsPreservePayloadSize() throws IOException {
        try (MuninnPageCache pageCache = (MuninnPageCache)this.getPageCache(this.fs, 1024, (PageCacheTracer)new DefaultPageCacheTracer());){
            Path file = this.file("a");
            this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize, this.recordsPerFilePage, this.reservedBytes, this.pageCachePageSize);
            try (PagedFile pagedFile = this.map(this.file("a"), pageCache.pageSize());
                 PageCursor reader = pagedFile.io(0L, 1, CursorContext.NULL_CONTEXT);){
                org.junit.jupiter.api.Assertions.assertTrue((boolean)reader.next());
                try (MuninnPageCursor linkedReader = (MuninnPageCursor)reader.openLinkedCursor(1L);){
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)linkedReader.next());
                    org.junit.jupiter.api.Assertions.assertEquals((int)(pageCache.pageSize() - pagedFile.pageReservedBytes()), (int)linkedReader.getPayloadSize());
                }
            }
        }
    }

    private static void evictAllPages(MuninnPageCache pageCache) throws IOException {
        long pageReference;
        int pageId;
        PageList pages = pageCache.pages;
        for (pageId = 0; pageId < pages.getPageCount(); ++pageId) {
            pageReference = pages.deref(pageId);
            while (PageList.isLoaded((long)pageReference)) {
                pages.tryEvict(pageReference, (EvictionEventOpportunity)EvictionRunEvent.NULL);
            }
        }
        for (pageId = 0; pageId < pages.getPageCount(); ++pageId) {
            pageReference = pages.deref(pageId);
            pageCache.addFreePageToFreelist(pageReference, EvictionRunEvent.NULL);
        }
    }

    private void writeInitialDataTo(Path path, int reservedBytes) throws IOException {
        try (StoreChannel channel = this.fs.write(path);){
            ByteBuffer buf = ByteBuffers.allocate((int)(16 + 2 * reservedBytes), (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            buf.put(ByteBuffer.allocate(reservedBytes));
            buf.putLong(-3819410105021120785L);
            buf.put(ByteBuffer.allocate(reservedBytes));
            buf.putLong(-2392823106362282833L);
            buf.flip();
            channel.writeAll(buf);
        }
    }

    private int pagedFileSwapperId(MuninnPageCache pageCache) throws IOException {
        try (MuninnPagedFile pagedFile = (MuninnPagedFile)this.map((PageCache)pageCache, this.file("a"), 8);){
            int n = pagedFile.swapperId;
            return n;
        }
    }

    private CursorSwapperId pagedFileCursorSwapperId(MuninnPageCache pageCache) throws IOException {
        try (MuninnPagedFile pagedFile = (MuninnPagedFile)this.map((PageCache)pageCache, this.file("a"), 8);){
            PageCursor pageCursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);
            pageCursor.next();
            CursorSwapperId cursorSwapperId = new CursorSwapperId(pageCursor, pagedFile.swapperId);
            return cursorSwapperId;
        }
    }

    private void checkFileWithTwoLongs(String fileName, long valueA, long valueB) throws IOException {
        ByteBuffer buffer = ByteBuffers.allocate((int)(16 + 2 * this.reservedBytes), (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (StoreChannel channel = this.fs.read(this.file(fileName));){
            channel.readAll(buffer);
        }
        buffer.flip();
        buffer.position(this.reservedBytes);
        Assertions.assertThat((long)buffer.getLong()).isEqualTo(valueA);
        buffer.position(buffer.position() + this.reservedBytes);
        Assertions.assertThat((long)buffer.getLong()).isEqualTo(valueB);
    }

    private SwapperSet extractSwapperSet(MuninnPageCache pageCache) throws IOException {
        try (MuninnPagedFile pagedFile = (MuninnPagedFile)this.map((PageCache)pageCache, this.file("a"), 8);){
            SwapperSet swapperSet = pagedFile.getSwappers();
            return swapperSet;
        }
    }

    @Test
    void touchShouldLoadPagesIntoPageCache() throws Exception {
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer(true);
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)tracer, EmptyVersionContextSupplier.EMPTY);
        this.getPageCache(this.fs, 1000, (PageCacheTracer)tracer);
        Path file = this.file("a");
        int toTouch = 128;
        int fileSize = toTouch * 4;
        this.generateFile(file, fileSize);
        try (PagedFile pf = this.map(file, this.filePageSize);){
            pf.touch(0L, toTouch, CursorContext.NULL_CONTEXT);
            long faultsAfterTouch = tracer.faults();
            try (CursorContext context = contextFactory.create("testTouch");
                 PageCursor cursor = pf.io(0L, 1, context);){
                for (int i = 0; i < toTouch; ++i) {
                    int valueInPage;
                    cursor.next((long)i);
                    do {
                        valueInPage = cursor.getInt();
                    } while (cursor.shouldRetry());
                    Assertions.assertThat((int)valueInPage).isEqualTo(i);
                }
            }
            Assertions.assertThat((long)tracer.faults()).isEqualTo(faultsAfterTouch);
        }
    }

    @Test
    void touchMustNotGrowFile() throws Exception {
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer(true);
        this.getPageCache(this.fs, 1000, (PageCacheTracer)tracer);
        Path file = this.file("a");
        int toTouch = 128;
        int fileSize = toTouch * 4;
        this.generateFile(file, fileSize);
        long sizeBefore = this.fs.getFileSize(file);
        try (PagedFile pf = this.map(file, this.filePageSize);){
            Assertions.assertThat((int)pf.touch((long)(fileSize - 1), toTouch, CursorContext.NULL_CONTEXT)).isEqualTo(1);
            try (PageCursor cursor = pf.io((long)fileSize, 2, CursorContext.NULL_CONTEXT);){
                cursor.next();
            }
            pf.flushAndForce(FileFlushEvent.NULL);
        }
        Assertions.assertThat((long)this.fs.getFileSize(file)).isEqualTo(sizeBefore + (long)this.filePageSize);
    }

    @Test
    void touchShouldReportFaults() throws Exception {
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer(true);
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)tracer, EmptyVersionContextSupplier.EMPTY);
        this.getPageCache(this.fs, 1000, (PageCacheTracer)tracer);
        Path file = this.file("a");
        int toTouch = 128;
        int fileSize = toTouch * 4;
        this.generateFile(file, fileSize);
        long initialFaults = tracer.faults();
        try (PagedFile pf = this.map(file, this.filePageSize);){
            try (CursorContext context = contextFactory.create("testTouch");){
                Assertions.assertThat((int)pf.touch(0L, toTouch, context)).isEqualTo(toTouch);
            }
            Assertions.assertThat((long)tracer.faults()).isEqualTo(initialFaults + (long)toTouch);
            Assertions.assertThat((long)tracer.vectoredFaults()).isEqualTo(1L);
            context = contextFactory.create("testTouch");
            try {
                Assertions.assertThat((int)pf.touch(0L, toTouch, context)).isEqualTo(toTouch);
            }
            finally {
                if (context != null) {
                    context.close();
                }
            }
            Assertions.assertThat((long)tracer.faults()).isEqualTo(initialFaults + (long)toTouch);
            Assertions.assertThat((long)tracer.vectoredFaults()).isEqualTo(2L);
            context = contextFactory.create("testTouch");
            try {
                Assertions.assertThat((int)pf.touch((long)toTouch, toTouch, context)).isEqualTo(toTouch);
            }
            finally {
                if (context != null) {
                    context.close();
                }
            }
            Assertions.assertThat((long)tracer.faults()).isEqualTo(initialFaults + (long)(toTouch * 2));
            Assertions.assertThat((long)tracer.vectoredFaults()).isEqualTo(3L);
            context = contextFactory.create("testTouch");
            try {
                Assertions.assertThat((int)pf.touch((long)(fileSize - toTouch / 2), toTouch, context)).isEqualTo(toTouch / 2);
            }
            finally {
                if (context != null) {
                    context.close();
                }
            }
            Assertions.assertThat((long)tracer.faults()).isEqualTo(initialFaults + (long)(toTouch * 2) + (long)(toTouch / 2));
            Assertions.assertThat((long)tracer.vectoredFaults()).isEqualTo(4L);
        }
    }

    @Test
    void touchWhenSomePagesAlreadyLoaded() throws Exception {
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer(true);
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)tracer, EmptyVersionContextSupplier.EMPTY);
        this.getPageCache(this.fs, 1000, (PageCacheTracer)tracer);
        Path file = this.file("a");
        int toTouch = 128;
        int fileSize = toTouch * 4;
        this.generateFile(file, fileSize);
        long initialFaults = tracer.faults();
        try (PagedFile pf = this.map(file, this.filePageSize);){
            try (PageCursor cursor = pf.io(0L, 1, CursorContext.NULL_CONTEXT);){
                cursor.next(10L);
                cursor.next(16L);
                cursor.next(37L);
            }
            try (CursorContext context = contextFactory.create("testTouch");){
                Assertions.assertThat((int)pf.touch(0L, toTouch, context)).isEqualTo(toTouch);
            }
            Assertions.assertThat((long)tracer.faults()).isEqualTo(initialFaults + (long)toTouch - 3L);
        }
    }

    @Test
    void touchMoreThenLockStriping() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            DefaultPageCacheTracer tracer = new DefaultPageCacheTracer(true);
            CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)tracer, EmptyVersionContextSupplier.EMPTY);
            this.getPageCache(this.fs, LatchMap.faultLockStriping * 2, (PageCacheTracer)tracer);
            Path file = this.file("a");
            int toTouch = LatchMap.faultLockStriping + 27;
            int fileSize = toTouch * 4;
            this.generateFile(file, fileSize);
            long initialFaults = tracer.faults();
            try (PagedFile pf = this.map(file, this.filePageSize);){
                try (CursorContext context = contextFactory.create("testTouch");){
                    Assertions.assertThat((int)pf.touch(0L, toTouch, context)).isEqualTo(toTouch);
                }
                Assertions.assertThat((long)tracer.faults()).isEqualTo(initialFaults + (long)toTouch);
            }
        });
    }

    @Test
    void touchMoreThenPageCacheCanFit() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.getPageCache(this.fs, 200, PageCacheTracer.NULL);
            Path file = this.file("a");
            int toTouch = 256;
            int fileSize = toTouch * 4;
            this.generateFile(file, fileSize);
            try (PagedFile pf = this.map(file, this.filePageSize);){
                Assertions.assertThatThrownBy(() -> pf.touch(0L, toTouch, CursorContext.NULL_CONTEXT)).isInstanceOf(CacheLiveLockException.class);
                try (PageCursor cursor = pf.io(0L, 1, CursorContext.NULL_CONTEXT);){
                    for (int i = fileSize; i > 0; --i) {
                        Assertions.assertThat((boolean)cursor.next()).isTrue();
                    }
                }
            }
        });
    }

    @RepeatedTest(value=50)
    void racePageFileTouchAndEviction() throws IOException {
        Assumptions.assumeTrue((this.fs.getClass() == EphemeralFileSystemAbstraction.class ? 1 : 0) != 0, (String)"This test is very slow on real file system");
        AtomicBoolean stopFlag = new AtomicBoolean(false);
        int pageSize = 8 + this.reservedBytes;
        Path file = this.file("a");
        try (MuninnPageCache tempPageCache = (MuninnPageCache)this.createPageCache(this.fs, 8, PageCacheTracer.NULL);){
            this.generateFile((PageCache)tempPageCache, file, 10, pageSize);
        }
        try (MuninnPageCache localPageCache = (MuninnPageCache)this.createPageCache(this.fs, 8, PageCacheTracer.NULL);){
            org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
                Race race = new Race();
                race.addContestant(Race.throwing(() -> {
                    while (!stopFlag.get()) {
                        try {
                            PagedFile pagedFile = this.map((PageCache)localPageCache, file, pageSize);
                            try {
                                pagedFile.touch(0L, 8, CursorContext.NULL_CONTEXT);
                            }
                            finally {
                                if (pagedFile == null) continue;
                                pagedFile.close();
                            }
                        }
                        catch (CacheLiveLockException cacheLiveLockException) {}
                    }
                }));
                race.addContestant(Race.throwing(() -> {
                    try (EvictionRunEvent evictionRunEvent = PageCacheTracer.NULL.beginPageEvictions(1000);){
                        localPageCache.evictPages(1000, 0, evictionRunEvent);
                    }
                    finally {
                        stopFlag.set(true);
                    }
                }));
                race.go();
                this.assertAllPagesEvicted(localPageCache);
            }, () -> "PageCache: " + localPageCache.toString() + " pages to evict to have all free: " + localPageCache.tryGetNumberOfPagesToEvict((int)localPageCache.maxCachedPages()) + "\nObserved exception:\n" + localPageCache.describePages());
        }
    }

    @RepeatedTest(value=50)
    void racePageFileTouchAndClose() throws IOException {
        Assumptions.assumeTrue((this.fs.getClass() == EphemeralFileSystemAbstraction.class ? 1 : 0) != 0, (String)"This test is very slow on real file system");
        int pageSize = 8 + this.reservedBytes;
        Path file = this.file("a");
        try (MuninnPageCache tempPageCache = (MuninnPageCache)this.createPageCache(this.fs, 8, PageCacheTracer.NULL);){
            this.generateFile((PageCache)tempPageCache, file, 16, pageSize);
        }
        try (MuninnPageCache localPageCache = (MuninnPageCache)this.createPageCache(this.fs, 8, PageCacheTracer.NULL);){
            AtomicReference exceptionRef = new AtomicReference();
            org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
                PagedFile pagedFile = this.map((PageCache)localPageCache, file, pageSize);
                Race race = new Race();
                race.addContestant(Race.throwing(() -> {
                    try {
                        boolean firstPart = true;
                        for (int i = 0; i < 10000; ++i) {
                            pagedFile.touch(firstPart ? 0L : 8L, 8, CursorContext.NULL_CONTEXT);
                            firstPart = !firstPart;
                        }
                    }
                    catch (ClosedChannelException | FileIsNotMappedException | CacheLiveLockException exception) {
                        exceptionRef.set(exception);
                    }
                }));
                race.addContestant(Race.throwing(() -> ((PagedFile)pagedFile).close()));
                race.go();
                this.assertAllPagesEvicted(localPageCache);
            }, () -> "PageCache: " + localPageCache.toString() + " pages to evict to have all free: " + localPageCache.tryGetNumberOfPagesToEvict((int)localPageCache.maxCachedPages()) + "\nObserved exception:\n" + (exceptionRef.get() != null ? Exceptions.stringify((Throwable)((Throwable)exceptionRef.get())) : "none") + "\n" + localPageCache.describePages());
        }
    }

    @RepeatedTest(value=50)
    void racePageFilePinAndClose() throws IOException {
        Assumptions.assumeTrue((this.fs.getClass() == EphemeralFileSystemAbstraction.class ? 1 : 0) != 0, (String)"This test is very slow on real file system");
        int pageSize = 8 + this.reservedBytes;
        Path file = this.file("a");
        try (MuninnPageCache tempPageCache = (MuninnPageCache)this.createPageCache(this.fs, 8, PageCacheTracer.NULL);){
            this.generateFile((PageCache)tempPageCache, file, 16, pageSize);
        }
        try (MuninnPageCache localPageCache = (MuninnPageCache)this.createPageCache(this.fs, 8, PageCacheTracer.NULL);){
            AtomicReference exceptionRef = new AtomicReference();
            org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
                PagedFile pagedFile = this.map((PageCache)localPageCache, file, pageSize);
                Race race = new Race();
                race.addContestant(Race.throwing(() -> {
                    try {
                        for (int i = 0; i < 10000; ++i) {
                            try (PageCursor cursor = pagedFile.io(0L, 1, CursorContext.NULL_CONTEXT);){
                                while (cursor.next()) {
                                }
                                continue;
                            }
                        }
                    }
                    catch (ClosedChannelException | FileIsNotMappedException | CacheLiveLockException exception) {
                        exceptionRef.set(exception);
                    }
                }));
                race.addContestant(Race.throwing(() -> ((PagedFile)pagedFile).close()));
                race.go();
                this.assertAllPagesEvicted(localPageCache);
            }, () -> "PageCache: " + localPageCache.toString() + " pages to evict to have all free: " + localPageCache.tryGetNumberOfPagesToEvict((int)localPageCache.maxCachedPages()) + "\nObserved exception:\n" + (exceptionRef.get() != null ? Exceptions.stringify((Throwable)((Throwable)exceptionRef.get())) : "none") + "\n" + localPageCache.describePages());
        }
    }

    private void assertAllPagesEvicted(MuninnPageCache pageCache) {
        Assert.assertEventually(() -> pageCache.tryGetNumberOfPagesToEvict(pageCache.getKeepFree()), i -> i == -1, (long)this.SHORT_TIMEOUT_MILLIS, (TimeUnit)TimeUnit.MILLISECONDS);
        int maxCachedPages = (int)pageCache.maxCachedPages();
        pageCache.evictPages(pageCache.tryGetNumberOfPagesToEvict(maxCachedPages), 0, EvictionRunEvent.NULL);
        Assertions.assertThat((int)pageCache.tryGetNumberOfPagesToEvict(maxCachedPages)).isEqualTo(-1);
    }

    private void generateFile(Path file, int numberOfPages) throws IOException {
        this.generateFile(this.pageCache, file, numberOfPages, this.filePageSize);
    }

    private void generateFile(PageCache pageCache, Path file, int numberOfPages, int pageSize) throws IOException {
        try (PagedFile pf = this.map(pageCache, file, pageSize);
             PageCursor writer = pf.io(0L, 2, CursorContext.NULL_CONTEXT);){
            for (int i = 0; i < numberOfPages; ++i) {
                Assertions.assertThat((boolean)writer.next()).isTrue();
                writer.putInt(i);
            }
        }
    }

    private static class CursorSwapperId
    implements AutoCloseable {
        private final PageCursor pageCursor;
        private final int cursorId;

        CursorSwapperId(PageCursor pageCursor, int cursorId) {
            this.pageCursor = pageCursor;
            this.cursorId = cursorId;
        }

        @Override
        public void close() {
            this.pageCursor.close();
        }
    }

    private static class TestVersionContext
    implements VersionContext {
        private final IntSupplier closedTxIdSupplier;
        private long committingTxId;
        private long lastClosedTxId;
        private boolean dirty;

        TestVersionContext(IntSupplier closedTxIdSupplier) {
            this.closedTxIdSupplier = closedTxIdSupplier;
        }

        public void initRead() {
            this.lastClosedTxId = this.closedTxIdSupplier.getAsInt();
        }

        public void initWrite(long committingTxId) {
            this.committingTxId = committingTxId;
        }

        public long committingTransactionId() {
            return this.committingTxId;
        }

        public long lastClosedTransactionId() {
            return this.lastClosedTxId;
        }

        public long highestClosed() {
            return this.lastClosedTxId;
        }

        public void markAsDirty() {
            this.dirty = true;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public long[] notVisibleTransactionIds() {
            return ArrayUtils.EMPTY_LONG_ARRAY;
        }

        public long oldestVisibleTransactionNumber() {
            return 0L;
        }

        public void refreshVisibilityBoundaries() {
        }
    }

    private static class SingleVersionContextSupplier
    implements VersionContextSupplier {
        private final TestVersionContext versionContext;

        SingleVersionContextSupplier(TestVersionContext versionContext) {
            this.versionContext = versionContext;
        }

        public void init(TransactionIdSnapshotFactory transactionIdSnapshotFactory, OldestTransactionIdFactory oldestTransactionIdFactory) {
        }

        public VersionContext createVersionContext() {
            return this.versionContext;
        }
    }

    private static class InfoTracer
    extends DefaultPageCacheTracer {
        private final CopyOnWriteArrayList<ChunkInfo> observedChunks = new CopyOnWriteArrayList();
        private volatile int freeListSize;

        private InfoTracer() {
        }

        public CopyOnWriteArrayList<ChunkInfo> getObservedChunks() {
            return this.observedChunks;
        }

        public int getFreeListSize() {
            return this.freeListSize;
        }

        public PageCursorTracer createPageCursorTracer(String tag) {
            return new InfoPageCursorTracer((PageCacheTracer)this, tag);
        }

        public FileFlushEvent beginFileFlush(PageSwapper swapper) {
            return new FlushInfoFileFlushEvent();
        }

        public FileFlushEvent beginFileFlush() {
            return new FlushInfoFileFlushEvent();
        }

        private class InfoPageCursorTracer
        extends DefaultPageCursorTracer {
            InfoPageCursorTracer(PageCacheTracer pageCacheTracer, String tag) {
                super(pageCacheTracer, tag);
            }

            public PinEvent beginPin(boolean writeLock, long filePageId, PageSwapper swapper) {
                return new PinEvent(){

                    public void setCachePageId(long cachePageId) {
                    }

                    public PinPageFaultEvent beginPageFault(long filePageId, PageSwapper swapper) {
                        return new PinPageFaultEvent(){

                            public void addBytesRead(long bytes) {
                            }

                            public void setCachePageId(long cachePageId) {
                            }

                            public void setException(Throwable throwable) {
                            }

                            public void freeListSize(int listSize) {
                                InfoTracer.this.freeListSize = listSize;
                            }

                            public EvictionEvent beginEviction(long cachePageId) {
                                return null;
                            }

                            public void close() {
                            }
                        };
                    }

                    public void hit() {
                    }

                    public void noFault() {
                    }

                    public void close() {
                    }

                    public void snapshotsLoaded(int oldSnapshotsLoaded) {
                    }
                };
            }
        }

        private class FlushInfoFileFlushEvent
        implements FileFlushEvent {
            private FlushInfoFileFlushEvent() {
            }

            public void close() {
            }

            public FlushEvent beginFlush(long[] pageRefs, PageSwapper swapper, PageReferenceTranslator pageReferenceTranslator, int pagesToFlush, int mergedPages) {
                return FlushEvent.NULL;
            }

            public FlushEvent beginFlush(long pageRef, PageSwapper swapper, PageReferenceTranslator pageReferenceTranslator) {
                return FlushEvent.NULL;
            }

            public void startFlush(int[][] translationTable) {
            }

            public void reset() {
            }

            public long ioPerformed() {
                return 0L;
            }

            public long limitedNumberOfTimes() {
                return 0L;
            }

            public long limitedMillis() {
                return 0L;
            }

            public long pagesFlushed() {
                return 0L;
            }

            public FileFlushEvent.ChunkEvent startChunk(int[] chunk) {
                return new FlushInfoChunk();
            }

            public void throttle(long recentlyCompletedIOs, long millis) {
            }

            public void reportIO(int completedIOs) {
            }
        }

        private static class ChunkInfo {
            private final long notModifiedPages;
            private final long flushPerChunk;
            private final long buffersPerChunk;
            private final long mergesPerChunk;

            public long getNotModifiedPages() {
                return this.notModifiedPages;
            }

            public long getFlushPerChunk() {
                return this.flushPerChunk;
            }

            public long getBuffersPerChunk() {
                return this.buffersPerChunk;
            }

            public long getMergesPerChunk() {
                return this.mergesPerChunk;
            }

            ChunkInfo(long notModifiedPages, long flushPerChunk, long buffersPerChunk, long mergesPerChunk) {
                this.notModifiedPages = notModifiedPages;
                this.flushPerChunk = flushPerChunk;
                this.buffersPerChunk = buffersPerChunk;
                this.mergesPerChunk = mergesPerChunk;
            }
        }

        private class FlushInfoChunk
        extends FileFlushEvent.ChunkEvent {
            private FlushInfoChunk() {
            }

            public void chunkFlushed(long notModifiedPages, long flushPerChunk, long buffersPerChunk, long mergesPerChunk) {
                ChunkInfo chunkInfo = new ChunkInfo(notModifiedPages, flushPerChunk, buffersPerChunk, mergesPerChunk);
                InfoTracer.this.observedChunks.add(chunkInfo);
            }
        }
    }

    private class MultiChunkSwapperFilePageSwapperFactory
    extends SingleFilePageSwapperFactory {
        MultiChunkSwapperFilePageSwapperFactory(PageCacheTracer pageCacheTracer) {
            super(MuninnPageCacheTest.this.fs, pageCacheTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }

        public PageSwapper createPageSwapper(Path file, final int filePageSize, int reservedPageBytes, PageEvictionCallback onEviction, boolean createIfNotExist, boolean useDirectIO, boolean checksumPages, IOController ioController, SwapperSet swappers) throws IOException {
            return new DelegatingPageSwapper(super.createPageSwapper(file, filePageSize, reservedPageBytes, onEviction, createIfNotExist, useDirectIO, checksumPages, ioController, swappers)){

                public long write(long startFilePageId, long[] bufferAddresses, int[] bufferLengths, int length, int totalAffectedPages) throws IOException {
                    int flushedDataSize = 0;
                    for (int i = 0; i < length; ++i) {
                        flushedDataSize += bufferLengths[i];
                    }
                    ((AbstractIntegerAssert)Assertions.assertThat((int)(totalAffectedPages * filePageSize)).describedAs("Number of affected pages multiplied by page size should be equal to size of buffers we want to flush", new Object[0])).isEqualTo(flushedDataSize);
                    return super.write(startFilePageId, bufferAddresses, bufferLengths, length, totalAffectedPages);
                }
            };
        }
    }

    private static class FlushRendezvousTracer
    extends DefaultPageCacheTracer {
        private final CountDownLatch latch;

        FlushRendezvousTracer(int fileCountToWaitFor) {
            this.latch = new CountDownLatch(fileCountToWaitFor);
        }

        public FileFlushEvent beginFileFlush(PageSwapper swapper) {
            this.latch.countDown();
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return FileFlushEvent.NULL;
        }
    }
}

