/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.DelegatingPageSwapper;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class MuninnPageCursorTest {
    @Inject
    private TestDirectory directory;
    @Inject
    private FileSystemAbstraction fs;
    private JobScheduler jobScheduler;
    private final LifeSupport life = new LifeSupport();

    MuninnPageCursorTest() {
    }

    @BeforeEach
    void start() {
        this.jobScheduler = JobSchedulerFactory.createScheduler();
        this.life.add((Lifecycle)this.jobScheduler);
        this.life.start();
    }

    @AfterEach
    void stop() {
        this.life.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldUnlockLatchOnPageFaultingWhenConcurrentlyCursorClosed() throws IOException {
        Path file = this.directory.file("dude");
        this.createSomeData(file);
        AtomicBoolean enableException = new AtomicBoolean(false);
        Runnable onReadAction = () -> {
            if (enableException.get()) {
                throw new RuntimeException();
            }
        };
        try (PageCache pageCache = this.startPageCache(this.customSwapper(this.defaultPageSwapperFactory(), onReadAction));
             PagedFile pagedFile = pageCache.map(file, 8192, "neo4j", Sets.immutable.of((Object)StandardOpenOption.CREATE));){
            PageCursor cursor;
            try {
                cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);
                try {
                    enableException.set(true);
                    Assertions.assertThatThrownBy(() -> ((PageCursor)cursor).next()).isInstanceOf(RuntimeException.class);
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            finally {
                enableException.set(false);
            }
            cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);
            try {
                for (int i = 0; i < 100; ++i) {
                    cursor.next((long)i);
                    for (int j = 0; j < 100; ++j) {
                        org.junit.jupiter.api.Assertions.assertEquals((long)j, (long)cursor.getLong());
                    }
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void byteOrder() throws IOException {
        this.testByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.testByteOrder(ByteOrder.BIG_ENDIAN);
    }

    private void testByteOrder(ByteOrder byteOrder) throws IOException {
        Path file = this.directory.file("file" + byteOrder);
        try (PageCache pageCache = this.startPageCache(this.customSwapper(this.defaultPageSwapperFactory(), () -> {}));
             PagedFile pagedFile = pageCache.map(file, 8192, "neo4j", MuninnPageCursorTest.getOpenOptions(byteOrder));){
            try (PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
                Assertions.assertThat((Object)cursor.getByteOrder()).isEqualTo((Object)byteOrder);
            }
            cursor = pagedFile.io(0L, 1, CursorContext.NULL_CONTEXT);
            try {
                Assertions.assertThat((Object)cursor.getByteOrder()).isEqualTo((Object)byteOrder);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    private static ImmutableSet<OpenOption> getOpenOptions(ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return Sets.immutable.of((Object)StandardOpenOption.CREATE);
        }
        return Sets.immutable.of((Object)StandardOpenOption.CREATE, (Object)PageCacheOpenOptions.BIG_ENDIAN);
    }

    private PageCache startPageCache(PageSwapperFactory pageSwapperFactory) {
        return new MuninnPageCache(pageSwapperFactory, this.jobScheduler, MuninnPageCache.config((int)1000));
    }

    private void createSomeData(Path file) throws IOException {
        try (PageCache pageCache = this.startPageCache(this.defaultPageSwapperFactory());
             PagedFile pagedFile = pageCache.map(file, 8192, "neo4j", Sets.immutable.of((Object)StandardOpenOption.CREATE));
             PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL_CONTEXT);){
            for (int i = 0; i < 100; ++i) {
                cursor.next((long)i);
                for (int j = 0; j < 100; ++j) {
                    cursor.putLong((long)j);
                }
            }
        }
    }

    private PageSwapperFactory customSwapper(final PageSwapperFactory actual, final Runnable onRead) {
        return new PageSwapperFactory(){

            public PageSwapper createPageSwapper(Path path, int filePageSize, int reservedPageBytes, PageEvictionCallback onEviction, boolean createIfNotExist, boolean useDirectIO, boolean checksumPages, IOController ioController, SwapperSet swappers) throws IOException {
                PageSwapper actualSwapper = actual.createPageSwapper(path, filePageSize, reservedPageBytes, onEviction, createIfNotExist, useDirectIO, checksumPages, ioController, swappers);
                return new DelegatingPageSwapper(actualSwapper){

                    public long read(long filePageId, long bufferAddress) throws IOException {
                        onRead.run();
                        return super.read(filePageId, bufferAddress);
                    }
                };
            }
        };
    }

    private PageSwapperFactory defaultPageSwapperFactory() {
        return new SingleFilePageSwapperFactory(this.fs, (PageCacheTracer)new DefaultPageCacheTracer(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }
}

