/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.graphschema;

import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.procedure.builtin.graphschema.GraphSchema;
import org.neo4j.procedure.builtin.graphschema.Introspect;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.util.FeatureToggles;

@TestDirectoryExtension
class IntrospectSmokeIT {
    public static final String EXPECTED_FULL_RESULT = "{\n  \"graphSchemaRepresentation\" : {\n    \"graphSchema\" : {\n      \"nodeLabels\" : [ {\n        \"$id\" : \"nl:A\",\n        \"token\" : \"A\"\n      }, {\n        \"$id\" : \"nl:B\",\n        \"token\" : \"B\"\n      }, {\n        \"$id\" : \"nl:L1\",\n        \"token\" : \"L1\"\n      }, {\n        \"$id\" : \"nl:L `2\",\n        \"token\" : \"`L ``2`\"\n      }, {\n        \"$id\" : \"nl:L2\",\n        \"token\" : \"L2\"\n      }, {\n        \"$id\" : \"nl:L3\",\n        \"token\" : \"L3\"\n      }, {\n        \"$id\" : \"nl:Unrelated\",\n        \"token\" : \"Unrelated\"\n      }, {\n        \"$id\" : \"nl:B1\",\n        \"token\" : \"B1\"\n      }, {\n        \"$id\" : \"nl:A1\",\n        \"token\" : \"A1\"\n      }, {\n        \"$id\" : \"nl:B2\",\n        \"token\" : \"B2\"\n      }, {\n        \"$id\" : \"nl:A2\",\n        \"token\" : \"A2\"\n      }, {\n        \"$id\" : \"nl:Book\",\n        \"token\" : \"Book\"\n      }, {\n        \"$id\" : \"nl:Actor\",\n        \"token\" : \"Actor\"\n      }, {\n        \"$id\" : \"nl:Person\",\n        \"token\" : \"Person\"\n      }, {\n        \"$id\" : \"nl:SomeNode\",\n        \"token\" : \"SomeNode\"\n      } ],\n      \"relationshipTypes\" : [ {\n        \"$id\" : \"rt:REVIEWED\",\n        \"token\" : \"REVIEWED\"\n      }, {\n        \"$id\" : \"rt:RELATED_TO\",\n        \"token\" : \"RELATED_TO\"\n      }, {\n        \"$id\" : \"rt:A_TYPE\",\n        \"token\" : \"A_TYPE\"\n      }, {\n        \"$id\" : \"rt:`WEIRD_TYPE\",\n        \"token\" : \"```WEIRD_TYPE`\"\n      } ],\n      \"nodeObjectTypes\" : [ {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:A1\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:A1\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:A2\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:A2\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:A\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:A\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:Actor\"\n        }, {\n          \"$ref\" : \"#nl:Person\"\n        } ],\n        \"properties\" : [ {\n          \"token\" : \"name\",\n          \"type\" : {\n            \"type\" : \"string\"\n          },\n          \"nullable\" : false\n        }, {\n          \"token\" : \"id\",\n          \"type\" : [ {\n            \"type\" : \"array\",\n            \"items\" : {\n              \"type\" : \"integer\"\n            }\n          }, {\n            \"type\" : \"array\",\n            \"items\" : {\n              \"type\" : \"string\"\n            }\n          }, {\n            \"type\" : \"integer\"\n          }, {\n            \"type\" : \"string\"\n          }, {\n            \"type\" : \"array\",\n            \"items\" : {\n              \"type\" : \"float\"\n            }\n          } ],\n          \"nullable\" : true\n        }, {\n          \"token\" : \"f\",\n          \"type\" : [ {\n            \"type\" : \"integer\"\n          }, {\n            \"type\" : \"float\"\n          } ],\n          \"nullable\" : true\n        }, {\n          \"token\" : \"p\",\n          \"type\" : {\n            \"type\" : \"point\"\n          },\n          \"nullable\" : true\n        } ],\n        \"$id\" : \"n:Actor:Person\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:B1\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:B1\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:B2\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:B2\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:B\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:B\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:Book\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:Book\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:L `2\"\n        }, {\n          \"$ref\" : \"#nl:L1\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:L `2:L1\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:L1\"\n        }, {\n          \"$ref\" : \"#nl:L2\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:L1:L2\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:L2\"\n        }, {\n          \"$ref\" : \"#nl:L3\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:L2:L3\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:Person\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:Person\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:SomeNode\"\n        } ],\n        \"properties\" : [ {\n          \"token\" : \"idx\",\n          \"type\" : {\n            \"type\" : \"integer\"\n          },\n          \"nullable\" : false\n        } ],\n        \"$id\" : \"n:SomeNode\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:Unrelated\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:Unrelated\"\n      } ],\n      \"relationshipObjectTypes\" : [ {\n        \"type\" : {\n          \"$ref\" : \"#rt:A_TYPE\"\n        },\n        \"from\" : {\n          \"$ref\" : \"#n:A1\"\n        },\n        \"to\" : {\n          \"$ref\" : \"#n:B1\"\n        },\n        \"properties\" : [ {\n          \"token\" : \"x\",\n          \"type\" : {\n            \"type\" : \"string\"\n          },\n          \"nullable\" : false\n        } ],\n        \"$id\" : \"r:A_TYPE\"\n      }, {\n        \"type\" : {\n          \"$ref\" : \"#rt:A_TYPE\"\n        },\n        \"from\" : {\n          \"$ref\" : \"#n:A2\"\n        },\n        \"to\" : {\n          \"$ref\" : \"#n:B2\"\n        },\n        \"properties\" : [ {\n          \"token\" : \"x\",\n          \"type\" : {\n            \"type\" : \"string\"\n          },\n          \"nullable\" : false\n        } ],\n        \"$id\" : \"r:A_TYPE_1\"\n      }, {\n        \"type\" : {\n          \"$ref\" : \"#rt:RELATED_TO\"\n        },\n        \"from\" : {\n          \"$ref\" : \"#n:L `2:L1\"\n        },\n        \"to\" : {\n          \"$ref\" : \"#n:L2:L3\"\n        },\n        \"properties\" : [ {\n          \"token\" : \"since\",\n          \"type\" : {\n            \"type\" : \"datetime\"\n          },\n          \"nullable\" : false\n        }, {\n          \"token\" : \"since\",\n          \"type\" : {\n            \"type\" : \"datetime\"\n          },\n          \"nullable\" : false\n        } ],\n        \"$id\" : \"r:RELATED_TO\"\n      }, {\n        \"type\" : {\n          \"$ref\" : \"#rt:RELATED_TO\"\n        },\n        \"from\" : {\n          \"$ref\" : \"#n:L1:L2\"\n        },\n        \"to\" : {\n          \"$ref\" : \"#n:Unrelated\"\n        },\n        \"properties\" : [ {\n          \"token\" : \"since\",\n          \"type\" : {\n            \"type\" : \"datetime\"\n          },\n          \"nullable\" : false\n        } ],\n        \"$id\" : \"r:RELATED_TO_1\"\n      }, {\n        \"type\" : {\n          \"$ref\" : \"#rt:REVIEWED\"\n        },\n        \"from\" : {\n          \"$ref\" : \"#n:Person\"\n        },\n        \"to\" : {\n          \"$ref\" : \"#n:Book\"\n        },\n        \"properties\" : [ ],\n        \"$id\" : \"r:REVIEWED\"\n      }, {\n        \"type\" : {\n          \"$ref\" : \"#rt:`WEIRD_TYPE\"\n        },\n        \"from\" : {\n          \"$ref\" : \"#n:A\"\n        },\n        \"to\" : {\n          \"$ref\" : \"#n:B\"\n        },\n        \"properties\" : [ ],\n        \"$id\" : \"r:`WEIRD_TYPE\"\n      } ]\n    }\n  }\n}";
    public static final String EXPECTED_SAMPLED_RESULT = "{\n  \"graphSchemaRepresentation\" : {\n    \"graphSchema\" : {\n      \"nodeLabels\" : [ {\n        \"$id\" : \"nl:A\",\n        \"token\" : \"A\"\n      }, {\n        \"$id\" : \"nl:B\",\n        \"token\" : \"B\"\n      }, {\n        \"$id\" : \"nl:L1\",\n        \"token\" : \"L1\"\n      }, {\n        \"$id\" : \"nl:L `2\",\n        \"token\" : \"`L ``2`\"\n      }, {\n        \"$id\" : \"nl:L2\",\n        \"token\" : \"L2\"\n      }, {\n        \"$id\" : \"nl:L3\",\n        \"token\" : \"L3\"\n      }, {\n        \"$id\" : \"nl:Unrelated\",\n        \"token\" : \"Unrelated\"\n      }, {\n        \"$id\" : \"nl:B1\",\n        \"token\" : \"B1\"\n      }, {\n        \"$id\" : \"nl:A1\",\n        \"token\" : \"A1\"\n      }, {\n        \"$id\" : \"nl:B2\",\n        \"token\" : \"B2\"\n      }, {\n        \"$id\" : \"nl:A2\",\n        \"token\" : \"A2\"\n      }, {\n        \"$id\" : \"nl:Book\",\n        \"token\" : \"Book\"\n      }, {\n        \"$id\" : \"nl:Actor\",\n        \"token\" : \"Actor\"\n      }, {\n        \"$id\" : \"nl:Person\",\n        \"token\" : \"Person\"\n      }, {\n        \"$id\" : \"nl:SomeNode\",\n        \"token\" : \"SomeNode\"\n      } ],\n      \"relationshipTypes\" : [ {\n        \"$id\" : \"rt:REVIEWED\",\n        \"token\" : \"REVIEWED\"\n      }, {\n        \"$id\" : \"rt:RELATED_TO\",\n        \"token\" : \"RELATED_TO\"\n      }, {\n        \"$id\" : \"rt:A_TYPE\",\n        \"token\" : \"A_TYPE\"\n      }, {\n        \"$id\" : \"rt:`WEIRD_TYPE\",\n        \"token\" : \"```WEIRD_TYPE`\"\n      } ],\n      \"nodeObjectTypes\" : [ {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:A1\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:A1\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:A2\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:A2\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:A\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:A\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:Actor\"\n        }, {\n          \"$ref\" : \"#nl:Person\"\n        } ],\n        \"properties\" : [ {\n          \"token\" : \"name\",\n          \"type\" : {\n            \"type\" : \"string\"\n          },\n          \"nullable\" : false\n        }, {\n          \"token\" : \"id\",\n          \"type\" : [ {\n            \"type\" : \"array\",\n            \"items\" : {\n              \"type\" : \"integer\"\n            }\n          }, {\n            \"type\" : \"array\",\n            \"items\" : {\n              \"type\" : \"string\"\n            }\n          }, {\n            \"type\" : \"integer\"\n          }, {\n            \"type\" : \"string\"\n          }, {\n            \"type\" : \"array\",\n            \"items\" : {\n              \"type\" : \"float\"\n            }\n          } ],\n          \"nullable\" : true\n        }, {\n          \"token\" : \"f\",\n          \"type\" : [ {\n            \"type\" : \"integer\"\n          }, {\n            \"type\" : \"float\"\n          } ],\n          \"nullable\" : true\n        }, {\n          \"token\" : \"p\",\n          \"type\" : {\n            \"type\" : \"point\"\n          },\n          \"nullable\" : true\n        } ],\n        \"$id\" : \"n:Actor:Person\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:B1\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:B1\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:B2\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:B2\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:B\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:B\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:Book\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:Book\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:L `2\"\n        }, {\n          \"$ref\" : \"#nl:L1\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:L `2:L1\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:L1\"\n        }, {\n          \"$ref\" : \"#nl:L2\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:L1:L2\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:L2\"\n        }, {\n          \"$ref\" : \"#nl:L3\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:L2:L3\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:Person\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:Person\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:SomeNode\"\n        } ],\n        \"properties\" : [ {\n          \"token\" : \"idx\",\n          \"type\" : {\n            \"type\" : \"integer\"\n          },\n          \"nullable\" : false\n        } ],\n        \"$id\" : \"n:SomeNode\"\n      }, {\n        \"labels\" : [ {\n          \"$ref\" : \"#nl:Unrelated\"\n        } ],\n        \"properties\" : [ ],\n        \"$id\" : \"n:Unrelated\"\n      } ],\n      \"relationshipObjectTypes\" : [ {\n        \"type\" : {\n          \"$ref\" : \"#rt:A_TYPE\"\n        },\n        \"from\" : {\n          \"$ref\" : \"#n:A1\"\n        },\n        \"to\" : {\n          \"$ref\" : \"#n:B1\"\n        },\n        \"properties\" : [ {\n          \"token\" : \"x\",\n          \"type\" : {\n            \"type\" : \"string\"\n          },\n          \"nullable\" : false\n        } ],\n        \"$id\" : \"r:A_TYPE\"\n      }, {\n        \"type\" : {\n          \"$ref\" : \"#rt:RELATED_TO\"\n        },\n        \"from\" : {\n          \"$ref\" : \"#n:L `2:L1\"\n        },\n        \"to\" : {\n          \"$ref\" : \"#n:L2:L3\"\n        },\n        \"properties\" : [ {\n          \"token\" : \"since\",\n          \"type\" : {\n            \"type\" : \"datetime\"\n          },\n          \"nullable\" : false\n        }, {\n          \"token\" : \"since\",\n          \"type\" : {\n            \"type\" : \"datetime\"\n          },\n          \"nullable\" : false\n        } ],\n        \"$id\" : \"r:RELATED_TO\"\n      }, {\n        \"type\" : {\n          \"$ref\" : \"#rt:RELATED_TO\"\n        },\n        \"from\" : {\n          \"$ref\" : \"#n:L1:L2\"\n        },\n        \"to\" : {\n          \"$ref\" : \"#n:Unrelated\"\n        },\n        \"properties\" : [ {\n          \"token\" : \"since\",\n          \"type\" : {\n            \"type\" : \"datetime\"\n          },\n          \"nullable\" : false\n        } ],\n        \"$id\" : \"r:RELATED_TO_1\"\n      }, {\n        \"type\" : {\n          \"$ref\" : \"#rt:REVIEWED\"\n        },\n        \"from\" : {\n          \"$ref\" : \"#n:Person\"\n        },\n        \"to\" : {\n          \"$ref\" : \"#n:Book\"\n        },\n        \"properties\" : [ ],\n        \"$id\" : \"r:REVIEWED\"\n      }, {\n        \"type\" : {\n          \"$ref\" : \"#rt:`WEIRD_TYPE\"\n        },\n        \"from\" : {\n          \"$ref\" : \"#n:A\"\n        },\n        \"to\" : {\n          \"$ref\" : \"#n:B\"\n        },\n        \"properties\" : [ ],\n        \"$id\" : \"r:`WEIRD_TYPE\"\n      } ]\n    }\n  }\n}";
    private static final String DATABASE_NAME = "neo4j";
    @Inject
    private TestDirectory testDirectory;
    private DatabaseManagementService managementService;

    IntrospectSmokeIT() {
    }

    @BeforeEach
    void setUp() {
        this.managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).build();
        GraphDatabaseService database = this.managementService.database(DATABASE_NAME);
        database.executeTransactionally("MATCH (n) DETACH DELETE n");
        database.executeTransactionally("UNWIND range(1, 5) AS i\n\t\t\t\tWITH i CREATE (n:SomeNode {idx: i})\n");
        database.executeTransactionally("CREATE (:Actor:Person {name: 'Weird Id1', id: 'abc'})\nCREATE (:Actor:Person {name: 'Weird Id2', id: 4711})\nCREATE (:Actor:Person {name: 'Weird Id3', id: [\"pt1\", \"pt2\"]})\nCREATE (:Actor:Person {name: 'Weird Id4', id: [21, 23, 42]})\nCREATE (:Actor:Person {name: 'A compromise id', id: [0.5]})\nCREATE (:Actor:Person {name: 'A number', f: 0.5})\nCREATE (:Actor:Person {name: 'Another number', f: 50})\nCREATE (:Actor:Person {name: 'A point', p: point({latitude:toFloat('13.43'), longitude:toFloat('56.21')})})\nCREATE (:L1:`L ``2`) - [:RELATED_TO {since: datetime()}] -> (:L2:L3)\nCREATE (:L1:L2) - [:RELATED_TO {since: datetime()}] -> (:L2:L3)\nCREATE (:L1:L2) - [:RELATED_TO {since: datetime()}] -> (:Unrelated)\nCREATE (:Person) -[:REVIEWED] ->(:Book)\nCREATE (a:A) -[:```WEIRD_TYPE`] -> (:B)\n");
        database.executeTransactionally("CREATE (:A1) -[:A_TYPE {x: 'hallo'}]-> (:B1)\n".repeat((int)(GraphSchema.Introspector.DEFAULT_SAMPLE_SIZE * 10L)) + "CREATE (:A2) -[:A_TYPE {x: 'hallo'}]-> (:B2)\n");
    }

    @AfterEach
    void tearDown() {
        this.managementService.shutdown();
    }

    static Stream<Arguments> smokeTest() {
        return Stream.of(Arguments.of((Object[])new Object[]{EXPECTED_FULL_RESULT, false}), Arguments.of((Object[])new Object[]{EXPECTED_SAMPLED_RESULT, true}));
    }

    @ParameterizedTest(name="sample only: {1}")
    @MethodSource
    void smokeTest(String expected, boolean sampleOnly) {
        Object result = this.managementService.database(DATABASE_NAME).executeTransactionally("CALL internal.introspect.asJson({useConstantIds: true, prettyPrint: true, sampleOnly: $sampleOnly}) YIELD value RETURN value AS result", Map.of("sampleOnly", sampleOnly), r -> r.next().get("result"));
        Assertions.assertThat((Object)result).isEqualTo((Object)expected);
    }

    static {
        FeatureToggles.set(Introspect.class, (String)"enabled", (Object)true);
    }
}

