/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.SystemUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.bouncycastle.util.Arrays;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.ConnectorType;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.NeoBootstrapper;
import org.neo4j.server.WebContainerTestUtils;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.conditions.Conditions;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;
import org.neo4j.test.ssl.SelfSignedCertificateFactory;

public abstract class BaseBootstrapperIT
extends ExclusiveWebContainerTestBase {
    protected NeoBootstrapper bootstrapper;

    @BeforeEach
    void before() {
        this.bootstrapper = this.newBootstrapper();
        SelfSignedCertificateFactory.create((FileSystemAbstraction)this.testDirectory.getFileSystem(), (Path)this.testDirectory.homePath());
    }

    @AfterEach
    void after() {
        if (this.bootstrapper != null) {
            this.bootstrapper.stop();
        }
    }

    protected abstract NeoBootstrapper newBootstrapper();

    @Test
    void shouldStartStopNeoServerWithoutAnyConfigFiles() {
        int resultCode = NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])BaseBootstrapperIT.withConnectorsOnRandomPortsConfig(this.getAdditionalArguments()));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)resultCode);
        Assert.assertEventually((String)"Server was not started", () -> ((NeoBootstrapper)this.bootstrapper).isRunning(), (Condition)Conditions.TRUE, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    protected String[] getAdditionalArguments() {
        return new String[]{"--home-dir", this.testDirectory.directory("home-dir").toAbsolutePath().toString(), "-c", BaseBootstrapperIT.configOption((Setting<Path>)GraphDatabaseSettings.data_directory, this.testDirectory.absolutePath()), "-c", BaseBootstrapperIT.configOption((Setting<Path>)GraphDatabaseSettings.logs_directory, this.testDirectory.absolutePath())};
    }

    @Test
    void canSpecifyConfigFile() throws Throwable {
        Path configFile = this.testDirectory.file("neo4j.conf");
        Map properties = MapUtil.stringMap((String[])new String[]{GraphDatabaseInternalSettings.forced_kernel_id.name(), "ourcustomvalue"});
        properties.putAll(WebContainerTestUtils.getDefaultRelativeProperties((Path)this.testDirectory.homePath()));
        properties.putAll(BaseBootstrapperIT.connectorsOnRandomPortsConfig());
        MapUtil.store((Map)properties, (Path)configFile);
        NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])new String[]{"--home-dir", this.testDirectory.directory("home-dir").toAbsolutePath().toString(), "--config-dir", configFile.getParent().toAbsolutePath().toString()});
        DependencyResolver dependencyResolver = this.getDependencyResolver();
        Assertions.assertThat((String)((String)((Config)dependencyResolver.resolveDependency(Config.class)).get(GraphDatabaseInternalSettings.forced_kernel_id))).isEqualTo("ourcustomvalue");
    }

    @Test
    void canOverrideConfigValues() throws Throwable {
        Path configFile = this.testDirectory.file("neo4j.conf");
        Map properties = MapUtil.stringMap((String[])new String[]{GraphDatabaseInternalSettings.forced_kernel_id.name(), "thisshouldnotshowup"});
        properties.putAll(WebContainerTestUtils.getDefaultRelativeProperties((Path)this.testDirectory.homePath()));
        properties.putAll(BaseBootstrapperIT.connectorsOnRandomPortsConfig());
        MapUtil.store((Map)properties, (Path)configFile);
        NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])new String[]{"--home-dir", this.testDirectory.directory("home-dir").toAbsolutePath().toString(), "--config-dir", configFile.getParent().toAbsolutePath().toString(), "-c", BaseBootstrapperIT.configOption(GraphDatabaseInternalSettings.forced_kernel_id, "mycustomvalue")});
        DependencyResolver dependencyResolver = this.getDependencyResolver();
        Assertions.assertThat((String)((String)((Config)dependencyResolver.resolveDependency(Config.class)).get(GraphDatabaseInternalSettings.forced_kernel_id))).isEqualTo("mycustomvalue");
    }

    @Test
    void shouldStartWithHttpHttpsAndBoltDisabled() {
        this.testStartupWithConnectors(false, false, false);
    }

    @Test
    void shouldStartWithHttpEnabledAndHttpsBoltDisabled() {
        this.testStartupWithConnectors(true, false, false);
    }

    @Test
    void shouldStartWithHttpsEnabledAndHttpBoltDisabled() {
        this.testStartupWithConnectors(false, true, false);
    }

    @Test
    void shouldStartWithBoltEnabledAndHttpHttpsDisabled() {
        this.testStartupWithConnectors(false, false, true);
    }

    @Test
    void shouldStartWithHttpHttpsEnabledAndBoltDisabled() {
        this.testStartupWithConnectors(true, true, false);
    }

    @Test
    void shouldStartWithHttpBoltEnabledAndHttpsDisabled() {
        this.testStartupWithConnectors(true, false, true);
    }

    @Test
    void shouldStartWithHttpsBoltEnabledAndHttpDisabled() {
        this.testStartupWithConnectors(false, true, true);
    }

    @Test
    void shouldHaveSameLayoutAsEmbedded() {
        Path serverDir = this.testDirectory.directory("server-dir");
        NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])BaseBootstrapperIT.withConnectorsOnRandomPortsConfig("--home-dir", serverDir.toAbsolutePath().toString()));
        Assert.assertEventually((String)"Server was not started", () -> ((NeoBootstrapper)this.bootstrapper).isRunning(), (Condition)Conditions.TRUE, (long)1L, (TimeUnit)TimeUnit.MINUTES);
        GraphDatabaseAPI databaseAPI = (GraphDatabaseAPI)this.bootstrapper.getDatabaseManagementService().database("neo4j");
        Neo4jLayout serverLayout = databaseAPI.databaseLayout().getNeo4jLayout();
        this.bootstrapper.stop();
        Path embeddedDir = this.testDirectory.directory("embedded-dir");
        DatabaseManagementService dbms = this.newEmbeddedDbms(embeddedDir);
        Neo4jLayout embeddedLayout = ((GraphDatabaseAPI)dbms.database("neo4j")).databaseLayout().getNeo4jLayout();
        dbms.shutdown();
        org.junit.jupiter.api.Assertions.assertEquals((Object)serverDir.relativize(serverLayout.homeDirectory()), (Object)embeddedDir.relativize(embeddedLayout.homeDirectory()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)serverDir.relativize(serverLayout.databasesDirectory()), (Object)embeddedDir.relativize(embeddedLayout.databasesDirectory()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)serverDir.relativize(serverLayout.transactionLogsRootDirectory()), (Object)embeddedDir.relativize(embeddedLayout.transactionLogsRootDirectory()));
    }

    @Test
    void shouldOnlyAllowCommandExpansionWhenProvidedAsArgument() {
        String setting = String.format("%s=$(%s 100 * 1000)", GraphDatabaseSettings.dense_node_threshold.name(), SystemUtils.IS_OS_WINDOWS ? "cmd.exe /c set /a" : "expr");
        String[] args = BaseBootstrapperIT.withConnectorsOnRandomPortsConfig("--home-dir", this.testDirectory.homePath().toString(), "-c", setting);
        Assertions.assertThatThrownBy(() -> NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])args)).hasMessageContaining("is a command, but config is not explicitly told to expand it");
        NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])Arrays.append((String[])args, (String)"--expand-commands"));
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.bootstrapper.getDatabaseManagementService().database("neo4j");
        Config config = (Config)db.getDependencyResolver().resolveDependency(Config.class);
        Assertions.assertThat((Integer)((Integer)config.get(GraphDatabaseSettings.dense_node_threshold))).isEqualTo(100000L);
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    void shouldWriteAndDeletePidFile() {
        int resultCode = NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])new String[]{"--home-dir", this.testDirectory.homePath().toString()});
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)resultCode);
        Assert.assertEventually((String)"Server was not started", () -> ((NeoBootstrapper)this.bootstrapper).isRunning(), (Condition)Conditions.TRUE, (long)1L, (TimeUnit)TimeUnit.MINUTES);
        Path pidFile = (Path)((Config)this.getDependencyResolver().resolveDependency(Config.class)).get(BootloaderSettings.pid_file);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Files.exists(pidFile, new LinkOption[0]));
        this.bootstrapper.stop();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Files.exists(pidFile, new LinkOption[0]));
    }

    @Test
    void loggingConfigurationErrorsShouldPreventStartup() throws IOException {
        Path log4jConfig = this.testDirectory.file("user-logs.xml");
        FileSystemUtils.writeString((FileSystemAbstraction)this.testDirectory.getFileSystem(), (Path)log4jConfig, (String)"<Configuration><", (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        String[] args = new String[]{"--home-dir", this.testDirectory.homePath().toString(), "-c", BaseBootstrapperIT.configOption((Setting<Path>)GraphDatabaseSettings.user_logging_config_path, log4jConfig)};
        int resultCode = NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])args);
        Assertions.assertThat((int)resultCode).isEqualTo(3);
        Assertions.assertThat((boolean)this.suppressOutput.getErrorVoice().containsMessage("[Fatal Error] user-logs.xml:")).isTrue();
    }

    @Test
    void signalParentProcessInNonConsoleMode() {
        int resultCode = NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])new String[]{"--home-dir", this.testDirectory.homePath().toString()});
        Assertions.assertThat((int)resultCode).isEqualTo(0);
        Assertions.assertThat((String)this.suppressOutput.getErrorVoice().toString()).contains(new CharSequence[]{String.valueOf('\u0006')});
    }

    @Test
    void dontSignalParentProcessInConsoleMode() {
        int resultCode = NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])new String[]{"--home-dir", this.testDirectory.homePath().toString(), "--console-mode"});
        Assertions.assertThat((int)resultCode).isEqualTo(0);
        Assertions.assertThat((String)this.suppressOutput.getErrorVoice().toString()).doesNotContain(new CharSequence[]{String.valueOf('\u0006')});
    }

    @Test
    void debugLogToSystemOutInConsoleMode() throws IOException {
        String log4jConfig = "<Configuration status=\"ERROR\" packages=\"org.neo4j.logging.log4j\">\n    <Appenders>\n        <Console name=\"ConsoleAppender\" target=\"SYSTEM_OUT\">\n            <PatternLayout pattern=\"%d{yyyy-MM-dd HH:mm:ss.SSSZ}{GMT+0} %-5p %m%n\"/>\n        </Console>\n    </Appenders>\n    <Loggers>\n        <Root level=\"INFO\">\n            <AppenderRef ref=\"ConsoleAppender\"/>\n        </Root>\n    </Loggers>\n</Configuration>\n";
        Path xmlConfig = this.testDirectory.file("serverConsoleLogger.xml");
        FileSystemUtils.writeString((FileSystemAbstraction)this.testDirectory.getFileSystem(), (Path)xmlConfig, (String)log4jConfig, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        int resultCode = NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])new String[]{"--home-dir", this.testDirectory.homePath().toString(), "--console-mode", "-c", BaseBootstrapperIT.configOption(GraphDatabaseSettings.server_logging_config_path, xmlConfig.toAbsolutePath().toString())});
        Assertions.assertThat((int)resultCode).isEqualTo(0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.suppressOutput.getOutputVoice().containsMessage("[ System diagnostics ]"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.suppressOutput.getOutputVoice().containsMessage("[ System memory information ]"));
    }

    protected abstract DatabaseManagementService newEmbeddedDbms(Path var1);

    protected static Map<String, String> connectorsOnRandomPortsConfig() {
        return MapUtil.stringMap((String[])new String[]{HttpConnector.listen_address.name(), "localhost:0", HttpConnector.advertised_address.name(), ":0", HttpConnector.enabled.name(), "true", HttpsConnector.listen_address.name(), "localhost:0", HttpsConnector.advertised_address.name(), ":0", HttpsConnector.enabled.name(), "false", BoltConnector.listen_address.name(), "localhost:0", BoltConnector.advertised_address.name(), ":0", BoltConnector.encryption_level.name(), "DISABLED", BoltConnector.enabled.name(), "true"});
    }

    static String configOption(Setting<?> setting, String value) {
        return setting.name() + "=" + value;
    }

    static String configOption(Setting<Boolean> setting, boolean value) {
        return setting.name() + "=" + (value ? "true" : "false");
    }

    protected static String configOption(Setting<Path> setting, Path value) {
        return setting.name() + "=" + FileSystemUtils.pathToString((Path)value);
    }

    protected static String[] withConnectorsOnRandomPortsConfig(String ... otherConfigs) {
        Stream<String> configs = Stream.of(otherConfigs);
        Stream connectorsConfig = BaseBootstrapperIT.connectorsOnRandomPortsConfig().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).flatMap(config -> Stream.of("-c", config));
        return (String[])Stream.concat(configs, connectorsConfig).toArray(String[]::new);
    }

    private void testStartupWithConnectors(boolean httpEnabled, boolean httpsEnabled, boolean boltEnabled) {
        SslPolicyConfig httpsPolicy = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.HTTPS);
        if (httpsEnabled) {
            SelfSignedCertificateFactory.create((FileSystemAbstraction)this.testDirectory.getFileSystem(), (Path)this.testDirectory.absolutePath());
        }
        Object[] config = new String[]{"-c", BaseBootstrapperIT.configOption((Setting<Boolean>)httpsPolicy.enabled, httpsEnabled), "-c", BaseBootstrapperIT.configOption((Setting<Path>)httpsPolicy.base_directory, this.testDirectory.homePath()), "-c", BaseBootstrapperIT.configOption((Setting<Boolean>)HttpConnector.enabled, httpEnabled), "-c", BaseBootstrapperIT.configOption(HttpConnector.listen_address, "localhost:0"), "-c", BaseBootstrapperIT.configOption(HttpConnector.advertised_address, ":0"), "-c", BaseBootstrapperIT.configOption((Setting<Boolean>)HttpsConnector.enabled, httpsEnabled), "-c", BaseBootstrapperIT.configOption(HttpsConnector.listen_address, "localhost:0"), "-c", BaseBootstrapperIT.configOption(HttpsConnector.advertised_address, ":0"), "-c", BaseBootstrapperIT.configOption((Setting<Boolean>)BoltConnector.enabled, boltEnabled), "-c", BaseBootstrapperIT.configOption(BoltConnector.listen_address, "localhost:0"), "-c", BaseBootstrapperIT.configOption(BoltConnector.advertised_address, ":0")};
        String[] allConfigOptions = (String[])ArrayUtils.addAll((Object[])config, (Object[])this.getAdditionalArguments());
        int resultCode = NeoBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])allConfigOptions);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)resultCode);
        Assert.assertEventually((String)"Server was not started", () -> ((NeoBootstrapper)this.bootstrapper).isRunning(), (Condition)Conditions.TRUE, (long)1L, (TimeUnit)TimeUnit.MINUTES);
        this.assertDbAccessibleAsEmbedded();
        WebContainerTestUtils.verifyConnector((GraphDatabaseService)this.db(), (ConnectorType)ConnectorType.HTTP, (boolean)httpEnabled);
        WebContainerTestUtils.verifyConnector((GraphDatabaseService)this.db(), (ConnectorType)ConnectorType.HTTPS, (boolean)httpsEnabled);
        WebContainerTestUtils.verifyConnector((GraphDatabaseService)this.db(), (ConnectorType)ConnectorType.BOLT, (boolean)boltEnabled);
    }

    private void assertDbAccessibleAsEmbedded() {
        GraphDatabaseAPI db = this.db();
        Label label = () -> "Node";
        String propertyKey = "key";
        String propertyValue = "value";
        try (Transaction tx = db.beginTx();){
            tx.createNode(new Label[]{label}).setProperty(propertyKey, (Object)propertyValue);
            tx.commit();
        }
        tx = db.beginTx();
        try {
            Node node = (Node)Iterators.single((Iterator)tx.findNodes(label));
            org.junit.jupiter.api.Assertions.assertEquals((Object)propertyValue, (Object)node.getProperty(propertyKey));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private GraphDatabaseAPI db() {
        return (GraphDatabaseAPI)this.bootstrapper.getDatabaseManagementService().database("neo4j");
    }

    private DependencyResolver getDependencyResolver() {
        return this.db().getDependencyResolver();
    }
}

