/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.lang.management.MemoryUsage;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.mockito.Mockito;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.memory.MachineMemory;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.server.NeoBootstrapper;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SuppressOutput;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
@ExtendWith(value={SuppressOutputExtension.class})
@ResourceLock(value="java.lang.System.out")
class NeoBootstrapperTest {
    @Inject
    private TestDirectory homeDir;
    @Inject
    private SuppressOutput suppress;
    private NeoBootstrapper neoBootstrapper;
    private Path dir;
    private Path userLog;

    NeoBootstrapperTest() {
    }

    @AfterEach
    void tearDown() throws IOException {
        if (this.neoBootstrapper != null) {
            this.neoBootstrapper.stop();
            ((ObjectAssert)Assertions.assertThat(this.getUserLogFiles()).last()).asString().endsWith((CharSequence)"Stopped.");
        }
    }

    @BeforeEach
    void setUp() {
        this.dir = this.homeDir.directory("test-server-bootstrapper");
        this.userLog = this.dir.resolve("logs").resolve("neo4j.log");
    }

    @Test
    void shouldNotThrowNullPointerExceptionIfConfigurationValidationFails() throws IOException {
        this.neoBootstrapper = new CommunityBootstrapper();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.neoBootstrapper.start(this.dir, Map.of("initial.dbms.default_database", "$%^&*#)@!"))).isInstanceOf(IllegalArgumentException.class)).hasNoSuppressedExceptions().rootCause().isInstanceOf(IllegalArgumentException.class);
        this.neoBootstrapper.stop();
        ((ObjectAssert)Assertions.assertThat((List)this.suppress.getOutputVoice().lines()).last()).asString().endsWith((CharSequence)"Stopped.");
        this.neoBootstrapper = null;
    }

    @Test
    void shouldFailToStartIfRequestedPageCacheMemoryExceedsTotal() throws IOException {
        this.neoBootstrapper = new CommunityBootstrapper();
        Map config = MapUtil.stringMap((String[])new String[0]);
        config.put(GraphDatabaseSettings.pagecache_memory.name(), "10B");
        MachineMemory mockedMemory = (MachineMemory)Mockito.mock(MachineMemory.class);
        MemoryUsage heapMemory = new MemoryUsage(0L, 1L, 1L, 1L);
        Mockito.when((Object)mockedMemory.getTotalPhysicalMemory()).thenReturn((Object)8L);
        Mockito.when((Object)mockedMemory.getHeapMemoryUsage()).thenReturn((Object)heapMemory);
        this.neoBootstrapper.setMachineMemory(mockedMemory);
        Assertions.assertThat((int)this.neoBootstrapper.start(this.dir, config)).isNotEqualTo(0);
        Assertions.assertThat(this.getUserLogFiles()).anySatisfy(line -> Assertions.assertThat((String)line).containsSubsequence(new CharSequence[]{"Invalid memory configuration - exceeds physical memory."}));
    }

    @Test
    void shouldFailToStartIfRequestedHeapMemoryExceedsTotal() throws IOException {
        this.neoBootstrapper = new CommunityBootstrapper();
        Map config = MapUtil.stringMap((String[])new String[0]);
        config.put(BootloaderSettings.max_heap_size.name(), "10B");
        config.put(GraphDatabaseSettings.pagecache_memory.name(), "1B");
        MachineMemory mockedMemory = (MachineMemory)Mockito.mock(MachineMemory.class);
        MemoryUsage heapMemory = new MemoryUsage(0L, 1L, 1L, 10L);
        Mockito.when((Object)mockedMemory.getTotalPhysicalMemory()).thenReturn((Object)8L);
        Mockito.when((Object)mockedMemory.getHeapMemoryUsage()).thenReturn((Object)heapMemory);
        this.neoBootstrapper.setMachineMemory(mockedMemory);
        Assertions.assertThat((int)this.neoBootstrapper.start(this.dir, config)).isNotEqualTo(0);
        Assertions.assertThat(this.getUserLogFiles()).anySatisfy(line -> Assertions.assertThat((String)line).containsSubsequence(new CharSequence[]{"Invalid memory configuration - exceeds physical memory."}));
    }

    @Test
    void shouldFailToStartIfRequestedHeapAndPageCacheMemoryExceedsTotal() throws IOException {
        this.neoBootstrapper = new CommunityBootstrapper();
        Map config = MapUtil.stringMap((String[])new String[0]);
        config.put(BootloaderSettings.max_heap_size.name(), "10B");
        config.put(GraphDatabaseSettings.pagecache_memory.name(), "10B");
        MachineMemory mockedMemory = (MachineMemory)Mockito.mock(MachineMemory.class);
        MemoryUsage heapMemory = new MemoryUsage(0L, 1L, 1L, 10L);
        Mockito.when((Object)mockedMemory.getTotalPhysicalMemory()).thenReturn((Object)18L);
        Mockito.when((Object)mockedMemory.getHeapMemoryUsage()).thenReturn((Object)heapMemory);
        this.neoBootstrapper.setMachineMemory(mockedMemory);
        Assertions.assertThat((int)this.neoBootstrapper.start(this.dir, config)).isNotEqualTo(0);
        Assertions.assertThat(this.getUserLogFiles()).anySatisfy(line -> Assertions.assertThat((String)line).containsSubsequence(new CharSequence[]{"Invalid memory configuration - exceeds physical memory."}));
    }

    @Test
    void shouldFailToStartIfCalculatedPageCacheSizeExceedsTotalMemory() throws IOException {
        this.neoBootstrapper = new CommunityBootstrapper();
        Map config = MapUtil.stringMap((String[])new String[0]);
        config.put(BootloaderSettings.max_heap_size.name(), "10B");
        MachineMemory mockedMemory = (MachineMemory)Mockito.mock(MachineMemory.class);
        MemoryUsage heapMemory = new MemoryUsage(0L, 1L, 1L, 10L);
        Mockito.when((Object)mockedMemory.getTotalPhysicalMemory()).thenReturn((Object)1000L);
        Mockito.when((Object)mockedMemory.getHeapMemoryUsage()).thenReturn((Object)heapMemory);
        this.neoBootstrapper.setMachineMemory(mockedMemory);
        Assertions.assertThat((int)this.neoBootstrapper.start(this.dir, config)).isNotEqualTo(0);
        Assertions.assertThat(this.getUserLogFiles()).anySatisfy(line -> Assertions.assertThat((String)line).containsSubsequence(new CharSequence[]{"Invalid memory configuration - exceeds physical memory."}));
    }

    @Test
    void ignoreMemoryChecksIfTotalMemoryIsNotAvailable() throws IOException {
        this.neoBootstrapper = new CommunityBootstrapper();
        Map config = MapUtil.stringMap((String[])new String[0]);
        MachineMemory mockedMemory = (MachineMemory)Mockito.mock(MachineMemory.class);
        MemoryUsage heapMemory = new MemoryUsage(0L, 1L, 1L, 10L);
        Mockito.when((Object)mockedMemory.getTotalPhysicalMemory()).thenReturn((Object)0L);
        Mockito.when((Object)mockedMemory.getHeapMemoryUsage()).thenReturn((Object)heapMemory);
        this.neoBootstrapper.setMachineMemory(mockedMemory);
        Assertions.assertThat((int)this.neoBootstrapper.start(this.dir, config)).isEqualTo(0);
        Assertions.assertThat(this.getUserLogFiles()).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{"Unable to determine total physical memory of machine."}));
    }

    private List<String> getUserLogFiles() throws IOException {
        return Files.readAllLines(this.userLog, StandardCharsets.UTF_8);
    }
}

