/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.LongSupplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.pagecache.context.TransactionIdSnapshot;
import org.neo4j.io.pagecache.context.TransactionIdSnapshotFactory;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.snapshot.TestTransactionVersionContextSupplier;
import org.neo4j.snapshot.TestVersionContext;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;
import org.neo4j.test.server.HTTP;

class SnapshotQueryExecutionIT
extends ExclusiveWebContainerTestBase {
    private TestWebContainer testWebContainer;
    private LongSupplier lastTransactionIdSource;
    private final CopyOnWriteArrayList<TestVersionContext> contexts = new CopyOnWriteArrayList();
    private volatile boolean enabledTestContexts = false;
    private final TransactionIdSnapshotFactory transactionIdSnapshotFactory = () -> new TransactionIdSnapshot(this.lastTransactionIdSource.getAsLong());

    SnapshotQueryExecutionIT() {
    }

    @BeforeEach
    void setUp() throws Exception {
        TestTransactionVersionContextSupplier.Factory testContextSupplierFactory = new TestTransactionVersionContextSupplier.Factory();
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependencies(new Object[]{testContextSupplierFactory});
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(GraphDatabaseInternalSettings.snapshot_query.name(), "true").withDependencies((DependencyResolver)dependencies).build();
        GraphDatabaseFacade db = this.testWebContainer.getDefaultDatabase();
        testContextSupplierFactory.setTestVersionContextSupplier(databaseName -> {
            if (this.enabledTestContexts) {
                TestVersionContext context = TestVersionContext.testCursorContext((TransactionIdSnapshotFactory)this.transactionIdSnapshotFactory, (String)databaseName);
                this.contexts.add(context);
                return context;
            }
            return new TestVersionContext(TransactionIdSnapshotFactory.EMPTY_SNAPSHOT_FACTORY, databaseName);
        });
        SnapshotQueryExecutionIT.createData((GraphDatabaseService)db);
    }

    private static void createData(GraphDatabaseService database) {
        Label label = Label.label((String)"toRetry");
        try (Transaction transaction = database.beginTx();){
            Node node = transaction.createNode(new Label[]{label});
            node.setProperty("c", (Object)"d");
            transaction.commit();
        }
    }

    @AfterEach
    void tearDown() {
        if (this.testWebContainer != null) {
            this.testWebContainer.shutdown();
        }
    }

    @Test
    void executeQueryWithSingleRetry() {
        this.lastTransactionIdSource = new ArrayBasedLongSupplier();
        this.enabledTestContexts = true;
        HTTP.Response response = this.executeOverHTTP("MATCH (n) RETURN n.c");
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        Map content = (Map)response.content();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"d", ((List)((Map)((List)((Map)((List)content.get("results")).get(0)).get("data")).get(0)).get("row")).get(0));
        TestVersionContext testVersionContext = this.findCorrespondingContext();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)testVersionContext.getAdditionalAttempts());
    }

    @Test
    void queryThatModifiesDataAndSeesUnstableSnapshotShouldThrowException() {
        this.lastTransactionIdSource = () -> 1L;
        this.enabledTestContexts = true;
        HTTP.Response response = this.executeOverHTTP("MATCH (n:toRetry) CREATE () RETURN n.c");
        Map content = (Map)response.content();
        Assertions.assertThat((String)((String)((Map)((List)content.get("errors")).get(0)).get("message"))).startsWith((CharSequence)"Unable to get clean data snapshot for query");
    }

    private TestVersionContext findCorrespondingContext() {
        for (TestVersionContext context : this.contexts) {
            if (context.getNumIsDirtyCalls() <= 0) continue;
            return context;
        }
        throw new IllegalStateException("Should have at least one matching context. Observed contexts: " + this.contexts);
    }

    private HTTP.Response executeOverHTTP(String query) {
        HTTP.Builder httpClientBuilder = HTTP.withBaseUri((URI)this.testWebContainer.getBaseUri());
        HTTP.Response transactionStart = httpClientBuilder.POST(SnapshotQueryExecutionIT.txEndpoint());
        Assertions.assertThat((int)transactionStart.status()).isEqualTo(201);
        return httpClientBuilder.POST(transactionStart.location(), HTTP.RawPayload.quotedJson((String)("{ 'statements': [ { 'statement': '" + query + "' } ] }")));
    }

    private static class ArrayBasedLongSupplier
    implements LongSupplier {
        private final long[] values = new long[]{1L, Long.MAX_VALUE};
        private int index;

        private ArrayBasedLongSupplier() {
        }

        @Override
        public long getAsLong() {
            return this.index >= this.values.length ? this.values[this.values.length - 1] : this.values[this.index++];
        }
    }
}

