/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storemigration;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.mutable.MutableInt;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.ConsistencyCheckIncompleteException;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.kernel.DbStatistics;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.ZippedStore;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.storageengine.api.SchemaRule44;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storemigration.InitialIndexStateMonitor;
import org.neo4j.storemigration.StoreMigrationTestUtils;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.utils.TestDirectory;

@Neo4jLayoutExtension
public abstract class DatabaseMigrationITBase {
    @Inject
    protected TestDirectory directory;
    @Inject
    protected Neo4jLayout layout;

    protected abstract TestDatabaseManagementServiceBuilder newDbmsBuilder(Path var1);

    protected abstract void verifySystemDbSchema(GraphDatabaseService var1, SystemDbMigration var2);

    protected void migrateOrRemoveSystemDatabase(ZippedStore zippedStore, Neo4jLayout layout) throws IOException {
        StoreMigrationTestUtils.Result result = StoreMigrationTestUtils.runStoreMigrationCommandFromSameJvm((Neo4jLayout)layout, (String[])new String[]{"system"});
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.exitCode()).withFailMessage(result.err(), new Object[0])).isEqualTo(0);
    }

    protected StoreMigrationTestUtils.Result migrate(Neo4jLayout neo4jLayout, String ... args) {
        return StoreMigrationTestUtils.runStoreMigrationCommandFromSameJvm((Neo4jLayout)neo4jLayout, (String[])args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doShouldMigrateDatabase(ZippedStore zippedStore, String toRecordFormat) throws IOException, ConsistencyCheckIncompleteException {
        Path homeDir = this.layout.homeDirectory();
        zippedStore.unzip(homeDir);
        StoreMigrationTestUtils.Result result = this.migrate(this.layout, "--to-format", toRecordFormat, "--verbose", "neo4j");
        ((AbstractIntegerAssert)Assertions.assertThat((int)result.exitCode()).withFailMessage(result.err(), new Object[0])).isEqualTo(0);
        this.migrateOrRemoveSystemDatabase(zippedStore, this.layout);
        DatabaseManagementService dbms = this.newDbmsBuilder(homeDir).build();
        try {
            GraphDatabaseService db = dbms.database("neo4j");
            this.verifyContents(db, zippedStore.statistics());
            this.verifyStoreFormat(db, this.expectedFormat(db, toRecordFormat));
            DatabaseMigrationITBase.verifyTokenIndexes(db);
            DatabaseMigrationITBase.verifyKernelVersion(db);
            this.verifyRemovedIndexProviders(db);
            DatabaseMigrationITBase.verifyFulltextIndexes(db, zippedStore.statistics().kernelVersion());
        }
        finally {
            dbms.shutdown();
        }
        DatabaseMigrationITBase.consistencyCheck(homeDir, "neo4j");
    }

    protected RecordFormats expectedFormat(GraphDatabaseService db, String toRecordFormat) {
        Config config = (Config)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(Config.class);
        return RecordFormatSelector.findLatestFormatInFamily((String)toRecordFormat, (Config)config);
    }

    protected void doShouldMigrateSystemDatabaseAndOthers(SystemDbMigration systemDbMigration) throws IOException, ConsistencyCheckIncompleteException {
        this.doShouldMigrateSystemDatabase(systemDbMigration, neo4jLayout -> {
            StoreMigrationTestUtils.Result result = this.migrate((Neo4jLayout)neo4jLayout, "--verbose", "*");
            ((AbstractIntegerAssert)Assertions.assertThat((int)result.exitCode()).withFailMessage(result.err(), new Object[0])).isEqualTo(0);
        });
    }

    protected void doShouldMigrateSystemDatabase(SystemDbMigration systemDbMigration) throws IOException, ConsistencyCheckIncompleteException {
        this.doShouldMigrateSystemDatabase(systemDbMigration, neo4jLayout -> {
            StoreMigrationTestUtils.Result result = this.migrate((Neo4jLayout)neo4jLayout, "--verbose", "neo4j");
            ((AbstractIntegerAssert)Assertions.assertThat((int)result.exitCode()).withFailMessage(result.err(), new Object[0])).isEqualTo(0);
            result = this.migrate((Neo4jLayout)neo4jLayout, "--verbose", "system");
            ((AbstractIntegerAssert)Assertions.assertThat((int)result.exitCode()).withFailMessage(result.err(), new Object[0])).isEqualTo(0);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doShouldMigrateSystemDatabase(SystemDbMigration systemDbMigration, Consumer<Neo4jLayout> migrate) throws IOException, ConsistencyCheckIncompleteException {
        Path targetDirectory = this.directory.homePath();
        Neo4jLayout neo4jLayout = Neo4jLayout.of((Path)targetDirectory);
        systemDbMigration.zippedStore.unzip(targetDirectory);
        migrate.accept(neo4jLayout);
        InitialIndexStateMonitor initialIndexStateMonitor = new InitialIndexStateMonitor("system");
        DatabaseManagementService dbms = this.newDbmsBuilder(targetDirectory).setConfig(GraphDatabaseInternalSettings.allow_single_automatic_upgrade, (Object)false).setMonitors(initialIndexStateMonitor.monitors()).build();
        try {
            GraphDatabaseService system = dbms.database("system");
            DatabaseMigrationITBase.verifyInitialIndexState(initialIndexStateMonitor);
            DatabaseMigrationITBase.verifyGraphComponents(system);
            DatabaseMigrationITBase.verifyTokenIndexes(system);
            DatabaseMigrationITBase.verifyKernelVersion(system);
            this.verifySystemDbSchema(system, systemDbMigration);
            this.verifyRemovedIndexProviders(system);
            DatabaseMigrationITBase.verifyFulltextIndexes(system, systemDbMigration.zippedStore.statistics().kernelVersion());
            GraphDatabaseService neo4j = dbms.database("neo4j");
            try (Transaction tx = neo4j.beginTx();){
                tx.createNode();
                tx.commit();
            }
        }
        finally {
            dbms.shutdown();
        }
        DatabaseMigrationITBase.consistencyCheck(targetDirectory, "system");
    }

    protected void verifyContents(GraphDatabaseService db, DbStatistics statistics) {
        this.verifyContents(db, statistics, DatabaseMigrationITBase.expectedIndexesAfterUpgrade(statistics), DatabaseMigrationITBase.expectedConstraintsAfterUpgrade(statistics));
    }

    protected void verifyContents(GraphDatabaseService db, DbStatistics statistics, int expectedIndexesAfterUpgrade, int expectedConstraintsAfterUpgrade) {
        try (Transaction tx = db.beginTx();){
            MutableInt numberOfNodes = new MutableInt();
            MutableInt numberOfNodeProperties = new MutableInt();
            MutableInt numberOfRelationships = new MutableInt();
            MutableInt numberOfRelationshipProperties = new MutableInt();
            org.neo4j.internal.helpers.collection.Iterables.forEach((Iterable)tx.getAllNodes(), node -> {
                numberOfNodeProperties.add(node.getAllProperties().size());
                numberOfNodes.increment();
            });
            org.neo4j.internal.helpers.collection.Iterables.forEach((Iterable)tx.getAllRelationships(), relationship -> {
                numberOfRelationshipProperties.add(relationship.getAllProperties().size());
                numberOfRelationships.increment();
            });
            int numberOfSchemaIndexes = Iterables.count((Iterable)tx.schema().getIndexes());
            int numberOfConstraints = Iterables.count((Iterable)tx.schema().getConstraints());
            Assertions.assertThat((int)numberOfNodes.intValue()).isEqualTo(statistics.nodes());
            Assertions.assertThat((int)numberOfNodeProperties.intValue()).isEqualTo(statistics.nodeProperties());
            Assertions.assertThat((int)numberOfRelationships.intValue()).isEqualTo(statistics.relationships());
            Assertions.assertThat((int)numberOfRelationshipProperties.intValue()).isEqualTo(statistics.relationshipProperties());
            Assertions.assertThat((int)numberOfSchemaIndexes).isEqualTo(expectedIndexesAfterUpgrade);
            Assertions.assertThat((int)numberOfConstraints).isEqualTo(expectedConstraintsAfterUpgrade);
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static int expectedIndexesAfterUpgrade(DbStatistics statistics) {
        return statistics.indexes() + DatabaseMigrationITBase.additionalIndexAfterUpgrade(statistics) - statistics.btreeIndexes();
    }

    private static int expectedConstraintsAfterUpgrade(DbStatistics statistics) {
        return statistics.constraints() - statistics.btreeConstraints();
    }

    private static int additionalIndexAfterUpgrade(DbStatistics statistics) {
        return statistics.kernelVersion().isLessThan(KernelVersion.VERSION_IN_WHICH_TOKEN_INDEXES_ARE_INTRODUCED) ? 1 : 0;
    }

    protected void verifyStoreFormat(GraphDatabaseService db, RecordFormats expectedFormat) {
        GraphDatabaseAPI database = (GraphDatabaseAPI)db;
        MetaDataStore metaDataStore = (MetaDataStore)database.getDependencyResolver().resolveDependency(MetaDataStore.class);
        StoreId storeId = metaDataStore.getStoreId();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedFormat.getFormatFamily().name(), (Object)storeId.getFormatName());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedFormat.majorVersion(), (int)storeId.getMajorVersion());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedFormat.minorVersion(), (int)storeId.getMinorVersion());
    }

    protected static void verifyTokenIndexes(GraphDatabaseService db) {
        List<IndexDefinition> tokenIndexes;
        try (Transaction tx = db.beginTx();){
            tokenIndexes = StreamSupport.stream(tx.schema().getIndexes().spliterator(), false).filter(i -> i.getIndexType() == org.neo4j.graphdb.schema.IndexType.LOOKUP).toList();
        }
        int size = tokenIndexes.size();
        Assertions.assertThat((int)size).isGreaterThan(0).isLessThanOrEqualTo(2);
        if (size == 1) {
            IndexDescriptor descriptor = ((IndexDefinitionImpl)tokenIndexes.get(0)).getIndexReference();
            Assertions.assertThat((long)descriptor.getId()).isGreaterThanOrEqualTo(0L);
            Assertions.assertThat((Comparable)descriptor.schema().entityType()).isEqualTo((Object)EntityType.NODE);
        } else if (size == 2) {
            IndexDescriptor descriptor = ((IndexDefinitionImpl)tokenIndexes.get(0)).getIndexReference();
            IndexDescriptor descriptor2 = ((IndexDefinitionImpl)tokenIndexes.get(1)).getIndexReference();
            Assertions.assertThat((long)descriptor.getId()).isGreaterThanOrEqualTo(0L);
            Assertions.assertThat((long)descriptor2.getId()).isGreaterThanOrEqualTo(0L);
            Assertions.assertThat((Comparable)descriptor.schema().entityType()).isNotEqualTo((Object)descriptor2.schema().entityType());
        }
    }

    protected static void verifyKernelVersion(GraphDatabaseService db) {
        GraphDatabaseAPI database = (GraphDatabaseAPI)db;
        KernelVersionProvider kernelVersionProvider = (KernelVersionProvider)database.getDependencyResolver().resolveDependency(KernelVersionProvider.class);
        Assertions.assertThat((Comparable)kernelVersionProvider.kernelVersion()).isEqualTo((Object)LatestVersions.LATEST_KERNEL_VERSION);
    }

    protected void verifyRemovedIndexProviders(GraphDatabaseService db) {
        FileSystemAbstraction fs = this.directory.getFileSystem();
        DatabaseLayout databaseLayout = ((GraphDatabaseAPI)db).databaseLayout();
        Path nativeBtreeDir = DatabaseMigrationITBase.getIndexProviderDirectoryStructure(databaseLayout, SchemaRule44.NATIVE_BTREE_10).rootDirectory();
        IndexDirectoryStructure luceneNativeDir = DatabaseMigrationITBase.getIndexProviderDirectoryStructure(databaseLayout, SchemaRule44.LUCENE_NATIVE_30);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.fileExists(nativeBtreeDir)).as("index directory should have been removed during migration", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.fileExists(luceneNativeDir.rootDirectory())).as("index directory should have been removed during migration", new Object[0])).isFalse();
    }

    private static IndexDirectoryStructure getIndexProviderDirectoryStructure(DatabaseLayout databaseLayout, IndexProviderDescriptor indexProviderDescriptor) {
        return IndexDirectoryStructure.directoriesByProvider((Path)databaseLayout.databaseDirectory()).forProvider(indexProviderDescriptor);
    }

    protected static void verifyFulltextIndexes(GraphDatabaseService db, KernelVersion version) {
        if (version.isLessThan(KernelVersion.V5_0)) {
            try (Transaction tx = db.beginTx();){
                org.neo4j.internal.helpers.collection.Iterables.stream((Iterable)tx.schema().getIndexes()).filter(i -> i.getIndexType() == org.neo4j.graphdb.schema.IndexType.FULLTEXT).forEach(IndexDefinition::drop);
                tx.commit();
            }
        }
    }

    private static void verifyInitialIndexState(InitialIndexStateMonitor initialIndexStateMonitor) {
        Assertions.assertThat((Map)initialIndexStateMonitor.allIndexStates).isNotEmpty();
        for (Map.Entry internalIndexStateEntry : initialIndexStateMonitor.allIndexStates.entrySet()) {
            Assertions.assertThat((Comparable)((IndexDescriptor)internalIndexStateEntry.getKey()).getIndexType()).isIn(new Object[]{IndexType.LOOKUP, IndexType.RANGE});
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((InternalIndexState)internalIndexStateEntry.getValue())).withFailMessage(internalIndexStateEntry.getKey() + " was not ONLINE as expected: " + internalIndexStateEntry.getValue(), new Object[0])).isEqualTo((Object)InternalIndexState.ONLINE);
        }
    }

    private static void verifyGraphComponents(GraphDatabaseService system) {
        SystemGraphComponents systemGraphComponents = (SystemGraphComponents)((GraphDatabaseAPI)system).getDependencyResolver().resolveDependency(SystemGraphComponents.class);
        try (Transaction tx = system.beginTx();){
            systemGraphComponents.forEach(component -> DatabaseMigrationITBase.assertCurrent(tx, component));
            tx.commit();
        }
    }

    private static void assertCurrent(Transaction tx, SystemGraphComponent component) {
        SystemGraphComponent.Status status = component.detect(tx);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)status).withFailMessage("SystemGraphComponent " + component.componentName() + " was not upgraded, state=" + status, new Object[0])).isEqualTo((Object)SystemGraphComponent.Status.CURRENT);
    }

    protected static void verifyHasUniqueConstraint(List<ConstraintDefinition> constraints, Label label, String ... property) {
        Assertions.assertThat(constraints).anySatisfy(constraintDefinition -> {
            Assertions.assertThat((Comparable)constraintDefinition.getConstraintType()).isEqualTo((Object)ConstraintType.UNIQUENESS);
            Assertions.assertThat((Object)constraintDefinition.getLabel()).isEqualTo((Object)label);
            Assertions.assertThat((List)org.neo4j.internal.helpers.collection.Iterables.asList((Iterable)constraintDefinition.getPropertyKeys())).isEqualTo(Arrays.asList(property));
        });
    }

    protected static void verifyHasIndex(List<IndexDefinition> indexes, Label label, String ... property) {
        Assertions.assertThat(indexes).anySatisfy(indexDefinition -> {
            Assertions.assertThat((Comparable)indexDefinition.getIndexType()).isEqualTo((Object)org.neo4j.graphdb.schema.IndexType.RANGE);
            Assertions.assertThat((boolean)indexDefinition.isNodeIndex()).isEqualTo(true);
            Assertions.assertThat((List)org.neo4j.internal.helpers.collection.Iterables.asList((Iterable)indexDefinition.getLabels())).isEqualTo(List.of(label));
            Assertions.assertThat((List)org.neo4j.internal.helpers.collection.Iterables.asList((Iterable)indexDefinition.getPropertyKeys())).isEqualTo(Arrays.asList(property));
        });
    }

    protected static void consistencyCheck(Path targetDirectory, String databaseName) throws ConsistencyCheckIncompleteException {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Config config = Config.newBuilder().set(GraphDatabaseSettings.pagecache_memory, (Object)ByteUnit.mebiBytes((long)8L)).set(GraphDatabaseSettings.logs_directory, (Object)targetDirectory.resolve("inconsistency-reports")).build();
        ConsistencyCheckService.Result consistencyCheckResult = new ConsistencyCheckService((DatabaseLayout)RecordDatabaseLayout.of((Neo4jLayout)Neo4jLayout.of((Path)targetDirectory), (String)databaseName)).with(config).with((InternalLogProvider)logProvider).runFullConsistencyCheck();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)consistencyCheckResult.isSuccessful()).as(logProvider.serialize(), new Object[0])).isTrue();
    }

    public record SystemDbMigration(ZippedStore zippedStore, boolean hasRelationshipTypeIndex) {
    }
}

