/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.community.edition;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseInfo;
import org.neo4j.dbms.database.DatabaseInfoService;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
public class DefaultDatabaseInfoServiceIT {
    @Inject
    private TestDirectory testDirectory;
    private DatabaseManagementService dbms;

    @BeforeEach
    void setUp() {
        this.dbms = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath()).build();
    }

    @AfterEach
    void tearDown() {
        this.dbms.shutdown();
    }

    @Test
    void shouldBeAvailableInDependencyResolver() {
        DependencyResolver dependencyResolver = ((GraphDatabaseAPI)this.dbms.database("neo4j")).getDependencyResolver();
        Assertions.assertTrue((boolean)dependencyResolver.containsDependency(DatabaseInfoService.class));
    }

    @Test
    void shouldReturnInfoForAllExistingDatabases() {
        DependencyResolver dependencyResolver = ((GraphDatabaseAPI)this.dbms.database("neo4j")).getDependencyResolver();
        DatabaseInfoService databaseInfoService = (DatabaseInfoService)dependencyResolver.resolveDependency(DatabaseInfoService.class);
        NamedDatabaseId nonExistingDatabase = DatabaseIdFactory.from((String)"unknown", (UUID)UUID.randomUUID());
        Set existingDatabases = this.dbms.listDatabases().stream().map(this::getIdForName).collect(Collectors.toSet());
        HashSet allDatabases = new HashSet(existingDatabases);
        allDatabases.add(nonExistingDatabase);
        List results = databaseInfoService.lookupCachedInfo(allDatabases, null);
        Map returnedDatabases = results.stream().collect(Collectors.toMap(DatabaseInfo::namedDatabaseId, Function.identity()));
        AssertionsForClassTypes.assertThat((int)returnedDatabases.size()).isEqualTo(allDatabases.size());
        AssertionsForClassTypes.assertThat((String)((DatabaseInfo)returnedDatabases.get(nonExistingDatabase)).status()).isEqualTo("unknown");
        AssertionsForClassTypes.assertThat((String)((DatabaseInfo)returnedDatabases.get(existingDatabases.iterator().next())).status()).isEqualTo("online");
    }

    NamedDatabaseId getIdForName(String name) {
        NamedDatabaseId namedDatabaseId;
        block8: {
            Transaction tx = this.dbms.database("system").beginTx();
            try {
                String temp = ((Node)tx.findNodes(TopologyGraphDbmsModel.DATABASE_LABEL, "name", (Object)name).next()).getProperty("uuid").toString();
                namedDatabaseId = DatabaseIdFactory.from((String)name, (UUID)UUID.fromString(temp));
                if (tx == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tx != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Assertions.fail((Throwable)e);
                    return null;
                }
            }
            tx.close();
        }
        return namedDatabaseId;
    }
}

